/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zairus.megaloot.item.MLItem;
import zairus.megaloot.item.MLItemArmor;
import zairus.megaloot.item.MLItemBauble;
import zairus.megaloot.item.MLItemInfused;
import zairus.megaloot.item.MLItemShard;
import zairus.megaloot.item.MLItemToolAxe;
import zairus.megaloot.item.MLItemToolPickaxe;
import zairus.megaloot.item.MLItemToolShovel;
import zairus.megaloot.item.MLItemTypeRegistry;
import zairus.megaloot.item.MLItemWeaponBow;
import zairus.megaloot.item.MLItemWeaponCase;
import zairus.megaloot.item.MLItemWeaponSword;
import zairus.megaloot.loot.LootRarity;
import zairus.megaloot.loot.LootSet;

@GameRegistry.ObjectHolder(value="megaloot")
public class MLItems {
    @GameRegistry.ObjectHolder(value="weaponcase_common")
    public static final Item WEAPONCASE_COMMON;
    @GameRegistry.ObjectHolder(value="weaponcase_rare")
    public static final Item WEAPONCASE_RARE;
    @GameRegistry.ObjectHolder(value="weaponcase_epic")
    public static final Item WEAPONCASE_EPIC;
    @GameRegistry.ObjectHolder(value="weaponsword")
    public static final Item WEAPONSWORD;
    @GameRegistry.ObjectHolder(value="weaponbow")
    public static final Item WEAPONBOW;
    @GameRegistry.ObjectHolder(value="baublering")
    public static final Item BAUBLERING;
    @GameRegistry.ObjectHolder(value="armor_boots")
    public static final Item ARMOR_BOOTS;
    @GameRegistry.ObjectHolder(value="armor_leggings")
    public static final Item ARMOR_LEGGINGS;
    @GameRegistry.ObjectHolder(value="armor_chestplate")
    public static final Item ARMOR_CHESTPLATE;
    @GameRegistry.ObjectHolder(value="armor_helmet")
    public static final Item ARMOR_HELMET;
    @GameRegistry.ObjectHolder(value="tool_axe")
    public static final Item TOOL_AXE;
    @GameRegistry.ObjectHolder(value="tool_pickaxe")
    public static final Item TOOL_PICKAXE;
    @GameRegistry.ObjectHolder(value="tool_shovel")
    public static final Item TOOL_SHOVEL;
    @GameRegistry.ObjectHolder(value="shard_common")
    public static final Item SHARD_COMMON;
    @GameRegistry.ObjectHolder(value="shard_rare")
    public static final Item SHARD_RARE;
    @GameRegistry.ObjectHolder(value="shard_epic")
    public static final Item SHARD_EPIC;
    @GameRegistry.ObjectHolder(value="upgradecharm_common")
    public static final Item UPGRADECHARM_COMMON;
    @GameRegistry.ObjectHolder(value="upgradecharm_rare")
    public static final Item UPGRADECHARM_RARE;
    @GameRegistry.ObjectHolder(value="upgradecharm_epic")
    public static final Item UPGRADECHARM_EPIC;
    @GameRegistry.ObjectHolder(value="rift_stone")
    public static final Item RIFT_STONE;
    @GameRegistry.ObjectHolder(value="infused_emerald_common")
    public static final Item INFUSED_EMERALD_COMMON;
    @GameRegistry.ObjectHolder(value="infused_emerald_rare")
    public static final Item INFUSED_EMERALD_RARE;
    protected static final List<Item> ITEMS;

    public static void initialize() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (Item item : ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("megaloot:" + item.func_77658_a().substring(5), "inventory"));
        }
    }

    @Nullable
    public static LootSet.LootSetType getItemType(Item item) {
        return MLItemTypeRegistry.get(item);
    }

    public static Item initItem(Item item, String id) {
        item.setRegistryName(new ResourceLocation("megaloot", id));
        item.func_77655_b(id);
        ITEMS.add(item);
        return item;
    }

    static {
        ITEMS = new ArrayList<Item>();
        WEAPONCASE_COMMON = MLItems.initItem(new MLItemWeaponCase(LootRarity.COMMON), "weaponcase_common");
        WEAPONCASE_RARE = MLItems.initItem(new MLItemWeaponCase(LootRarity.RARE), "weaponcase_rare");
        WEAPONCASE_EPIC = MLItems.initItem(new MLItemWeaponCase(LootRarity.EPIC), "weaponcase_epic");
        WEAPONSWORD = MLItems.initItem((Item)new MLItemWeaponSword(), "weaponsword");
        WEAPONBOW = MLItems.initItem((Item)new MLItemWeaponBow(), "weaponbow");
        BAUBLERING = MLItems.initItem(new MLItemBauble(), "baublering");
        ARMOR_BOOTS = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.FEET), "armor_boots");
        ARMOR_LEGGINGS = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.LEGS), "armor_leggings");
        ARMOR_CHESTPLATE = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.CHEST), "armor_chestplate");
        ARMOR_HELMET = MLItems.initItem((Item)new MLItemArmor(EntityEquipmentSlot.HEAD), "armor_helmet");
        TOOL_AXE = MLItems.initItem((Item)new MLItemToolAxe(), "tool_axe");
        TOOL_PICKAXE = MLItems.initItem((Item)new MLItemToolPickaxe(), "tool_pickaxe");
        TOOL_SHOVEL = MLItems.initItem((Item)new MLItemToolShovel(), "tool_shovel");
        SHARD_COMMON = MLItems.initItem(new MLItemShard(LootRarity.COMMON), "shard_common");
        SHARD_RARE = MLItems.initItem(new MLItemShard(LootRarity.RARE), "shard_rare");
        SHARD_EPIC = MLItems.initItem(new MLItemShard(LootRarity.EPIC), "shard_epic");
        UPGRADECHARM_COMMON = MLItems.initItem(new MLItemShard(LootRarity.COMMON).setRenderEffect(false), "upgradecharm_common");
        UPGRADECHARM_RARE = MLItems.initItem(new MLItemShard(LootRarity.RARE).setRenderEffect(false), "upgradecharm_rare");
        UPGRADECHARM_EPIC = MLItems.initItem(new MLItemShard(LootRarity.EPIC).setRenderEffect(false), "upgradecharm_epic");
        RIFT_STONE = MLItems.initItem(new MLItem(), "rift_stone");
        INFUSED_EMERALD_COMMON = MLItems.initItem(new MLItemInfused(), "infused_emerald_common");
        INFUSED_EMERALD_RARE = MLItems.initItem(new MLItemInfused(), "infused_emerald_rare");
        MLItemTypeRegistry.register(WEAPONSWORD, LootSet.LootSetType.SWORD);
        MLItemTypeRegistry.register(WEAPONBOW, LootSet.LootSetType.BOW);
        MLItemTypeRegistry.register(BAUBLERING, LootSet.LootSetType.RING);
        MLItemTypeRegistry.register(ARMOR_BOOTS, LootSet.LootSetType.ARMOR_FEET);
        MLItemTypeRegistry.register(ARMOR_LEGGINGS, LootSet.LootSetType.ARMOR_LEGS);
        MLItemTypeRegistry.register(ARMOR_CHESTPLATE, LootSet.LootSetType.ARMOR_CHEST);
        MLItemTypeRegistry.register(ARMOR_HELMET, LootSet.LootSetType.ARMOR_HEAD);
        MLItemTypeRegistry.register(TOOL_AXE, LootSet.LootSetType.TOOL);
        MLItemTypeRegistry.register(TOOL_PICKAXE, LootSet.LootSetType.TOOL);
        MLItemTypeRegistry.register(TOOL_SHOVEL, LootSet.LootSetType.TOOL);
    }

    @Mod.EventBusSubscriber(modid="megaloot")
    public static class ItemRegistry {
        public static final Set<Item> ITEM_SET = new HashSet<Item>();

        @SubscribeEvent
        public static void newRegistry(RegistryEvent.NewRegistry event) {
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (Item item : ITEMS) {
                registry.register((IForgeRegistryEntry)item);
                ITEM_SET.add(item);
            }
            MLItems.initialize();
        }
    }
}

