/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.loot;

import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.MLConfig;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootRarity;
import zairus.megaloot.loot.LootWeaponEffect;
import zairus.megaloot.util.RandomCollection;

public class LootItemHelper {
    public static ItemStack getRandomLoot(Random rand, LootRarity rarity) {
        RandomCollection<Item> col = new RandomCollection<Item>(rand);
        col.add(3.0, MLItems.WEAPONSWORD);
        col.add(3.0, MLItems.WEAPONBOW);
        col.add(rarity != LootRarity.COMMON ? 1 : 0, MLItems.BAUBLERING);
        col.add(1.0, MLItems.ARMOR_HELMET);
        col.add(1.0, MLItems.ARMOR_CHESTPLATE);
        col.add(1.0, MLItems.ARMOR_LEGGINGS);
        col.add(1.0, MLItems.ARMOR_BOOTS);
        col.add(3.0, MLItems.TOOL_AXE);
        col.add(3.0, MLItems.TOOL_PICKAXE);
        col.add(3.0, MLItems.TOOL_SHOVEL);
        ItemStack stack = new ItemStack((Item)col.next());
        return stack;
    }

    public static NBTTagList getLootTagList(ItemStack stack, String key) {
        NBTTagList list = new NBTTagList();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            list = stack.func_77978_p().func_74775_l("MegaLoot").func_150295_c(key, 10);
        }
        return list;
    }

    public static void setLootTagList(ItemStack stack, String key, NBTTagList value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74782_a(key, (NBTBase)value);
    }

    public static int getLootIntValue(ItemStack stack, String key) {
        int value = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            value = stack.func_77978_p().func_74775_l("MegaLoot").func_74762_e(key);
        }
        return value;
    }

    public static void setLootBooleanValue(ItemStack stack, String key, boolean value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74757_a(key, value);
    }

    public static boolean getLootBooleanValue(ItemStack stack, String key) {
        boolean value = false;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            value = stack.func_77978_p().func_74775_l("MegaLoot").func_74767_n(key);
        }
        return value;
    }

    public static void setLootIntValue(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74768_a(key, value);
    }

    public static float getLootFloatValue(ItemStack stack, String key) {
        float value = 0.0f;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            value = stack.func_77978_p().func_74775_l("MegaLoot").func_74760_g(key);
        }
        return value;
    }

    public static void setLootFlaotValue(ItemStack stack, String key, float value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74776_a(key, value);
    }

    public static String getLootStringValue(ItemStack stack, String key) {
        String value = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MegaLoot") && stack.func_77978_p().func_74775_l("MegaLoot").func_74764_b(key)) {
            value = stack.func_77978_p().func_74775_l("MegaLoot").func_74779_i(key);
        }
        return value;
    }

    public static void setLootStringValue(ItemStack stack, String key, String value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("MegaLoot")) {
            stack.func_77978_p().func_74782_a("MegaLoot", (NBTBase)new NBTTagCompound());
        }
        stack.func_77978_p().func_74775_l("MegaLoot").func_74778_a(key, value);
    }

    public static int getMaxDamage(ItemStack stack) {
        int maxDamage = LootItemHelper.getLootIntValue(stack, "durability");
        if (maxDamage == 0) {
            maxDamage = 100;
        }
        return maxDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(ItemStack stack, List<String> tooltip) {
        LootItemHelper.addInformation(stack, tooltip, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInformation(ItemStack stack, List<String> tooltip, boolean show_durability) {
        int upgrades;
        int durability = stack.func_77958_k();
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
        for (LootWeaponEffect effect : effects) {
            if (effect == LootWeaponEffect.ARMOR || effect == LootWeaponEffect.TOUGHNESS) continue;
            tooltip.add(TextFormatting.RESET + "- " + effect.getType().getColor() + I18n.func_74837_a((String)("weaponeffect." + effect.getId() + ".description"), (Object[])new Object[]{effect.getDurationString(stack, effect.getId()), effect.getAmplifierString(stack, effect.getId()), effect.getAmplifierString(stack, effect.getId(), 1), TextFormatting.WHITE + effect.getActionStatus(stack)}) + (effect.getType().equals(LootWeaponEffect.EffectType.USE) ? TextFormatting.WHITE + " [Shift+Right Click]" : ""));
        }
        LootRarity rarity = LootRarity.fromId(LootItemHelper.getLootStringValue(stack, "rarity"));
        if (rarity != null) {
            tooltip.add("Rarity: " + rarity.getColor() + rarity.getId());
        }
        if (show_durability) {
            tooltip.add(TextFormatting.RESET + "" + durability + "" + TextFormatting.GRAY + " Durability");
        }
        if ((upgrades = LootItemHelper.getLootIntValue(stack, "upgrades")) <= 0) {
            tooltip.add(TextFormatting.YELLOW + "" + TextFormatting.ITALIC + "Exhausted");
        } else {
            tooltip.add(TextFormatting.YELLOW + "Upgrades: " + TextFormatting.BOLD + "" + TextFormatting.WHITE + "" + upgrades);
        }
        int kills = LootItemHelper.getLootIntValue(stack, "playerkills");
        if (kills > 0) {
            tooltip.add(TextFormatting.RED + "" + kills + " Player Kills");
        }
    }

    public static boolean hasEffect(ItemStack stack, LootWeaponEffect effect) {
        if (!MLConfig.effectActive(effect)) {
            return false;
        }
        boolean hasEffect = false;
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
        for (LootWeaponEffect e : effects) {
            if (e != effect) continue;
            hasEffect = true;
            break;
        }
        return hasEffect;
    }
}

