/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.sound;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="megaloot")
public class MLSoundEvents {
    public static final SoundEvent WEAPON_LOOP;
    public static final SoundEvent BLADE;
    public static final SoundEvent POWER;
    public static final SoundEvent DRAW;
    public static final SoundEvent BOW_OPEN;
    public static final SoundEvent CASE_OPEN;
    public static final SoundEvent TOOL_REPAIR;
    public static final SoundEvent TOOL_BREAK;
    public static final SoundEvent TOOL_PUT;
    public static final SoundEvent TOOL_TAKE;
    public static final SoundEvent SNORE;
    public static final SoundEvent THRUST;
    protected static final List<SoundEvent> SOUNDS;

    private static SoundEvent registerSound(ResourceLocation location) {
        SoundEvent sound = (SoundEvent)new SoundEvent(location).setRegistryName(location);
        SOUNDS.add(sound);
        return sound;
    }

    private static SoundEvent registerSound(String location) {
        return MLSoundEvents.registerSound(new ResourceLocation("megaloot", location));
    }

    static {
        SOUNDS = new ArrayList<SoundEvent>();
        WEAPON_LOOP = MLSoundEvents.registerSound("weapon_loop");
        BLADE = MLSoundEvents.registerSound("blade");
        POWER = MLSoundEvents.registerSound("power");
        DRAW = MLSoundEvents.registerSound("draw");
        BOW_OPEN = MLSoundEvents.registerSound("bow_open");
        CASE_OPEN = MLSoundEvents.registerSound("case_open");
        TOOL_REPAIR = MLSoundEvents.registerSound("tool_repair");
        TOOL_BREAK = MLSoundEvents.registerSound("tool_break");
        TOOL_PUT = MLSoundEvents.registerSound("tool_put");
        TOOL_TAKE = MLSoundEvents.registerSound("tool_take");
        SNORE = MLSoundEvents.registerSound("snore");
        THRUST = MLSoundEvents.registerSound("thrust");
    }

    @Mod.EventBusSubscriber(modid="megaloot")
    public static class SoundRegistry {
        @SubscribeEvent
        public static void register(RegistryEvent.Register<SoundEvent> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.registerAll((IForgeRegistryEntry[])SOUNDS.toArray(new SoundEvent[0]));
        }
    }
}

