/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.tileentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import zairus.megaloot.inventory.MLContainerBase;
import zairus.megaloot.tileentity.capabilities.MLItemHandler;

public abstract class MLTileEntityBase
extends TileEntityLockableLoot
implements ITickable {
    public int playersUsing;
    protected String field_190577_o;
    protected String defaultName = "MLContainer";

    public abstract ItemStack[] getChestContents();

    public abstract void setChestContents(ItemStack[] var1);

    public abstract int getSlotXOffset();

    public abstract int getSlotYOffset();

    public abstract Slot getSlot(IInventory var1, int var2, int var3, int var4);

    @Nullable
    public abstract SoundEvent getOpenSound();

    @Nullable
    public abstract SoundEvent getCloseSound();

    @Nullable
    public abstract SoundEvent getItemPlaceSound();

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getTextures();

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new MLItemHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.func_184281_d(player);
        return new MLContainerBase((IInventory)playerInventory, (IInventory)this, player);
    }

    public String func_174875_k() {
        return "megaloot:" + this.defaultName;
    }

    public String getGUIDisplayName() {
        return this.func_145818_k_() ? this.field_190577_o : "Mega Loot Tile";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container." + this.defaultName;
    }

    public boolean func_145818_k_() {
        return this.field_190577_o != null;
    }

    public void func_190575_a(String name) {
        this.field_190577_o = name;
    }

    public int func_70302_i_() {
        return this.getChestContents() != null ? this.getChestContents().length : 0;
    }

    public boolean func_191420_l() {
        boolean empty = true;
        for (int i = 0; this.getChestContents() != null && i < this.getChestContents().length; ++i) {
            if (this.getChestContents()[i] == null) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public ItemStack func_70301_a(int index) {
        if (this.getChestContents() == null || index >= this.getChestContents().length) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.getChestContents()[index];
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        if (this.getChestContents() != null && this.getChestContents()[index] != null) {
            if (this.getChestContents()[index].func_190916_E() <= count) {
                ItemStack itemstack1 = this.getChestContents()[index];
                this.getChestContents()[index] = ItemStack.field_190927_a;
                this.func_70296_d();
                return itemstack1;
            }
            ItemStack itemstack = this.getChestContents()[index].func_77979_a(count);
            if (this.getChestContents()[index].func_190916_E() == 0) {
                this.getChestContents()[index] = ItemStack.field_190927_a;
            }
            this.func_70296_d();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        this.func_184281_d(null);
        if (this.getChestContents() != null && this.getChestContents()[index] != null) {
            ItemStack itemstack = this.getChestContents()[index];
            this.getChestContents()[index] = ItemStack.field_190927_a;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        if (this.getChestContents() == null) {
            return;
        }
        if (index >= this.getChestContents().length) {
            return;
        }
        this.getChestContents()[index] = stack;
        if (stack != null && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.playersUsing < 0) {
                this.playersUsing = 0;
            }
            ++this.playersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.playersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), true);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.playersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.playersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), true);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.func_184281_d(null);
        for (int i = 0; this.getChestContents() != null && i < this.getChestContents().length; ++i) {
            this.getChestContents()[i] = ItemStack.field_190927_a;
        }
    }

    public void func_73660_a() {
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.setChestContents(new ItemStack[this.func_70302_i_()]);
        if (!this.func_184283_b(compound)) {
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                byte j = nbttagcompound.func_74771_c("Slot");
                if (j < 0 || this.getChestContents() == null || j >= this.getChestContents().length) continue;
                ItemStack itemstack = new ItemStack(nbttagcompound);
                this.func_70299_a(j, itemstack);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; this.getChestContents() != null && i < this.getChestContents().length; ++i) {
                if (this.getChestContents()[i] == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                this.getChestContents()[i].func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return compound;
    }

    public void func_145836_u() {
        super.func_145836_u();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.playersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public static MLMaterialSlot getSpecialSlot(IInventory inv, int index, int x, int y, Item ... validItems) {
        MLMaterialSlot slot = new MLMaterialSlot(inv, index, x, y, validItems);
        return slot;
    }

    public static class MLMaterialSlot
    extends Slot {
        private List<Item> validItems = new ArrayList<Item>();
        private boolean locked = false;

        public MLMaterialSlot(IInventory inventory, int index, int xPosition, int yPosition, Item ... validItems) {
            super(inventory, index, xPosition, yPosition);
            if (validItems != null) {
                for (Item i : validItems) {
                    this.validItems.add(i);
                }
            }
        }

        public MLMaterialSlot setLocked(boolean locked) {
            this.locked = locked;
            return this;
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return this.validItems.contains(stack.func_77973_b());
        }

        public boolean func_82869_a(EntityPlayer player) {
            boolean canTake = super.func_82869_a(player);
            if (this.locked) {
                canTake = false;
            }
            return canTake;
        }

        public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            stack = super.func_190901_a(thePlayer, stack);
            return stack;
        }

        public boolean func_75216_d() {
            if (this.func_75211_c() == null) {
                return false;
            }
            return super.func_75216_d();
        }

        public ItemStack func_75211_c() {
            ItemStack stack = super.func_75211_c();
            return stack == null ? ItemStack.field_190927_a : stack;
        }
    }
}

