/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.tileentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.item.MLItemShard;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootRarity;
import zairus.megaloot.loot.LootSet;
import zairus.megaloot.loot.LootWeaponEffect;
import zairus.megaloot.sound.MLSoundEvents;
import zairus.megaloot.tileentity.MLTileEntityBase;

public class MLTileEntityDisenchanter
extends MLTileEntityBase {
    private ItemStack[] chestContents = new ItemStack[3];
    private final int disenchantStepDuration = 50;
    private int disenchantCounter = 0;
    private int disenchantStep = 0;
    private boolean disenchaning = false;
    private int tick = 0;
    private EntityPlayer disenchanterPlayer;

    @Override
    public void func_73660_a() {
        if (this.disenchaning) {
            this.disenchant();
            this.tick = (this.tick + 1) % 20;
            if (this.tick == 0) {
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 0);
            }
        }
        super.func_73660_a();
    }

    public void setDisenchanterPlayer(EntityPlayer disenchanter) {
        this.disenchanterPlayer = disenchanter;
    }

    public int getDisenchantStep() {
        return this.disenchantStep;
    }

    @Override
    public ItemStack[] getChestContents() {
        return this.chestContents;
    }

    @Override
    public void setChestContents(ItemStack[] contents) {
        this.chestContents = contents;
    }

    @Override
    public int getSlotXOffset() {
        return 0;
    }

    @Override
    public int getSlotYOffset() {
        return 0;
    }

    @Override
    public Slot getSlot(IInventory inv, int index, int x, int y) {
        Slot slot = new Slot(inv, index, x, y);
        return slot;
    }

    @Override
    public SoundEvent getOpenSound() {
        return null;
    }

    @Override
    public SoundEvent getCloseSound() {
        return null;
    }

    @Override
    public SoundEvent getItemPlaceSound() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextures() {
        return null;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        NonNullList items = NonNullList.func_191196_a();
        for (ItemStack stack : this.chestContents) {
            items.add((Object)(stack == null ? ItemStack.field_190927_a : stack));
        }
        return items;
    }

    public void applyUpgrade(ItemStack upgrade, ItemStack tool) {
        LootWeaponEffect me;
        MLItemShard upgradeItem = (MLItemShard)upgrade.func_77973_b();
        LootRarity upgradeRarity = upgradeItem.getShardRariry();
        LootRarity toolRarity = LootRarity.fromId(LootItemHelper.getLootStringValue(tool, "rarity"));
        if (toolRarity == null || toolRarity != upgradeRarity) {
            return;
        }
        int upgrades = LootItemHelper.getLootIntValue(tool, "upgrades");
        if (upgrades <= 0) {
            return;
        }
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(tool);
        LootSet.LootSetType type = MLItems.getItemType(tool.func_77973_b());
        if (!effects.contains(LootWeaponEffect.ARMOR)) {
            effects.add(LootWeaponEffect.ARMOR);
        }
        if (!effects.contains(LootWeaponEffect.TOUGHNESS)) {
            effects.add(LootWeaponEffect.TOUGHNESS);
        }
        if ((me = LootWeaponEffect.getRandomExcluding(this.field_145850_b.field_73012_v, type, effects)) != null) {
            NBTTagList effectList = LootItemHelper.getLootTagList(tool, "effectList");
            effectList.func_74742_a((NBTBase)me.getNBT(this.field_145850_b.field_73012_v));
            if (me == LootWeaponEffect.LIFE_LONG) {
                tool.func_77978_p().func_74757_a("Unbreakable", true);
            }
            LootItemHelper.setLootTagList(tool, "effectList", effectList);
            upgrade.func_190918_g(1);
            if (--upgrades < 0) {
                upgrades = 0;
            }
            LootItemHelper.setLootIntValue(tool, "upgrades", upgrades);
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), MLSoundEvents.TOOL_REPAIR, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void applyRepair() {
        ItemStack material = this.func_70301_a(0);
        ItemStack toRepair = this.func_70301_a(1);
        if (material == null || material == ItemStack.field_190927_a || material.func_190916_E() == 0 || toRepair == null || toRepair == ItemStack.field_190927_a || toRepair.func_190916_E() == 0) {
            return;
        }
        if (material.func_77973_b() == MLItems.UPGRADECHARM_COMMON || material.func_77973_b() == MLItems.UPGRADECHARM_RARE || material.func_77973_b() == MLItems.UPGRADECHARM_EPIC) {
            this.applyUpgrade(material, toRepair);
            return;
        }
        if (toRepair.func_77952_i() == 0) {
            return;
        }
        int newDamage = toRepair.func_77952_i() - (int)((double)toRepair.func_77958_k() * 0.33);
        if (newDamage < 0) {
            newDamage = 0;
        }
        if (material.func_77973_b() instanceof MLItemShard) {
            LootRarity materialRarity = ((MLItemShard)material.func_77973_b()).getShardRariry();
            LootRarity toolRarity = LootRarity.fromId(LootItemHelper.getLootStringValue(toRepair, "rarity"));
            if (materialRarity == null || toolRarity == null) {
                return;
            }
            if (materialRarity == toolRarity) {
                material.func_190918_g(1);
                toRepair.func_77964_b(newDamage);
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), MLSoundEvents.TOOL_REPAIR, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void disenchantStart() {
        if (this.disenchaning) {
            return;
        }
        ItemStack tool = this.func_70301_a(1);
        if (tool == null || tool == ItemStack.field_190927_a || tool.func_190916_E() == 0) {
            return;
        }
        this.disenchantCounter = 0;
        this.disenchantStep = 1;
        this.disenchaning = true;
    }

    public void disenchantStop() {
        this.disenchaning = false;
        this.disenchantCounter = 0;
        this.disenchantStep = 0;
    }

    private void disenchant() {
        ItemStack tool = this.func_70301_a(1);
        if (tool == null || tool == ItemStack.field_190927_a || tool.func_190916_E() == 0) {
            this.disenchantStop();
            return;
        }
        ++this.disenchantCounter;
        if (this.disenchantCounter >= this.disenchantStepDuration) {
            this.disenchantCounter = 0;
            ++this.disenchantStep;
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), MLSoundEvents.TOOL_BREAK, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (this.disenchantStep > 3) {
                NBTTagCompound playerTag;
                ItemStack result = this.func_70301_a(2);
                if (result == null) {
                    result = ItemStack.field_190927_a;
                }
                int model = LootItemHelper.getLootIntValue(tool, "model");
                LootRarity toolRarity = LootRarity.fromId(LootItemHelper.getLootStringValue(tool, "rarity"));
                int shardCount = 1 + this.field_145850_b.field_73012_v.nextInt(5);
                Item shardItem = MLItems.SHARD_COMMON;
                if (toolRarity == LootRarity.RARE) {
                    shardItem = MLItems.SHARD_RARE;
                }
                if (toolRarity == LootRarity.EPIC) {
                    shardItem = MLItems.SHARD_EPIC;
                }
                ItemStack shards = new ItemStack(shardItem, shardCount);
                if (!result.func_190926_b() && !result.func_77969_a(shards)) {
                    this.disenchantStop();
                    return;
                }
                if (shards.func_77973_b() == result.func_77973_b()) {
                    if ((shardCount += result.func_190916_E()) > result.func_77976_d()) {
                        this.disenchantStop();
                        return;
                    }
                    result.func_190920_e(shardCount);
                } else {
                    result = shards;
                }
                if (this.disenchanterPlayer != null && (playerTag = this.disenchanterPlayer.getEntityData()) != null) {
                    int[] modelList;
                    NBTTagCompound playerLootTag = playerTag.func_74764_b("megaloot") ? playerTag.func_74775_l("megaloot") : new NBTTagCompound();
                    NBTTagCompound skinTag = playerLootTag.func_74764_b("loot_skins") ? playerLootTag.func_74775_l("loot_skins") : new NBTTagCompound();
                    LootSet.LootSetType type = MLItems.getItemType(tool.func_77973_b());
                    String classKey = type.getId();
                    if (classKey == "tool") {
                        if (tool.func_77973_b() instanceof ItemPickaxe) {
                            classKey = "pickaxe";
                        }
                        if (tool.func_77973_b() instanceof ItemAxe) {
                            classKey = "axe";
                        }
                        if (tool.func_77973_b() instanceof ItemSpade) {
                            classKey = "shovel";
                        }
                    }
                    if ((modelList = skinTag.func_74759_k(classKey)) == null || modelList.length == 0) {
                        modelList = new int[]{model};
                    } else {
                        ArrayList<Integer> ml = new ArrayList<Integer>();
                        for (int m : modelList) {
                            ml.add(m);
                        }
                        if (!ml.contains(model)) {
                            ml.add(model);
                        }
                        modelList = ml.stream().mapToInt(i -> i).toArray();
                    }
                    skinTag.func_74783_a(classKey, modelList);
                    playerLootTag.func_74782_a("loot_skins", (NBTBase)skinTag);
                    playerTag.func_74782_a("megaloot", (NBTBase)playerLootTag);
                }
                this.func_70299_a(1, ItemStack.field_190927_a);
                this.func_70299_a(2, result);
            }
            this.func_70296_d();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound c = super.func_189515_b(compound);
        c.func_74768_a("disenchantCounter", this.disenchantCounter);
        c.func_74768_a("disenchantStep", this.disenchantStep);
        c.func_74757_a("disenchaning", this.disenchaning);
        return c;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.disenchantCounter = compound.func_74762_e("disenchantCounter");
        this.disenchantStep = compound.func_74762_e("disenchantStep");
        this.disenchaning = compound.func_74767_n("disenchaning");
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

