/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.megaloot.item.MLItems;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootSet;
import zairus.megaloot.sound.MLSoundEvents;
import zairus.megaloot.tileentity.MLTileEntityBase;

public class MLTileEntitySkinTable
extends MLTileEntityBase {
    private ItemStack[] chestContents = new ItemStack[9];
    private int offset = 0;

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack[] getChestContents() {
        return this.chestContents;
    }

    @Override
    public void setChestContents(ItemStack[] contents) {
        this.chestContents = contents;
    }

    @Override
    public int getSlotXOffset() {
        return 0;
    }

    @Override
    public int getSlotYOffset() {
        return 0;
    }

    @Override
    public Slot getSlot(IInventory inv, int index, int x, int y) {
        Slot slot = new Slot(inv, index, x, y);
        return slot;
    }

    @Override
    public SoundEvent getOpenSound() {
        return null;
    }

    @Override
    public SoundEvent getCloseSound() {
        return null;
    }

    @Override
    public SoundEvent getItemPlaceSound() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextures() {
        return null;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        NonNullList items = NonNullList.func_191196_a();
        for (ItemStack stack : this.chestContents) {
            items.add((Object)(stack == null ? ItemStack.field_190927_a : stack));
        }
        return items;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void populateSkins(EntityPlayer player, boolean copyResult, int offsetChange) {
        NBTTagCompound playerLootTag;
        NBTTagCompound playerTag = player.getEntityData();
        ItemStack tool = this.func_70301_a(0);
        if (copyResult) {
            this.offset = 0;
        }
        this.offset += offsetChange;
        if (this.offset < 0) {
            this.offset = 0;
        }
        if (tool != null && !tool.func_190926_b() && playerTag.func_74764_b("megaloot") && (playerLootTag = playerTag.func_74775_l("megaloot")).func_74764_b("loot_skins")) {
            NBTTagCompound skinTag = playerLootTag.func_74775_l("loot_skins");
            LootSet.LootSetType type = MLItems.getItemType(tool.func_77973_b());
            String classKey = type.getId();
            if (classKey == "tool") {
                if (tool.func_77973_b() instanceof ItemPickaxe) {
                    classKey = "pickaxe";
                }
                if (tool.func_77973_b() instanceof ItemAxe) {
                    classKey = "axe";
                }
                if (tool.func_77973_b() instanceof ItemSpade) {
                    classKey = "shovel";
                }
            }
            int[] modelList = skinTag.func_74759_k(classKey);
            int skinSlot = 2;
            int modelCount = 0;
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), MLSoundEvents.TOOL_PUT, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (this.offset >= modelList.length) {
                this.offset = modelList.length - 1;
            }
            for (int sl = 2; sl < this.chestContents.length; ++sl) {
                this.func_70299_a(sl, ItemStack.field_190927_a);
            }
            for (int m : modelList) {
                if (modelCount >= this.offset) {
                    ItemStack skin = tool.func_77946_l();
                    LootItemHelper.setLootIntValue(skin, "model", m);
                    this.func_70299_a(skinSlot, skin.func_77946_l());
                    if (++skinSlot >= this.chestContents.length) break;
                }
                ++modelCount;
            }
        }
        if (copyResult) {
            this.func_70299_a(1, tool.func_77946_l());
        }
        if (tool.func_190926_b()) {
            for (int i = 2; i < 9; ++i) {
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 0);
        this.func_70296_d();
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = super.func_70304_b(index);
        return stack;
    }

    public void clearInput() {
        if (this.chestContents[0] == null) {
            this.chestContents[0] = ItemStack.field_190927_a;
        }
        if (!this.chestContents[0].func_190926_b()) {
            this.chestContents[0] = ItemStack.field_190927_a;
            for (int i = 2; i < this.chestContents.length; ++i) {
                this.chestContents[i] = ItemStack.field_190927_a;
            }
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), MLSoundEvents.TOOL_TAKE, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 0);
        this.func_70296_d();
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
    }
}

