/*
 * Decompiled with CFR 0.152.
 */
package zairus.megaloot.util.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import zairus.megaloot.loot.LootItemHelper;
import zairus.megaloot.loot.LootWeaponEffect;
import zairus.megaloot.util.network.MLPacket;

public class MLPacketJetpack
extends MLPacket {
    private boolean forward = false;
    private boolean back = false;
    private boolean left = false;
    private boolean right = false;
    private boolean jump = false;
    private boolean sneak = false;

    public MLPacketJetpack() {
    }

    public MLPacketJetpack(boolean f, boolean b, boolean l, boolean r, boolean j, boolean s) {
        this.forward = f;
        this.back = b;
        this.left = l;
        this.right = r;
        this.jump = j;
        this.sneak = s;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBoolean(this.forward);
        buffer.writeBoolean(this.back);
        buffer.writeBoolean(this.left);
        buffer.writeBoolean(this.right);
        buffer.writeBoolean(this.jump);
        buffer.writeBoolean(this.sneak);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.forward = buffer.readBoolean();
        this.back = buffer.readBoolean();
        this.left = buffer.readBoolean();
        this.right = buffer.readBoolean();
        this.jump = buffer.readBoolean();
        this.sneak = buffer.readBoolean();
        buffer.release();
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        ItemStack chestplate = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chestplate == null || chestplate.func_190926_b() || !LootItemHelper.hasEffect(chestplate, LootWeaponEffect.JETPACK)) {
            return;
        }
        float s = (float)LootWeaponEffect.getDurationFromStack(chestplate, LootWeaponEffect.JETPACK.getId()) / 100.0f;
        double speed = (double)s / 10.0;
        if (this.jump) {
            player.field_70181_x = speed;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)player));
        }
        if (!player.field_70122_E) {
            float yaw = player.field_70177_z;
            float pitch = 0.0f;
            float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
            float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
            Vec3d vForward = new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
            Vec3d vLeft = new Vec3d(vForward.field_72449_c, vForward.field_72448_b, -vForward.field_72450_a);
            double mX = 0.0;
            double mZ = 0.0;
            if (this.forward) {
                mX += vForward.field_72450_a * speed;
                mZ += vForward.field_72449_c * speed;
            }
            if (this.back) {
                mX += vForward.field_72450_a * -speed;
                mZ += vForward.field_72449_c * -speed;
            }
            if (this.left) {
                mX += vLeft.field_72450_a * speed;
                mZ += vLeft.field_72449_c * speed;
            }
            if (this.right) {
                mX += vLeft.field_72450_a * -speed;
                mZ += vLeft.field_72449_c * -speed;
            }
            player.field_70159_w = mX;
            player.field_70179_y = mZ;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)player));
        }
    }
}

