/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.mod;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zabi.minecraft.minerva.common.capability.SimpleCapability;
import zabi.minecraft.minerva.common.crafting.ColorMedalRecipeHandler;
import zabi.minecraft.minerva.common.mod.ItemSupporterMedal;
import zabi.minecraft.minerva.common.mod.proxy.IProxy;
import zabi.minecraft.minerva.common.network.NetworkHandler;

@Mod(name="Minerva", modid="minerva", version="1.0.13", certificateFingerprint="b851b8b7c7f4d8d0e910ff27618150ba80c026ec", guiFactory="zabi.minecraft.minerva.client.hud.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Minerva {
    public static final String ID = "minerva";
    public static final String NAME = "Minerva";
    public static final String VERSION = "1.0.13";
    public static final String FINGERPRINT = "b851b8b7c7f4d8d0e910ff27618150ba80c026ec";
    @SidedProxy(clientSide="zabi.minecraft.minerva.common.mod.proxy.ClientProxy", serverSide="zabi.minecraft.minerva.common.mod.proxy.CommonProxy")
    public static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        proxy.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkHandler.init();
        SimpleCapability.setup(NetworkHandler.HANDLER);
        proxy.init();
    }

    @SubscribeEvent
    public void onItemRegistration(RegistryEvent.Register<Item> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)ItemSupporterMedal.INSTANCE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new ColorMedalRecipeHandler());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand(new ICommand(){

            public int compareTo(ICommand arg0) {
                return 0;
            }

            public boolean func_82358_a(String[] args, int index) {
                return false;
            }

            public String func_71518_a(ICommandSender sender) {
                return "/mv-medal";
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
                return Lists.newArrayList();
            }

            public String func_71517_b() {
                return "ea-medal";
            }

            public List<String> func_71514_a() {
                return Lists.newArrayList((Object[])new String[]{"mv-medal"});
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (sender instanceof EntityPlayer) {
                    if (ItemSupporterMedal.giveMedal((EntityPlayer)sender)) {
                        return;
                    }
                    throw new CommandException("You are not a registered contributor of Zabi94!", new Object[0]);
                }
                throw new CommandException("Only players can execute this command", new Object[0]);
            }

            public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
                return true;
            }
        });
    }
}

