/*
 * Decompiled with CFR 0.152.
 */
package jmn.mods.mtqfix;

import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmTransformer
implements IClassTransformer {
    private static Logger logger = FMLLog.getLogger();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.startsWith("net.minecraft.network.NetHandlerPlayServer")) {
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            if (this.analyzeClass(node)) {
                ClassWriter writer = new ClassWriter(3);
                node.accept((ClassVisitor)writer);
                bytes = writer.toByteArray();
            }
        }
        return bytes;
    }

    private boolean analyzeClass(ClassNode node) {
        boolean rval = false;
        for (MethodNode method : node.methods) {
            if (method.name.equals("processVehicleMove") || method.name.equals("a") && method.desc.equals("(Lll;)V")) {
                rval = this.disableMovedTooQuickly(method);
            }
            if (!method.name.equals("processPlayer") && (!method.name.equals("a") || !method.desc.equals("(Llk;)V"))) continue;
            rval = this.disableMovedTooQuickly2(method);
        }
        return rval;
    }

    private boolean disableMovedTooQuickly(MethodNode node) {
        MovedTooQuicklyState state = MovedTooQuicklyState.FIND_LDC;
        InsnList insnList = node.instructions;
        AbstractInsnNode patchTarget = null;
        LabelNode gotoLabel = null;
        block6: for (AbstractInsnNode insn = insnList.getFirst(); insn != null && state != MovedTooQuicklyState.DONE; insn = insn.getNext()) {
            switch (state) {
                case FIND_LDC: {
                    Object value;
                    if (insn.getOpcode() != 18 || !((value = ((LdcInsnNode)insn).cst) instanceof Double) || (Double)value != 100.0) continue block6;
                    state = MovedTooQuicklyState.FIND_DCMPL;
                    continue block6;
                }
                case FIND_DCMPL: {
                    if (insn.getOpcode() == 151) {
                        state = MovedTooQuicklyState.FIND_IFLE;
                        continue block6;
                    }
                    state = MovedTooQuicklyState.FIND_LDC;
                    continue block6;
                }
                case FIND_IFLE: {
                    if (insn.getOpcode() == 158) {
                        state = MovedTooQuicklyState.DONE;
                        gotoLabel = ((JumpInsnNode)insn).label;
                        patchTarget = insn;
                        continue block6;
                    }
                    state = MovedTooQuicklyState.FIND_LDC;
                    continue block6;
                }
                case DONE: {
                    continue block6;
                }
            }
        }
        if (state == MovedTooQuicklyState.DONE) {
            this.applyGotoPatch(insnList, gotoLabel, patchTarget);
            return true;
        }
        return false;
    }

    private boolean disableMovedTooQuickly2(MethodNode node) {
        MovedTooQuicklyState state = MovedTooQuicklyState.FIND_LDC;
        InsnList insnList = node.instructions;
        AbstractInsnNode patchTarget = null;
        LabelNode gotoLabel = null;
        block6: for (AbstractInsnNode insn = insnList.getFirst(); insn != null && state != MovedTooQuicklyState.DONE; insn = insn.getNext()) {
            switch (state) {
                case FIND_LDC: {
                    if (insn.getOpcode() != 141) continue block6;
                    state = MovedTooQuicklyState.FIND_DCMPL;
                    continue block6;
                }
                case FIND_DCMPL: {
                    if (insn.getOpcode() == 151) {
                        state = MovedTooQuicklyState.FIND_IFLE;
                        continue block6;
                    }
                    state = MovedTooQuicklyState.FIND_LDC;
                    continue block6;
                }
                case FIND_IFLE: {
                    if (insn.getOpcode() == 158) {
                        state = MovedTooQuicklyState.DONE;
                        gotoLabel = ((JumpInsnNode)insn).label;
                        patchTarget = insn;
                        continue block6;
                    }
                    state = MovedTooQuicklyState.FIND_LDC;
                    continue block6;
                }
                case DONE: {
                    continue block6;
                }
            }
        }
        if (state == MovedTooQuicklyState.DONE) {
            this.applyGotoPatch(insnList, gotoLabel, patchTarget);
            return true;
        }
        return false;
    }

    private void applyGotoPatch(InsnList instructions, LabelNode label, AbstractInsnNode target) {
        logger.info("mtqfix inserting statement: \"goto " + label.getLabel().toString() + "\"");
        InsnList patch = new InsnList();
        patch.add((AbstractInsnNode)new JumpInsnNode(167, label));
        instructions.insert(target, patch);
    }

    private static enum MovedTooQuicklyState {
        FIND_LDC,
        FIND_DCMPL,
        FIND_IFLE,
        DONE;

    }
}

