/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.item.tool;

import com.google.common.collect.Sets;
import epicsquid.mysticallib.item.ItemHoeBase;
import epicsquid.mysticallib.item.tool.IEffectiveTool;
import epicsquid.mysticallib.item.tool.ILimitAxis;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemPloughBase
extends ItemHoeBase
implements IEffectiveTool,
ILimitAxis {
    public static Set<Block> EFFECTIVE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_185774_da, Blocks.field_150346_d, Blocks.field_150458_ak});
    private static Set<Material> EFFECTIVE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151578_c});
    private static Set<EnumFacing.Axis> AXES_LIMIT = Sets.newHashSet((Object[])new EnumFacing.Axis[]{EnumFacing.Axis.Y});

    public ItemPloughBase(Item.ToolMaterial material, String name, int toolLevel, int maxDamage, Supplier<Ingredient> repair) {
        super(material, name, toolLevel, maxDamage, repair);
        this.setHarvestLevel("shovel", material.func_77996_d());
    }

    @Override
    public int getWidth(ItemStack stack) {
        return 3;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos origin, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        boolean failed = false;
        int width = this.getWidth(itemstack);
        width = width % 2 == 0 ? (width /= 2) : (width - 1) / 2;
        int uses = 0;
        for (int x = -width; x < width + 1; ++x) {
            block5: for (int z = -width; z < width + 1; ++z) {
                BlockPos pos = origin.func_177982_a(x, 0, z);
                if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
                    failed = true;
                    continue;
                }
                failed = false;
                int hook = ForgeEventFactory.onHoeUse((ItemStack)itemstack, (EntityPlayer)player, (World)worldIn, (BlockPos)pos);
                if (hook != 0) {
                    if (hook > 0) continue;
                    failed = true;
                    continue;
                }
                IBlockState iblockstate = worldIn.func_180495_p(pos);
                Block block = iblockstate.func_177230_c();
                IBlockState newState = Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7));
                if (facing == EnumFacing.DOWN || !worldIn.func_175623_d(pos.func_177984_a())) continue;
                if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, newState, 11);
                        worldIn.func_184138_a(pos, newState, newState, 8);
                    }
                    ++uses;
                    continue;
                }
                if (block == Blocks.field_150458_ak && (Integer)iblockstate.func_177229_b((IProperty)BlockFarmland.field_176531_a) < 7) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, newState, 11);
                        worldIn.func_184138_a(pos, newState, newState, 8);
                    }
                    ++uses;
                    continue;
                }
                if (block != Blocks.field_150346_d) continue;
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        if (!worldIn.field_72995_K) {
                            worldIn.func_180501_a(pos, newState, 11);
                            worldIn.func_184138_a(pos, newState, newState, 8);
                        }
                        ++uses;
                        continue block5;
                    }
                    case COARSE_DIRT: {
                        if (!worldIn.field_72995_K) {
                            newState = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
                            worldIn.func_180501_a(pos, newState, 11);
                            worldIn.func_184138_a(pos, newState, newState, 8);
                        }
                        ++uses;
                    }
                }
            }
        }
        if (uses > 0 && !worldIn.field_72995_K) {
            worldIn.func_184133_a(null, origin, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            itemstack.func_77972_a(3 + field_77697_d.nextInt(Math.max(1, uses - 3)), (EntityLivingBase)player);
        }
        if (failed || uses == 0) {
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public Set<Material> getEffectiveMaterials() {
        return EFFECTIVE_MATERIALS;
    }

    @Override
    public boolean displayBreak() {
        return false;
    }

    @Override
    public Set<EnumFacing.Axis> getLimits() {
        return AXES_LIMIT;
    }
}

