/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import epicsquid.mysticallib.item.tool.ISizedTool;
import epicsquid.mysticallib.item.tool.ItemPloughBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BreakUtil {
    public static Set<BlockPos> nearbyBlocks(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Item tool = itemstack.func_77973_b();
        Block block = state.func_177230_c();
        String harvestTool = block.getHarvestTool(state);
        Set toolClasses = tool.getToolClasses(itemstack);
        boolean plough = tool instanceof ItemPloughBase;
        if (!(tool instanceof ISizedTool)) {
            return Collections.emptySet();
        }
        if (state.func_185887_b(world, pos) == 0.0f) {
            return Collections.emptySet();
        }
        if (harvestTool != null && !toolClasses.contains(harvestTool)) {
            return Collections.emptySet();
        }
        if (player.func_70093_af()) {
            return Collections.emptySet();
        }
        ISizedTool sized = (ISizedTool)tool;
        float hardness = state.func_185903_a(player, world, pos);
        if (hardness == 0.0f) {
            return Collections.emptySet();
        }
        RayTraceResult ray = BreakUtil.rayTrace(world, player);
        if (ray == null || ray.field_178784_b == null) {
            return Collections.emptySet();
        }
        int width = sized.getWidth(itemstack);
        width = width % 2 == 0 ? (width /= 2) : (width - 1) / 2;
        EnumFacing facing = ray.field_178784_b;
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (int x = -width; x < width + 1; ++x) {
            block6: for (int z = -width; z < width + 1; ++z) {
                BlockPos potential;
                if (x == 0 && z == 0) continue;
                switch (facing.func_176740_k()) {
                    case X: {
                        potential = pos.func_177982_a(0, x, z);
                        break;
                    }
                    case Y: {
                        potential = pos.func_177982_a(x, 0, z);
                        break;
                    }
                    case Z: {
                        potential = pos.func_177982_a(x, z, 0);
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                IBlockState potentialState = world.func_180495_p(potential);
                Material material = potentialState.func_185904_a();
                Block potentialBlock = potentialState.func_177230_c();
                if (plough && ItemPloughBase.EFFECTIVE_BLOCKS.contains(potentialBlock)) {
                    result.add(potential);
                    continue;
                }
                boolean toolRequired = !material.func_76229_l();
                String potentialHarvestTool = potentialBlock.getHarvestTool(potentialState);
                boolean matchingTool = potentialHarvestTool == null || toolClasses.contains(potentialHarvestTool);
                boolean forge = ForgeHooks.canHarvestBlock((Block)potentialState.func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)potential);
                float destroySpeed = tool.func_150893_a(itemstack, potentialState);
                if (toolRequired && !matchingTool && !forge || destroySpeed == 1.0f) continue;
                result.add(potential);
            }
        }
        return result;
    }

    public static boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Item tool = stack.func_77973_b();
        String harvestTool = block.getHarvestTool(state);
        Set harvestTools = tool.getToolClasses(stack);
        boolean matchingTool = harvestTool == null || harvestTools.contains(harvestTool);
        boolean toolRequired = state.func_185904_a().func_76229_l();
        if (toolRequired && !matchingTool && !ForgeHooks.canHarvestBlock((Block)state.func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        EntityPlayerMP playerMP = player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null;
        boolean creative = player.func_184812_l_();
        GameType type = playerMP == null ? null : playerMP.field_71134_c.func_73081_b();
        int xp = 0;
        if (playerMP != null && (xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)type, (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (!world.field_72995_K) {
            if (playerMP == null) {
                return false;
            }
            TileEntity te = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, !creative)) {
                block.func_176206_d(world, pos, state);
                if (!creative) {
                    block.func_180657_a(world, player, pos, state, te, stack);
                    if (xp > 0) {
                        block.func_180637_b(world, pos, xp);
                    }
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            BreakUtil.clientSideRemoval(state, world, pos, player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static void clientSideRemoval(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        Block block = state.func_177230_c();
        if (block.removedByPlayer(state, world, pos, player, !player.func_184812_l_())) {
            block.func_176206_d(world, pos, state);
        }
        Minecraft mc = Minecraft.func_71410_x();
        EnumFacing side = mc.field_71476_x.field_178784_b;
        CPacketPlayerDigging packet = new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, side);
        NetHandlerPlayClient connection = mc.func_147114_u();
        if (connection != null) {
            connection.func_147297_a((Packet)packet);
        }
    }

    public static RayTraceResult rayTrace(World world, EntityPlayer player) {
        Vec3d eyes = player.func_174824_e(1.0f);
        float yawCos = MathHelper.func_76134_b((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float yawSin = MathHelper.func_76126_a((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchCos = -MathHelper.func_76134_b((float)(-player.field_70125_A * ((float)Math.PI / 180)));
        float pitchSin = MathHelper.func_76126_a((float)(-player.field_70125_A * ((float)Math.PI / 180)));
        float f1 = yawSin * pitchCos;
        float f2 = yawCos * pitchCos;
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d reachVec = eyes.func_72441_c((double)f1 * reach, (double)pitchSin * reach, (double)f2 * reach);
        return world.func_147447_a(eyes, reachVec, false, true, true);
    }
}

