/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class Util {
    public static Random rand = new Random();

    public static int floatChance(float chance) {
        return (int)chance + (rand.nextFloat() < chance % 1.0f ? 1 : 0);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(World world, Class<? extends T> classEntity, BlockPos pos, float xradius, float yradius, float zradius) {
        return world.func_72872_a(classEntity, new AxisAlignedBB((double)((float)pos.func_177958_n() - xradius), (double)((float)pos.func_177956_o() - yradius), (double)((float)pos.func_177952_p() - zradius), (double)((float)(pos.func_177958_n() + 1) + xradius), (double)((float)(pos.func_177956_o() + 1) + yradius), (double)((float)(pos.func_177952_p() + 1) + zradius)));
    }

    public static List<EntityLiving> getEntitiesWithinRadius(World world, Predicate<Entity> comparison, BlockPos pos, float xradius, float yradius, float zradius) {
        return world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)((float)pos.func_177958_n() - xradius), (double)((float)pos.func_177956_o() - yradius), (double)((float)pos.func_177952_p() - zradius), (double)((float)(pos.func_177958_n() + 1) + xradius), (double)((float)(pos.func_177956_o() + 1) + yradius), (double)((float)(pos.func_177952_p() + 1) + zradius))).stream().filter(comparison).collect(Collectors.toList());
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Block ... block) {
        HashSet blocks = Sets.newHashSet((Object[])block);
        return Util.getBlocksWithinRadius(world, pos, xradius, yradius, zradius, blocks);
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Set<Block> blocks) {
        return Util.getBlocksWithinRadius(world, pos, xradius, yradius, zradius, (BlockPos test) -> blocks.contains(world.func_180495_p(test).func_177230_c()));
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Block block) {
        return Util.getBlocksWithinRadius(world, pos, xradius, yradius, zradius, (BlockPos test) -> world.func_180495_p(test).func_177230_c() == block);
    }

    public static List<BlockPos> getBlocksWithinRadius(World world, BlockPos pos, float xradius, float yradius, float zradius, Predicate<BlockPos> comparison) {
        ArrayList<BlockPos> blockList = new ArrayList<BlockPos>();
        int x = (int)(-xradius);
        while ((float)x <= xradius) {
            int z = (int)(-zradius);
            while ((float)z <= zradius) {
                int y = (int)(-yradius);
                while ((float)y <= yradius) {
                    if (comparison.test(pos.func_177982_a(x, y, z))) {
                        blockList.add(pos.func_177982_a(x, y, z));
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        return blockList;
    }

    public static BlockPos getRandomWithinRadius(BlockPos pos, int xradius, int yradius, int zradius) {
        int x = pos.func_177958_n() - xradius + rand.nextInt(xradius * 2 + 1);
        int y = pos.func_177956_o() - yradius + rand.nextInt(yradius * 2 + 1);
        int z = pos.func_177952_p() - zradius + rand.nextInt(zradius * 2 + 1);
        return new BlockPos(x, y, z);
    }

    public static List<BlockPos> getPositionsWithinCircle(BlockPos center, int r) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int x = center.func_177958_n();
        int z = center.func_177952_p();
        int y = center.func_177956_o();
        int r2 = r * r;
        for (int i = z - r; i < z + r; ++i) {
            int j = x;
            while ((j - x) * (j - x) + (i - z) * (i - z) <= r2) {
                positions.add(new BlockPos(j, y, i));
                --j;
            }
            j = x + 1;
            while ((j - x) * (j - x) + (i - z) * (i - z) <= r2) {
                positions.add(new BlockPos(j, y, i));
                ++j;
            }
        }
        return positions;
    }

    public static List<BlockPos> getBlocksWithinCircle(World world, BlockPos pos, int r, Block ... block) {
        List<Block> blocks = Arrays.asList(block);
        return Util.getBlocksWithinCircle(world, pos, r, (BlockPos test) -> blocks.contains(world.func_180495_p(test).func_177230_c()));
    }

    public static List<BlockPos> getBlocksWithinCircle(World world, BlockPos pos, int r, Block block) {
        return Util.getBlocksWithinCircle(world, pos, r, (BlockPos test) -> world.func_180495_p(test).func_177230_c() == block);
    }

    public static List<BlockPos> getBlocksWithinCircle(World world, BlockPos center, int r, Predicate<BlockPos> predicate) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int x = center.func_177958_n();
        int z = center.func_177952_p();
        int y = center.func_177956_o();
        int r2 = r * r;
        for (int i = z - r; i < z + r; ++i) {
            BlockPos pos;
            int j = x;
            while ((j - x) * (j - x) + (i - z) * (i - z) <= r2) {
                pos = new BlockPos(j, y, i);
                if (predicate.test(pos)) {
                    positions.add(pos);
                }
                --j;
            }
            j = x + 1;
            while ((j - x) * (j - x) + (i - z) * (i - z) <= r2) {
                pos = new BlockPos(j, y, i);
                if (predicate.test(pos)) {
                    positions.add(pos);
                }
                ++j;
            }
        }
        return positions;
    }

    @Nonnull
    public static String lowercase(@Nonnull String s) {
        String f = "";
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if (c.toUpperCase().compareTo(c) == 0) {
                if (i > 0) {
                    f = f + "_";
                }
                f = f + c.toLowerCase();
                continue;
            }
            f = f + c;
        }
        return f;
    }

    public static int intColor(int r, int g, int b) {
        return -16777216 + r * 65536 + g * 256 + b;
    }

    @Nonnull
    public static String getLowercaseClassName(@Nonnull Class c) {
        String[] nameParts = c.getTypeName().split("\\.");
        String className = nameParts[nameParts.length - 1];
        return Util.lowercase(className);
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).func_190926_b()) continue;
                world.func_72838_d((Entity)new EntityItem(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }

    public static void appendLoreTag(ItemStack stack, String ... lines) {
        NBTTagList lore;
        NBTTagCompound display;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        if (!tag.func_74764_b("display") || !(tag.func_74781_a("display") instanceof NBTTagCompound)) {
            display = new NBTTagCompound();
            tag.func_74782_a("display", (NBTBase)display);
        } else {
            display = tag.func_74775_l("display");
        }
        if (!display.func_74764_b("Lore") || !(display.func_74781_a("Lore") instanceof NBTTagList)) {
            lore = new NBTTagList();
            display.func_74782_a("Lore", (NBTBase)lore);
        } else {
            lore = display.func_150295_c("Lore", 8);
        }
        for (String string : lines) {
            lore.func_74742_a((NBTBase)new NBTTagString(string));
        }
    }
}

