/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.block;

import epicsquid.mysticallib.block.BlockBase;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlimePuddle
extends BlockBase {
    public static AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    public BlockSlimePuddle(@Nonnull Material mat, @Nonnull SoundType type, float hardness, @Nonnull String name) {
        super(mat, type, hardness, name);
        this.field_149765_K = 0.8f;
        this.field_149783_u = true;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        return iblockstate.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    private boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return false;
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151123_aH;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public int func_149679_a(int fortune, Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.func_70093_af()) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        } else {
            entityIn.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (entityIn.func_70093_af()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (Math.abs(entityIn.field_70181_x) < 0.1 && !entityIn.func_70093_af()) {
            double d0 = 0.4 + Math.abs(entityIn.field_70181_x) * 0.2;
            entityIn.field_70159_w *= d0;
            entityIn.field_70179_y *= d0;
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }
}

