/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.materials;

import epicsquid.mysticallib.block.BlockOreBase;
import epicsquid.mysticallib.event.RegisterContentEvent;
import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.materials.Material;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;

public class MaterialQuartz
extends Material {
    public BlockOreBase stoneOre;
    public BlockOreBase graniteOre;

    public MaterialQuartz(@Nonnull String oredictNameSuffix, float hardness, float experience, int level, int minXP, int maxXP, Item.ToolMaterial material, boolean hasTool) {
        super(oredictNameSuffix, hardness, experience, level, minXP, maxXP, material, hasTool);
    }

    @Override
    public String name() {
        return "quartz";
    }

    @Override
    public boolean isEnabled() {
        return ConfigManager.quartz.enableQuartz;
    }

    @Override
    public boolean hasOre() {
        return ConfigManager.quartz.enableGraniteOres || ConfigManager.quartz.enableStoneOres;
    }

    @Override
    @Nullable
    public Block getOre() {
        if (this.hasOre()) {
            if (ConfigManager.quartz.enableGraniteOres) {
                return this.graniteOre;
            }
            if (ConfigManager.quartz.enableStoneOres) {
                return this.stoneOre;
            }
        }
        return null;
    }

    @Override
    public void initMaterial(@Nonnull RegisterContentEvent event) {
        this.stoneOre = (BlockOreBase)new BlockOreBase(net.minecraft.block.material.Material.field_151576_e, SoundType.field_185851_d, this.getHardness(), this.name() + "_ore", Items.field_151128_bU, this.getLevel(), this.getMinXP(), this.getMaxXP()).func_149647_a(MysticalWorld.tab);
        event.addBlock((Block)this.stoneOre);
        this.graniteOre = (BlockOreBase)new BlockOreBase(net.minecraft.block.material.Material.field_151576_e, SoundType.field_185851_d, this.getHardness(), "granite_" + this.name() + "_ore", Items.field_151128_bU, this.getLevel(), this.getMinXP(), this.getMaxXP()).func_149647_a(MysticalWorld.tab);
        event.addBlock((Block)this.graniteOre);
        if (ConfigManager.quartz.enableGraniteOres) {
            this.setOre((Block)this.graniteOre);
        } else {
            this.setOre((Block)this.stoneOre);
        }
    }

    @Override
    public void initOreDictionary() {
        if (this.isEnabled() && this.hasOre()) {
            OreDictionary.registerOre((String)"oreQuartz", (Block)this.graniteOre);
            OreDictionary.registerOre((String)"oreQuartz", (Block)this.stoneOre);
        }
    }
}

