/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity.player;

import epicsquid.mysticalworld.capability.PlayerShoulderCapability;
import epicsquid.mysticalworld.capability.PlayerShoulderCapabilityProvider;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="mysticalworld", value={Side.CLIENT})
public class ShoulderRenderer {
    @SideOnly(value=Side.CLIENT)
    private static double[] playerPosition(EntityPlayer player, float ticks) {
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)ticks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)ticks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)ticks;
        return new double[]{d0, d1, d2};
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    private static Entity resolveAnimal(EntityPlayer player, World world, PlayerShoulderCapability cap, float ticks) {
        Entity animal = EntityList.func_188429_b((ResourceLocation)cap.getRegistryName(), (World)world);
        if (animal != null) {
            animal.func_70020_e(cap.getAnimalSerialized());
            double[] d = ShoulderRenderer.playerPosition(player, ticks);
            animal.func_70080_a(d[0], d[1], d[2], 0.0f, 0.0f);
            animal.field_70126_B = 0.0f;
            animal.func_70034_d(0.0f);
        }
        return animal;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderHand(RenderHandEvent event) {
        Entity animal;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        float ticks = event.getPartialTicks();
        PlayerShoulderCapability cap = (PlayerShoulderCapability)player.getCapability(PlayerShoulderCapabilityProvider.PLAYER_SHOULDER_CAPABILITY, null);
        if (cap != null && cap.isShouldered() && (animal = ShoulderRenderer.resolveAnimal((EntityPlayer)player, (World)world, cap, ticks)) != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)50.0f, (float)50.0f, (float)50.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.2, (double)-0.1, (double)0.13);
            GlStateManager.func_179141_d();
            GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            if (mc.field_71474_y.field_74320_O == 0) {
                RenderHelper.func_74519_b();
                RenderManager renderManager = mc.func_175598_ae();
                renderManager.func_178633_a(false);
                renderManager.func_188388_a(animal, 0.0f, false);
                renderManager.func_178633_a(true);
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        Entity animal;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        EntityPlayer ePlayer = event.getEntityPlayer();
        WorldClient world = mc.field_71441_e;
        float ticks = event.getPartialRenderTick();
        PlayerShoulderCapability cap = (PlayerShoulderCapability)player.getCapability(PlayerShoulderCapabilityProvider.PLAYER_SHOULDER_CAPABILITY, null);
        if (cap != null && cap.isShouldered() && (animal = ShoulderRenderer.resolveAnimal((EntityPlayer)player, (World)world, cap, ticks)) != null) {
            double[] d = ShoulderRenderer.playerPosition(ePlayer, ticks);
            double[] c = ShoulderRenderer.playerPosition((EntityPlayer)player, ticks);
            double x = d[0] - c[0];
            double y = d[1] - c[1];
            double z = d[2] - c[2];
            animal.func_70107_b(c[0], c[1], c[2]);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-(ePlayer.field_70760_ar + (ePlayer.field_70761_aq - player.field_70760_ar) * ticks)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.32, (double)1.37, (double)0.0);
            if (player.func_70093_af()) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.3, (double)0.0);
            }
            RenderManager renderManager = mc.func_175598_ae();
            renderManager.func_178633_a(false);
            renderManager.func_188388_a(animal, 0.0f, false);
            renderManager.func_178633_a(true);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }
}

