/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.blocks;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.blocks.BlockPhasing;
import com.wuest.prefab.events.ModEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBoundary
extends Block {
    public static final PropertyBool Powered = PropertyBool.func_177716_a((String)"powered");
    public static final AxisAlignedBB Empty_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BlockBoundary(String name) {
        super((Material)BlockPhasing.BlockMaterial);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.6f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Powered, (Comparable)Boolean.valueOf(false)));
        ModRegistry.setBlockName(this, name);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        boolean poweredSide;
        super.func_180663_b(worldIn, pos, state);
        if (ModEventHandler.RedstoneAffectedBlockPositions.contains(pos)) {
            ModEventHandler.RedstoneAffectedBlockPositions.remove(pos);
        }
        if (poweredSide = worldIn.func_175640_z(pos)) {
            this.setNeighborGlassBlocksPoweredStatus(worldIn, pos, !poweredSide, 0, new ArrayList<BlockPos>(), false);
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)Powered);
        return layer == BlockRenderLayer.TRANSLUCENT && !powered || layer == BlockRenderLayer.SOLID && powered;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean poweredSide = world.func_175640_z(pos);
        if (poweredSide) {
            this.setNeighborGlassBlocksPoweredStatus(world, pos, poweredSide, 0, new ArrayList<BlockPos>(), false);
        }
        return this.func_176223_P().func_177226_a((IProperty)Powered, (Comparable)Boolean.valueOf(poweredSide));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        if (!worldIn.field_72995_K && blockIn.func_176223_P().func_185897_m()) {
            boolean poweredSide = worldIn.func_175640_z(pos);
            this.setNeighborGlassBlocksPoweredStatus(worldIn, pos, poweredSide, 0, new ArrayList<BlockPos>(), true);
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (meta % 2 == 0) {
            return this.func_176223_P().func_177226_a((IProperty)Powered, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)Powered, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)Powered);
        return powered ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Powered});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean advancedKeyDown = minecraft.field_71462_r.func_146272_n();
        if (!advancedKeyDown) {
            tooltip.add(GuiLangKeys.translateString("prefab.gui.tooltip.shift"));
        } else {
            tooltip.add(GuiLangKeys.translateString("prefab.gui.tooltip.boundary_block"));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185505_j;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)Powered)).booleanValue()) {
            return Empty_AABB;
        }
        return super.func_185496_a(state, source, pos);
    }

    @Nullable
    protected RayTraceResult func_185503_a(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        if (boundingBox == Empty_AABB) {
            return null;
        }
        return super.func_185503_a(pos, start, end, boundingBox);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(blockAccess, pos);
        if (axisalignedbb == Empty_AABB) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    protected void setNeighborGlassBlocksPoweredStatus(World world, BlockPos pos, boolean isPowered, int cascadeCount, ArrayList<BlockPos> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return;
        }
        if (setCurrentBlock) {
            IBlockState state = world.func_180495_p(pos);
            world.func_175656_a(pos, state.func_177226_a((IProperty)Powered, (Comparable)Boolean.valueOf(isPowered)));
        }
        cascadedBlockPos.add(pos);
        for (EnumFacing facing : EnumFacing.values()) {
            Block neighborBlock = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
            if (!(neighborBlock instanceof BlockBoundary)) continue;
            IBlockState blockState = world.func_180495_p(pos.func_177972_a(facing));
            boolean blockPowered = (Boolean)blockState.func_177229_b((IProperty)Powered);
            if (cascadedBlockPos.contains(pos.func_177972_a(facing))) continue;
            ((BlockBoundary)neighborBlock).setNeighborGlassBlocksPoweredStatus(world, pos.func_177972_a(facing), isPowered, cascadeCount, cascadedBlockPos, true);
        }
    }
}

