/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.AdvancedCoopOptions;
import com.wuest.prefab.structures.config.enums.AdvancedHorseStableOptions;
import com.wuest.prefab.structures.config.enums.AquaBaseOptions;
import com.wuest.prefab.structures.config.enums.BarnOptions;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.DefenseBunkerOptions;
import com.wuest.prefab.structures.config.enums.EnderGatewayOptions;
import com.wuest.prefab.structures.config.enums.GrassyPlainOptions;
import com.wuest.prefab.structures.config.enums.GreenHouseOptions;
import com.wuest.prefab.structures.config.enums.JailOptions;
import com.wuest.prefab.structures.config.enums.MachineryTowerOptions;
import com.wuest.prefab.structures.config.enums.MagicTempleOptions;
import com.wuest.prefab.structures.config.enums.MineshaftEntranceOptions;
import com.wuest.prefab.structures.config.enums.NetherGateOptions;
import com.wuest.prefab.structures.config.enums.SaloonOptions;
import com.wuest.prefab.structures.config.enums.WatchTowerOptions;
import com.wuest.prefab.structures.config.enums.WelcomeCenterOptions;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.predefined.StructureBasic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BasicStructureConfiguration
extends StructureConfiguration {
    private static final String structureEnumNameTag = "structureEnumName";
    private static final String structureDisplayNameTag = "structureDisplayName";
    private static final String bedColorTag = "bedColor";
    private static final String chosenOptionTag = "chosenOption";
    public EnumBasicStructureName basicStructureName;
    public String structureDisplayName;
    public EnumDyeColor bedColor;
    public BaseOption chosenOption;

    public String getDisplayName() {
        if (this.basicStructureName == EnumBasicStructureName.Custom) {
            return this.structureDisplayName;
        }
        return this.basicStructureName.getItemTranslationString();
    }

    public boolean IsCustomStructure() {
        return this.basicStructureName == EnumBasicStructureName.Custom;
    }

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = EnumFacing.NORTH;
        this.basicStructureName = EnumBasicStructureName.AdvancedCoop;
        this.bedColor = EnumDyeColor.RED;
        this.chosenOption = this.basicStructureName.baseOption.getSpecificOptions().get(0);
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        BasicStructureConfiguration basicConfig = (BasicStructureConfiguration)config;
        if (messageTag.func_74764_b(structureEnumNameTag)) {
            basicConfig.basicStructureName = EnumBasicStructureName.valueOf(messageTag.func_74779_i(structureEnumNameTag));
        }
        if (messageTag.func_74764_b(structureDisplayNameTag)) {
            basicConfig.structureDisplayName = messageTag.func_74779_i(structureDisplayNameTag);
        }
        if (messageTag.func_74764_b(bedColorTag)) {
            basicConfig.bedColor = EnumDyeColor.valueOf((String)messageTag.func_74779_i(bedColorTag));
        }
        if (messageTag.func_74764_b(chosenOptionTag)) {
            basicConfig.chosenOption = BaseOption.getOptionByTranslationString(messageTag.func_74779_i(chosenOptionTag));
        }
    }

    @Override
    protected NBTTagCompound CustomWriteToCompoundNBT(NBTTagCompound tag) {
        tag.func_74778_a(structureEnumNameTag, this.basicStructureName.name());
        if (this.structureDisplayName != null) {
            tag.func_74778_a(structureDisplayNameTag, this.structureDisplayName);
        }
        tag.func_74778_a(bedColorTag, this.bedColor.func_176610_l().toUpperCase());
        tag.func_74778_a(chosenOptionTag, this.chosenOption.getTranslationString());
        return tag;
    }

    @Override
    public BasicStructureConfiguration ReadFromCompoundNBT(NBTTagCompound messageTag) {
        BasicStructureConfiguration config = new BasicStructureConfiguration();
        return (BasicStructureConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, WorldServer world, BlockPos hitBlockPos) {
        StructureBasic structure;
        String assetLocation = "";
        if (!this.IsCustomStructure()) {
            assetLocation = this.chosenOption.getAssetLocation();
        }
        if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(this, (World)world, hitBlockPos, EnumFacing.NORTH, player)) {
            ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(player);
            if (stack.func_190916_E() == 1) {
                player.field_71071_by.func_184437_d(stack);
            } else {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            player.field_71069_bz.func_75142_b();
        }
    }

    public static enum EnumBasicStructureName {
        Custom("custom", null, null, null),
        AdvancedCoop("advancedcoop", "item.prefab:item_advanced_chicken_coop.name", "item_advanced_chicken_coop", AdvancedCoopOptions.Default),
        AdvancedHorseStable("advanced_horse_stable", "item.prefab:item_advanced_horse_stable.name", "item_advanced_horse_stable", AdvancedHorseStableOptions.Default),
        Barn("barn", "item.prefab:item_barn.name", "item_barn", BarnOptions.Default),
        MachineryTower("machinery_tower", "item.prefab:item_machinery_tower.name", "item_machinery_tower", MachineryTowerOptions.Default),
        DefenseBunker("defense_bunker", "item.prefab:item_defense_bunker.name", "item_defense_bunker", DefenseBunkerOptions.Default),
        MineshaftEntrance("mineshaft_entrance", "item.prefab:item_mineshaft_entrance.name", "item_mineshaft_entrance", MineshaftEntranceOptions.Default),
        EnderGateway("ender_gateway", "item.prefab:item_ender_gateway.name", "item_ender_gateway", EnderGatewayOptions.Default),
        AquaBase("aqua_base", "item.prefab:item_aqua_base.name", "item_aqua_base", AquaBaseOptions.Default),
        GrassyPlain("grassy_plain", "item.prefab:item_grassy_plain.name", "item_grassy_plain", GrassyPlainOptions.Default),
        MagicTemple("magic_temple", "item.prefab:item_magic_temple.name", "item_magic_temple", MagicTempleOptions.Default),
        GreenHouse("green_house", "item.prefab:item_green_house.name", "item_green_house", GreenHouseOptions.Default),
        WatchTower("watch_tower", "item.prefab:item_watch_tower.name", "item_watch_tower", WatchTowerOptions.Default),
        WelcomeCenter("welcome_center", "item.prefab:item_welcome_center.name", "item_welcome_center", WelcomeCenterOptions.Default),
        Jail("jail", "item.prefab:item_jail.name", "item_jail", JailOptions.Default),
        Saloon("saloon", "item.prefab:item_saloon.name", "item_saloon", SaloonOptions.Default),
        NetherGate("nether_gate", "item.prefab:item_nether_gate.name", "item_nether_gate", NetherGateOptions.AncientSkull);

        private final String name;
        private final String itemTranslationString;
        private final BaseOption baseOption;
        private ResourceLocation itemTextureLocation;

        private EnumBasicStructureName(String name, String itemTranslationString, String itemTextureLocation, BaseOption baseOption) {
            this.name = name;
            this.itemTranslationString = itemTranslationString;
            if (itemTextureLocation != null) {
                this.itemTextureLocation = new ResourceLocation("prefab", itemTextureLocation);
            }
            this.baseOption = baseOption;
        }

        public String getName() {
            return this.name;
        }

        public String getItemTranslationString() {
            return this.itemTranslationString;
        }

        public ResourceLocation getItemTextureLocation() {
            return this.itemTextureLocation;
        }

        public BaseOption getBaseOption() {
            return this.baseOption;
        }
    }
}

