/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureMonsterMasher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class MonsterMasherConfiguration
extends StructureConfiguration {
    private static String dyeColorTag = "dyeColor";
    public FullDyeColor dyeColor;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = EnumFacing.NORTH;
        this.dyeColor = FullDyeColor.CYAN;
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b(dyeColorTag)) {
            ((MonsterMasherConfiguration)config).dyeColor = FullDyeColor.ById(messageTag.func_74762_e(dyeColorTag));
        }
    }

    @Override
    protected NBTTagCompound CustomWriteToCompoundNBT(NBTTagCompound tag) {
        tag.func_74768_a(dyeColorTag, this.dyeColor.getId());
        return tag;
    }

    @Override
    public MonsterMasherConfiguration ReadFromCompoundNBT(NBTTagCompound messageTag) {
        MonsterMasherConfiguration config = new MonsterMasherConfiguration();
        return (MonsterMasherConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, WorldServer world, BlockPos hitBlockPos) {
        StructureMonsterMasher structure = (StructureMonsterMasher)StructureMonsterMasher.CreateInstance("assets/prefab/structures/monster_masher.zip", StructureMonsterMasher.class);
        if (structure.BuildStructure(this, (World)world, hitBlockPos, EnumFacing.NORTH, player)) {
            this.RemoveStructureItemFromPlayer(player, ModRegistry.MonsterMasher);
        }
    }
}

