/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.items.ItemWareHouse;
import com.wuest.prefab.structures.predefined.StructureWarehouse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WareHouseConfiguration
extends StructureConfiguration {
    private static String dyeColorTag = "dyeColor";
    private static String advancedTag = "advanced";
    public FullDyeColor dyeColor;
    public boolean advanced;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = EnumFacing.SOUTH;
        this.dyeColor = FullDyeColor.CYAN;
        this.advanced = false;
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        if (messageTag.func_74764_b(dyeColorTag)) {
            ((WareHouseConfiguration)config).dyeColor = FullDyeColor.ById(messageTag.func_74762_e(dyeColorTag));
        }
        if (messageTag.func_74764_b(advancedTag)) {
            ((WareHouseConfiguration)config).advanced = messageTag.func_74767_n(advancedTag);
        }
    }

    @Override
    public WareHouseConfiguration ReadFromCompoundNBT(NBTTagCompound messageTag) {
        WareHouseConfiguration config = new WareHouseConfiguration();
        return (WareHouseConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected NBTTagCompound CustomWriteToCompoundNBT(NBTTagCompound tag) {
        tag.func_74768_a(dyeColorTag, this.dyeColor.getId());
        tag.func_74757_a(advancedTag, this.advanced);
        return tag;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, WorldServer world, BlockPos hitBlockPos) {
        String assetLocation = this.advanced ? "assets/prefab/structures/advanced_warehouse.zip" : "assets/prefab/structures/warehouse.zip";
        StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance(assetLocation, StructureWarehouse.class);
        if (structure.BuildStructure(this, (World)world, hitBlockPos, EnumFacing.NORTH, player)) {
            ItemWareHouse structureItem = this.advanced ? ModRegistry.AdvancedWareHouse : ModRegistry.WareHouse;
            this.RemoveStructureItemFromPlayer(player, structureItem);
        }
    }
}

