/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config.enums;

import com.wuest.prefab.structures.base.BuildShape;
import com.wuest.prefab.structures.base.PositionOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public abstract class BaseOption {
    private static final HashMap<String, ArrayList<BaseOption>> classOptions = new HashMap();
    private final String translationString;
    private final String assetLocation;
    private final ResourceLocation pictureLocation;
    private final int imageWidth;
    private final int imageHeight;
    private final BuildShape clearShape;
    private final PositionOffset clearPositionOffset;

    protected BaseOption(String translationString, String assetLocation, String pictureLocation, int imageWidth, int imageHeight, EnumFacing direction, int height, int width, int length, int offsetParallelToPlayer, int offsetToLeftOfPlayer, int heightOffset) {
        this.translationString = translationString;
        this.assetLocation = assetLocation;
        this.pictureLocation = new ResourceLocation("prefab", pictureLocation);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.clearShape = new BuildShape();
        this.clearPositionOffset = new PositionOffset();
        this.clearShape.setDirection(direction);
        this.clearShape.setHeight(height);
        this.clearShape.setWidth(width);
        this.clearShape.setLength(length);
        this.clearPositionOffset.setHorizontalOffset(direction, offsetParallelToPlayer);
        this.clearPositionOffset.setHorizontalOffset(direction.func_176735_f(), offsetToLeftOfPlayer);
        this.clearPositionOffset.setHeightOffset(heightOffset);
        BaseOption.addOption(this);
    }

    public static BaseOption getOptionByTranslationString(String translationString) {
        for (Map.Entry<String, ArrayList<BaseOption>> mapping : classOptions.entrySet()) {
            for (BaseOption storedOption : mapping.getValue()) {
                if (!storedOption.getTranslationString().equals(translationString)) continue;
                return storedOption;
            }
        }
        return null;
    }

    public static void addOption(BaseOption option) {
        ArrayList<Object> options;
        String className = option.getClass().getName();
        if (!classOptions.containsKey(className)) {
            options = new ArrayList();
            classOptions.put(className, options);
        } else {
            options = classOptions.get(className);
        }
        options.add(option);
    }

    public String getTranslationString() {
        return this.translationString;
    }

    public String getAssetLocation() {
        return this.assetLocation;
    }

    public ResourceLocation getPictureLocation() {
        return this.pictureLocation;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public BuildShape getClearShape() {
        return this.clearShape;
    }

    public PositionOffset getClearPositionOffset() {
        return this.clearPositionOffset;
    }

    public ArrayList<BaseOption> getSpecificOptions() {
        String className = this.getClass().getName();
        for (Map.Entry<String, ArrayList<BaseOption>> mapping : classOptions.entrySet()) {
            if (!mapping.getKey().equals(className)) continue;
            return mapping.getValue();
        }
        return null;
    }
}

