/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.events;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.proxy.messages.PlayerEntityTagMessage;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildEntity;
import com.wuest.prefab.structures.base.BuildTileEntity;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.SERVER, Side.CLIENT})
public class StructureEventHandler {
    public static HashMap<EntityPlayer, ArrayList<Structure>> structuresToBuild = new HashMap();

    @SubscribeEvent
    public static void PlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntityData((EntityPlayer)player);
            String startingItem = CommonProxy.proxyConfiguration.startingItem;
            if (!playerConfig.givenHouseBuilder && startingItem != null) {
                ItemStack stack = ItemStack.field_190927_a;
                switch (startingItem.toLowerCase()) {
                    case "structure part": {
                        stack = new ItemStack((Item)ModRegistry.StructurePart);
                        break;
                    }
                    case "starting house": {
                        stack = new ItemStack((Item)ModRegistry.StartHouse);
                        break;
                    }
                    case "moderate house": {
                        stack = new ItemStack((Item)ModRegistry.ModerateHouse);
                    }
                }
                if (!stack.func_190926_b()) {
                    System.out.println(player.getDisplayNameString() + " joined the game for the first time. Giving them starting item.");
                    player.field_71071_by.func_70441_a(stack);
                    player.field_71069_bz.func_75142_b();
                    playerConfig.givenHouseBuilder = true;
                    playerConfig.saveToPlayer((EntityPlayer)player);
                }
            }
            Prefab.network.sendTo((IMessage)new PlayerEntityTagMessage(playerConfig.getModIsPlayerNewTag((EntityPlayer)player)), player);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ArrayList<EntityPlayer> playersToRemove = new ArrayList<EntityPlayer>();
        for (Map.Entry<EntityPlayer, ArrayList<Structure>> entry : structuresToBuild.entrySet()) {
            ArrayList<Structure> structuresToRemove = new ArrayList<Structure>();
            EntityPlayer player = entry.getKey();
            for (Structure structure : entry.getValue()) {
                for (int i = 0; i < 100; ++i) {
                    i = StructureEventHandler.setBlock(i, structure, structuresToRemove);
                }
            }
            StructureEventHandler.removeStructuresFromList(structuresToRemove, entry);
            if (entry.getValue().size() != 0) continue;
            playersToRemove.add(entry.getKey());
        }
        for (EntityPlayer player : playersToRemove) {
            structuresToBuild.remove(player);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            NBTTagCompound originalTag = event.getOriginal().getEntityData();
            String startingItem = CommonProxy.proxyConfiguration.startingItem;
            if (startingItem != null && !startingItem.equalsIgnoreCase("Nothing") && originalTag.func_74764_b("IsPlayerNew")) {
                NBTTagCompound newPlayerTag = event.getEntityPlayer().getEntityData();
                newPlayerTag.func_74782_a("IsPlayerNew", originalTag.func_74781_a("IsPlayerNew"));
                Prefab.network.sendTo((IMessage)new PlayerEntityTagMessage(originalTag.func_74775_l("IsPlayerNew")), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    private static int setBlock(int i, Structure structure, ArrayList<Structure> structuresToRemove) {
        if (structure.clearedBlockPos.size() > 0) {
            BlockPos currentPos = structure.clearedBlockPos.get(0);
            structure.clearedBlockPos.remove(0);
            IBlockState clearBlockState = structure.world.func_180495_p(currentPos);
            if (clearBlockState.func_177230_c() != Blocks.field_150350_a) {
                structure.BeforeClearSpaceBlockReplaced(currentPos);
                structure.world.func_175698_g(currentPos);
            } else {
                --i;
            }
            return i;
        }
        BuildBlock currentBlock = null;
        if (structure.priorityOneBlocks.size() > 0) {
            currentBlock = structure.priorityOneBlocks.get(0);
            structure.priorityOneBlocks.remove(0);
        } else if (structure.priorityTwoBlocks.size() > 0) {
            currentBlock = structure.priorityTwoBlocks.get(0);
            structure.priorityTwoBlocks.remove(0);
        } else if (structure.airBlocks.size() > 0) {
            currentBlock = structure.airBlocks.get(0);
            structure.airBlocks.remove(0);
        } else if (structure.priorityThreeBlocks.size() > 0) {
            currentBlock = structure.priorityThreeBlocks.get(0);
            structure.priorityThreeBlocks.remove(0);
        } else if (structure.priorityFourBlocks.size() > 0) {
            currentBlock = structure.priorityFourBlocks.get(0);
            structure.priorityFourBlocks.remove(0);
        } else if (structure.priorityFiveBlocks.size() > 0) {
            currentBlock = structure.priorityFiveBlocks.get(0);
            structure.priorityFiveBlocks.remove(0);
        } else {
            structuresToRemove.add(structure);
            return 999;
        }
        IBlockState state = currentBlock.getBlockState();
        BuildingMethods.ReplaceBlock(structure.world, currentBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing), state);
        if (currentBlock.getSubBlock() != null) {
            BuildBlock subBlock = currentBlock.getSubBlock();
            BuildingMethods.ReplaceBlock(structure.world, subBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing), subBlock.getBlockState());
        }
        return i;
    }

    private static void removeStructuresFromList(ArrayList<Structure> structuresToRemove, Map.Entry<EntityPlayer, ArrayList<Structure>> entry) {
        for (Structure structure : structuresToRemove) {
            for (BuildTileEntity buildTileEntity : structure.tileEntities) {
                BlockPos tileEntityPos = buildTileEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
                TileEntity tileEntity = structure.world.func_175625_s(tileEntityPos);
                if (tileEntity == null) {
                    TileEntity.func_190200_a((World)structure.world, (NBTTagCompound)buildTileEntity.getEntityDataTag());
                    continue;
                }
                structure.world.func_175713_t(tileEntityPos);
                tileEntity = TileEntity.func_190200_a((World)structure.world, (NBTTagCompound)buildTileEntity.getEntityDataTag());
                structure.world.func_175690_a(tileEntityPos, tileEntity);
                structure.world.func_175726_f(tileEntityPos).func_76630_e();
                tileEntity.func_70296_d();
                SPacketUpdateTileEntity packet = tileEntity.func_189518_D_();
                if (packet == null) continue;
                structure.world.func_73046_m().func_184103_al().func_148540_a((Packet)tileEntity.func_189518_D_());
            }
            for (BuildEntity buildEntity : structure.entities) {
                Entity entity = EntityList.func_188429_b((ResourceLocation)buildEntity.getEntityResource(), (World)structure.world);
                NBTTagCompound tagCompound = buildEntity.getEntityDataTag();
                BlockPos entityPos = buildEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
                if (tagCompound != null) {
                    if (tagCompound.func_186855_b("UUID")) {
                        tagCompound.func_186854_a("UUID", UUID.randomUUID());
                    }
                    NBTTagList nbttaglist = new NBTTagList();
                    nbttaglist.func_74742_a((NBTBase)new NBTTagDouble((double)entityPos.func_177958_n()));
                    nbttaglist.func_74742_a((NBTBase)new NBTTagDouble((double)entityPos.func_177956_o()));
                    nbttaglist.func_74742_a((NBTBase)new NBTTagDouble((double)entityPos.func_177952_p()));
                    tagCompound.func_74782_a("Pos", (NBTBase)nbttaglist);
                    entity.func_70020_e(tagCompound);
                }
                entity.field_98038_p = true;
                entity = entity instanceof EntityItemFrame ? StructureEventHandler.setItemFrameFacingAndRotation((EntityItemFrame)entity, buildEntity, entityPos, structure) : (entity instanceof EntityPainting ? StructureEventHandler.setPaintingFacingAndRotation((EntityPainting)entity, buildEntity, entityPos, structure) : StructureEventHandler.setEntityFacingAndRotation(entity, buildEntity, entityPos, structure));
                structure.world.func_72838_d(entity);
            }
            structure.AfterBuilding(structure.configuration, structure.world, structure.originalPos, structure.assumedNorth, entry.getKey());
            entry.getValue().remove(structure);
        }
    }

    private static Entity setPaintingFacingAndRotation(EntityPainting entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.field_70177_z;
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        EnumFacing facing = entity.field_174860_b;
        double y_axis_offset = buildEntity.entityYAxisOffset * -1.0;
        if (structure.configuration.houseFacing == structure.assumedNorth.func_176734_d()) {
            rotation = Rotation.CLOCKWISE_180;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176734_d();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176746_e()) {
            rotation = Rotation.CLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            if (structure.getClearSpace().getShape().getDirection() == EnumFacing.NORTH) {
                facing = facing.func_176735_f();
            } else if (structure.getClearSpace().getShape().getDirection() == EnumFacing.SOUTH) {
                facing = facing.func_176746_e();
            }
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176735_f()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            if (structure.getClearSpace().getShape().getDirection() == EnumFacing.NORTH) {
                facing = facing.func_176746_e();
            } else if (structure.getClearSpace().getShape().getDirection() == EnumFacing.SOUTH) {
                facing = facing.func_176735_f();
            }
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        if (entity.field_70522_e.field_75704_C > entity.field_70522_e.field_75703_B || entity.field_70522_e.field_75704_C > 16) {
            y_axis_offset -= 1.0;
        }
        yaw = entity.func_184229_a(rotation);
        entity.field_174860_b = facing;
        StructureEventHandler.updateEntityHangingBoundingBox((EntityHanging)entity);
        entity.func_70012_b((double)entityPos.func_177958_n() + x_axis_offset, (double)entityPos.func_177956_o() + y_axis_offset, (double)entityPos.func_177952_p() + z_axis_offset, yaw, entity.field_70125_A);
        StructureEventHandler.updateEntityHangingBoundingBox((EntityHanging)entity);
        Chunk chunk = structure.world.func_175726_f(entityPos);
        chunk.func_76630_e();
        return entity;
    }

    private static Entity setItemFrameFacingAndRotation(EntityItemFrame frame, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = frame.field_70177_z;
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        EnumFacing facing = frame.field_174860_b;
        double y_axis_offset = buildEntity.entityYAxisOffset;
        x_axis_offset *= -1.0;
        z_axis_offset *= -1.0;
        if (structure.configuration.houseFacing == structure.assumedNorth.func_176734_d()) {
            rotation = Rotation.CLOCKWISE_180;
            facing = facing.func_176734_d();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176746_e()) {
            if (structure.getClearSpace().getShape().getDirection() == EnumFacing.NORTH) {
                rotation = Rotation.CLOCKWISE_90;
                facing = facing.func_176735_f();
            } else if (structure.getClearSpace().getShape().getDirection() == EnumFacing.SOUTH) {
                facing = facing.func_176746_e();
                rotation = Rotation.COUNTERCLOCKWISE_90;
            }
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176735_f()) {
            if (structure.getClearSpace().getShape().getDirection() == EnumFacing.NORTH) {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                facing = facing.func_176746_e();
            } else if (structure.getClearSpace().getShape().getDirection() == EnumFacing.SOUTH) {
                facing = facing.func_176735_f();
                rotation = Rotation.CLOCKWISE_90;
            }
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        yaw = frame.func_184229_a(rotation);
        frame.field_174860_b = facing;
        StructureEventHandler.updateEntityHangingBoundingBox((EntityHanging)frame);
        frame.func_70012_b((double)entityPos.func_177958_n() + x_axis_offset, (double)entityPos.func_177956_o() + y_axis_offset, (double)entityPos.func_177952_p() + z_axis_offset, yaw, frame.field_70125_A);
        StructureEventHandler.updateEntityHangingBoundingBox((EntityHanging)frame);
        Chunk chunk = structure.world.func_175726_f(entityPos);
        chunk.func_76630_e();
        return frame;
    }

    private static Entity setEntityFacingAndRotation(Entity entity, BuildEntity buildEntity, BlockPos entityPos, Structure structure) {
        float yaw = entity.field_70177_z;
        Rotation rotation = Rotation.NONE;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        EnumFacing facing = structure.assumedNorth;
        double y_axis_offset = buildEntity.entityYAxisOffset;
        if (structure.configuration.houseFacing == structure.assumedNorth.func_176734_d()) {
            rotation = Rotation.CLOCKWISE_180;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176734_d();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176746_e()) {
            rotation = Rotation.CLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176746_e();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.func_176735_f()) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.func_176735_f();
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        yaw = entity.func_184229_a(rotation);
        entity.func_70080_a((double)entityPos.func_177958_n() + x_axis_offset, (double)entityPos.func_177956_o() + y_axis_offset, (double)entityPos.func_177952_p() + z_axis_offset, yaw, entity.field_70125_A);
        return entity;
    }

    private static void updateEntityHangingBoundingBox(EntityHanging entity) {
        double d0 = (double)entity.func_174857_n().func_177958_n() + 0.5;
        double d1 = (double)entity.func_174857_n().func_177956_o() + 0.5;
        double d2 = (double)entity.func_174857_n().func_177952_p() + 0.5;
        double d3 = 0.46875;
        double d4 = entity.func_82329_d() % 32 == 0 ? 0.5 : 0.0;
        double d5 = entity.func_82330_g() % 32 == 0 ? 0.5 : 0.0;
        d0 -= (double)entity.field_174860_b.func_82601_c() * 0.46875;
        d2 -= (double)entity.field_174860_b.func_82599_e() * 0.46875;
        EnumFacing enumfacing = entity.field_174860_b.func_176735_f();
        entity.field_70165_t = d0 += d4 * (double)enumfacing.func_82601_c();
        entity.field_70163_u = d1 += d5;
        entity.field_70161_v = d2 += d4 * (double)enumfacing.func_82599_e();
        double d6 = entity.func_82329_d();
        double d7 = entity.func_82330_g();
        double d8 = entity.func_82329_d();
        if (entity.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        entity.func_174826_a(new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8));
    }
}

