/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.structures.config.MonsterMasherConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureMonsterMasher;
import java.io.IOException;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiMonsterMasher
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/monster_masher_top_down.png");
    protected GuiButtonExt btnGlassColor;
    protected MonsterMasherConfiguration configuration;

    public GuiMonsterMasher() {
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.MonsterMasher;
    }

    @Override
    public void Initialize() {
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.structureImageLocation = structureTopDown;
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Monster Masher", MonsterMasherConfiguration.class);
        this.configuration.pos = this.pos;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnGlassColor = this.createAndAddFullDyeButton(4, grayBoxX + 15, grayBoxY + 45, 90, 20, this.configuration.dyeColor);
        this.btnVisualize = this.createAndAddCustomButton(3, grayBoxX + 25, grayBoxY + 175, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 310, grayBoxY + 175, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(2, grayBoxX + 150, grayBoxY + 175, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 132;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.func_146276_q_();
        this.drawControlLeftPanel(x + 10, y + 10, 125, 190);
        this.drawControlRightPanel(imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindTexture(this.structureImageLocation);
        Gui.func_152125_a((int)imageLocation, (int)(y + 15), (float)0.0f, (float)0.0f, (int)this.shownImageWidth, (int)this.shownImageHeight, (int)this.shownImageWidth, (int)this.shownImageHeight, (float)this.shownImageWidth, (float)this.shownImageHeight);
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(GuiLangKeys.translateString("item.prefab:item_monster_masher.name"), x + 15, y + 17, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 15, y + 35, this.textColor);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnGlassColor) {
            this.configuration.dyeColor = FullDyeColor.ById(this.configuration.dyeColor.getId() + 1);
            this.btnGlassColor.field_146126_j = GuiLangKeys.translateFullDye(this.configuration.dyeColor);
        } else if (button == this.btnVisualize) {
            StructureMonsterMasher structure = (StructureMonsterMasher)StructureMonsterMasher.CreateInstance("assets/prefab/structures/monster_masher.zip", StructureMonsterMasher.class);
            this.performPreview(structure, this.configuration);
        }
    }
}

