/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.structures.config.VillagerHouseConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureVillagerHouses;
import java.io.IOException;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiVillagerHouses
extends GuiStructure {
    protected GuiButtonExt btnHouseStyle;
    protected GuiButtonExt btnBedColor;
    protected VillagerHouseConfiguration configuration;
    protected VillagerHouseConfiguration.HouseStyle houseStyle;

    public GuiVillagerHouses() {
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.VillagerHouses;
    }

    @Override
    public void Initialize() {
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Villager Houses", VillagerHouseConfiguration.class);
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = EnumFacing.NORTH;
        this.houseStyle = this.configuration.houseStyle;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnHouseStyle = this.createAndAddButton(4, grayBoxX + 15, grayBoxY + 45, 90, 20, this.houseStyle.getDisplayName(), false);
        this.btnBedColor = this.createAndAddDyeButton(5, grayBoxX + 15, grayBoxY + 90, 90, 20, this.configuration.bedColor);
        this.btnBedColor.field_146125_m = this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE;
        this.btnVisualize = this.createAndAddCustomButton(3, grayBoxX + 25, grayBoxY + 175, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 310, grayBoxY + 175, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(2, grayBoxX + 150, grayBoxY + 175, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 132;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.func_146276_q_();
        this.drawControlLeftPanel(x + 10, y + 10, 125, 190);
        this.drawControlRightPanel(imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindTexture(this.houseStyle.getHousePicture());
        Gui.func_152125_a((int)imageLocation, (int)(y + 15), (float)0.0f, (float)0.0f, (int)this.shownImageWidth, (int)this.shownImageHeight, (int)this.shownImageWidth, (int)this.shownImageHeight, (float)this.shownImageWidth, (float)this.shownImageHeight);
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(GuiLangKeys.translateString("item.prefab:item_villager_houses.name"), x + 15, y + 17, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.starter.style.label"), x + 15, y + 35, this.textColor);
        if (this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE) {
            this.drawString(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 15, y + 80, this.textColor);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.configuration.houseStyle = this.houseStyle;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.houseStyle.getValue() + 1;
            this.houseStyle = VillagerHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.field_146126_j = this.houseStyle.getDisplayName();
            this.btnBedColor.field_146125_m = this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE;
        } else if (button == this.btnVisualize) {
            StructureVillagerHouses structure = (StructureVillagerHouses)StructureVillagerHouses.CreateInstance(this.houseStyle.getStructureLocation(), StructureVillagerHouses.class);
            this.performPreview(structure, this.configuration);
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = EnumDyeColor.func_176764_b((int)(this.configuration.bedColor.func_176765_a() + 1));
            GuiUtils.setButtonText((GuiButton)this.btnBedColor, GuiLangKeys.translateDye(this.configuration.bedColor));
        }
    }
}

