/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.messages;

import com.wuest.prefab.proxy.messages.TagMessage;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.BulldozerConfiguration;
import com.wuest.prefab.structures.config.ChickenCoopConfiguration;
import com.wuest.prefab.structures.config.FishPondConfiguration;
import com.wuest.prefab.structures.config.HorseStableConfiguration;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.config.ModerateHouseConfiguration;
import com.wuest.prefab.structures.config.ModularHouseConfiguration;
import com.wuest.prefab.structures.config.MonsterMasherConfiguration;
import com.wuest.prefab.structures.config.ProduceFarmConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.StructurePartConfiguration;
import com.wuest.prefab.structures.config.TreeFarmConfiguration;
import com.wuest.prefab.structures.config.VillagerHouseConfiguration;
import com.wuest.prefab.structures.config.WareHouseConfiguration;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class StructureTagMessage
extends TagMessage {
    protected EnumStructureConfiguration structureConfig;

    public StructureTagMessage() {
    }

    public StructureTagMessage(NBTTagCompound tagMessage, EnumStructureConfiguration structureConfig) {
        super(tagMessage);
        this.structureConfig = structureConfig;
    }

    public EnumStructureConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    public void setStructureConfig(EnumStructureConfiguration value) {
        this.structureConfig = value;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.structureConfig = EnumStructureConfiguration.getFromIdentifier(tag.func_74762_e("config"));
        this.tagMessage = tag.func_74775_l("dataTag");
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("config", this.structureConfig.identifier);
        tag.func_74782_a("dataTag", (NBTBase)this.tagMessage);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static enum EnumStructureConfiguration {
        Basic(0, new BasicStructureConfiguration()),
        ChickenCoop(1, new ChickenCoopConfiguration()),
        AdvancedWareHouse(2, new WareHouseConfiguration()),
        FishPond(3, new FishPondConfiguration()),
        HorseStable(4, new HorseStableConfiguration()),
        ModularHouse(5, new ModularHouseConfiguration()),
        MonsterMasher(6, new MonsterMasherConfiguration()),
        ProduceFarm(8, new ProduceFarmConfiguration()),
        StartHouse(9, new HouseConfiguration()),
        TreeFarm(10, new TreeFarmConfiguration()),
        VillagerHouses(11, new VillagerHouseConfiguration()),
        WareHouse(12, new WareHouseConfiguration()),
        ModerateHouse(13, new ModerateHouseConfiguration()),
        Bulldozer(14, new BulldozerConfiguration()),
        InstantBridge(15, new InstantBridgeConfiguration()),
        Parts(16, new StructurePartConfiguration());

        public int identifier;
        public StructureConfiguration structureConfig;

        private <T extends StructureConfiguration> EnumStructureConfiguration(int identifier, T structureConfig) {
            this.identifier = identifier;
            this.structureConfig = structureConfig;
        }

        public static EnumStructureConfiguration getFromIdentifier(int identifier) {
            for (EnumStructureConfiguration config : EnumStructureConfiguration.values()) {
                if (config.identifier != identifier) continue;
                return config;
            }
            return Basic;
        }
    }
}

