/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.MonsterMasherConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class StructureMonsterMasher
extends Structure {
    public static final String ASSETLOCATION = "assets/prefab/structures/monster_masher.zip";
    private ArrayList<BlockPos> mobSpawnerPos = new ArrayList();
    private BlockPos signPosition = null;

    public static void ScanStructure(World world, BlockPos originalPos, EnumFacing playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        clearedSpace.getShape().setHeight(18);
        clearedSpace.getShape().setLength(15);
        clearedSpace.getShape().setWidth(13);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(6);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(6).func_177968_d(), originalPos.func_177970_e(15).func_177985_f(6).func_177981_b(18), "..\\src\\main\\resources\\assets\\prefab\\structures\\monster_masher.zip", clearedSpace, playerFacing, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_150399_cn.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().equals(Blocks.field_150399_cn.getRegistryName().func_110623_a())) {
            MonsterMasherConfiguration wareHouseConfiguration = (MonsterMasherConfiguration)configuration;
            blockState = this.getStainedGlassBlock(wareHouseConfiguration.dyeColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (foundBlock.getRegistryName().func_110624_b().equals(Blocks.field_150474_ac.getRegistryName().func_110624_b()) && foundBlock.getRegistryName().func_110623_a().equals(Blocks.field_150474_ac.getRegistryName().func_110623_a())) {
            if (!CommonProxy.proxyConfiguration.includeSpawnersInMasher) return true;
            this.mobSpawnerPos.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
            return false;
        } else {
            if (!(foundBlock instanceof BlockSign)) return false;
            this.signPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        TileEntity tileEntity;
        int monstersPlaced = 0;
        for (BlockPos pos : this.mobSpawnerPos) {
            TileEntity tileEntity2 = world.func_175625_s(pos);
            if (tileEntity2 == null || !(tileEntity2 instanceof TileEntityMobSpawner)) continue;
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileEntity2;
            switch (monstersPlaced) {
                case 0: {
                    spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityZombie.class));
                    break;
                }
                case 1: {
                    spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySkeleton.class));
                    break;
                }
                case 2: {
                    spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySpider.class));
                    break;
                }
                default: {
                    spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityCreeper.class));
                }
            }
            ++monstersPlaced;
        }
        if (this.signPosition != null && (tileEntity = world.func_175625_s(this.signPosition)) instanceof TileEntitySign) {
            TileEntitySign signTile = (TileEntitySign)tileEntity;
            signTile.field_145915_a[0] = new TextComponentString("Lamp On=Mobs");
            signTile.field_145915_a[2] = new TextComponentString("Lamp Off=No Mobs");
        }
    }
}

