/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.render;

import com.google.common.base.Throwables;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.render.ShaderHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;

public class StructureRenderHandler {
    private static final ChestRenderer chestRenderer = new ChestRenderer();
    private static final String[] RENDERPOSX = new String[]{"renderPosX", "field_78725_b", "o"};
    private static final String[] RENDERPOSY = new String[]{"renderPosY", "field_78726_c", "p"};
    private static final String[] RENDERPOSZ = new String[]{"renderPosZ", "field_78723_d", "q"};
    private static final MethodHandle renderPosX_getter;
    private static final MethodHandle renderPosY_getter;
    private static final MethodHandle renderPosZ_getter;
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static EnumFacing assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;

    public static void setStructure(Structure structure, EnumFacing assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.field_73011_w.getDimension();
        }
    }

    public static void renderPlayerLook(EntityPlayer player, RayTraceResult src) {
        if (currentStructure != null && dimension == player.field_70170_p.field_73011_w.getDimension() && currentConfiguration != null) {
            if (CommonProxy.proxyConfiguration.enableStructurePreview) {
                GlStateManager.func_179094_E();
                GL11.glPushAttrib((int)64);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179140_f();
                rendering = true;
                boolean didAny = false;
                ShaderHelper.useShader(ShaderHelper.alphaShader);
                for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                    IBlockState blockState;
                    Block foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)buildBlock.getResourceLocation());
                    if (foundBlock == null || !StructureRenderHandler.renderComponentInWorld(player.field_70170_p, buildBlock = BuildBlock.SetBlockState(currentConfiguration, player.field_70170_p, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, blockState = foundBlock.func_176223_P(), currentStructure))) continue;
                    didAny = true;
                }
                ShaderHelper.releaseShader();
                rendering = false;
                GL11.glPopAttrib();
                GlStateManager.func_179121_F();
                if (!didAny) {
                    StructureRenderHandler.setStructure(null, EnumFacing.NORTH, null);
                    player.func_145747_a(new TextComponentTranslation("prefab.gui.preview.complete", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                } else if (!showedMessage) {
                    player.func_145747_a(new TextComponentTranslation("prefab.gui.preview.notice", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    player.func_145747_a(new TextComponentTranslation("prefab.gui.structure.block.clicked", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
                    showedMessage = true;
                }
                if (didAny) {
                    StructureRenderHandler.RenderTest(player.field_70170_p);
                }
            }
        }
    }

    private static boolean renderComponentInWorld(World world, BuildBlock buildBlock) {
        double renderPosZ;
        double renderPosY;
        double renderPosX;
        try {
            renderPosX = renderPosX_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosY = renderPosY_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosZ = renderPosZ_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
        }
        catch (Throwable t) {
            return true;
        }
        BlockPos pos = buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
        if (!world.func_175623_d(pos)) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
        GlStateManager.func_179097_i();
        StructureRenderHandler.doRenderComponent(buildBlock, pos);
        GlStateManager.func_179121_F();
        if (buildBlock.getSubBlock() != null) {
            Block foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)buildBlock.getSubBlock().getResourceLocation());
            IBlockState blockState = foundBlock.func_176223_P();
            BuildBlock subBlock = BuildBlock.SetBlockState(currentConfiguration, world, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock.getSubBlock(), foundBlock, blockState, currentStructure);
            return StructureRenderHandler.renderComponentInWorld(world, subBlock);
        }
        return true;
    }

    private static void doRenderComponent(BuildBlock buildBlock, BlockPos pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        IBlockState state = buildBlock.getBlockState();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (state == null) {
            GlStateManager.func_179121_F();
            return;
        }
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StructureRenderHandler.renderBlockBrightness(state, 1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public static void renderBlockBrightness(IBlockState state, float brightness) {
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        EnumBlockRenderType enumblockrendertype = state.func_185901_i();
        if (enumblockrendertype != EnumBlockRenderType.INVISIBLE) {
            switch (enumblockrendertype) {
                case MODEL: 
                case ENTITYBLOCK_ANIMATED: {
                    if (enumblockrendertype == EnumBlockRenderType.ENTITYBLOCK_ANIMATED && (state.func_177230_c() instanceof BlockChest || state.func_177230_c() instanceof BlockEnderChest)) {
                        chestRenderer.func_178175_a(state.func_177230_c(), brightness);
                        break;
                    }
                    if (state.func_177230_c() instanceof BlockBed) break;
                    IBakedModel ibakedmodel = brd.func_184389_a(state);
                    BlockModelRenderer renderer = brd.func_175019_b();
                    try {
                        renderer.func_178266_a(ibakedmodel, state, brightness, true);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
    }

    private static void RenderTest(World worldIn) {
        BlockPos originalPos = StructureRenderHandler.currentConfiguration.pos.func_177984_a();
        double blockXOffset = originalPos.func_177958_n();
        double blockZOffset = originalPos.func_177952_p();
        double blockStartYOffset = originalPos.func_177956_o();
        double blockEndYOffset = originalPos.func_177984_a().func_177956_o();
        StructureRenderHandler.drawBox(blockXOffset, blockZOffset, blockStartYOffset, blockEndYOffset);
    }

    private static void drawBox(double blockXOffset, double blockZOffset, double blockStartYOffset, double blockEndYOffset) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Vec3d vector3d = minecraft.field_71439_g.func_174791_d();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        double translatedX = blockXOffset - vector3d.field_72450_a;
        double translatedY = blockStartYOffset - vector3d.field_72448_b;
        double translatedYEnd = translatedY + 1.0;
        double translatedZ = blockZOffset - vector3d.field_72449_c;
        vertexBuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GlStateManager.func_187441_d((float)2.0f);
        for (int k = 1; k < 2; ++k) {
            vertexBuffer.func_181662_b(translatedX, translatedY, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX, translatedYEnd, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + (double)k, translatedY, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + (double)k, translatedYEnd, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX, translatedY, translatedZ + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX, translatedYEnd, translatedZ + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + 1.0, translatedY, translatedZ + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + 1.0, translatedYEnd, translatedZ + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        }
        for (double i1 = translatedY; i1 <= translatedYEnd; i1 += 1.0) {
            vertexBuffer.func_181662_b(translatedX, i1, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX, i1, translatedZ + 1.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + 1.0, i1, translatedZ + 1.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + 1.0, i1, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX, i1, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + 1.0, i1, translatedZ).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX + 1.0, i1, translatedZ + 1.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuffer.func_181662_b(translatedX, i1, translatedZ + 1.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
    }

    static {
        rendering = false;
        showedMessage = false;
        try {
            Field f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSX);
            f.setAccessible(true);
            renderPosX_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSY);
            f.setAccessible(true);
            renderPosY_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSZ);
            f.setAccessible(true);
            renderPosZ_getter = MethodHandles.publicLookup().unreflectGetter(f);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

