/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.blocks.tileentities;

import com.mic.randomloot.blocks.Breaker;
import com.mic.randomloot.blocks.containers.BreakDownContainer;
import com.mic.randomloot.blocks.recipes.BreakerRecipes;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityBreaker
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> breakerItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int breakerBreakTime;
    private int currentItemBreakTime;
    private int breakTime;
    private int totalbreakTime;
    private String breakerCustomName;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.breakerItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.breakerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.breakerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.breakerItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.breakerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.breakerItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.breakerItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalbreakTime = this.getbreakTime(stack);
            this.breakTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.breakerCustomName : "container.breaker";
    }

    public boolean func_145818_k_() {
        return this.breakerCustomName != null && !this.breakerCustomName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.breakerCustomName = p_145951_1_;
    }

    public static void registerFixesFurnace(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityBreaker.class, new String[]{"Items"}));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.breakerItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.breakerItemStacks);
        this.breakerBreakTime = compound.func_74762_e("breakerBreakTime");
        this.breakTime = compound.func_74762_e("breakTime");
        this.totalbreakTime = compound.func_74762_e("breakTimeTotal");
        this.currentItemBreakTime = TileEntityBreaker.getItemBurnTime((ItemStack)this.breakerItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.breakerCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("breakerBreakTime", (int)((short)this.breakerBreakTime));
        compound.func_74768_a("breakTime", (int)((short)this.breakTime));
        compound.func_74768_a("breakTimeTotal", (int)((short)this.totalbreakTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.breakerItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.breakerCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBreaking() {
        return this.breakerBreakTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBreaking();
        boolean flag1 = false;
        if (this.isBreaking()) {
            --this.breakerBreakTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.breakerItemStacks.get(1);
            if (this.isBreaking() || !itemstack.func_190926_b() && !((ItemStack)this.breakerItemStacks.get(0)).func_190926_b()) {
                if (!this.isBreaking() && this.canSmelt()) {
                    this.currentItemBreakTime = this.breakerBreakTime = TileEntityBreaker.getItemBurnTime(itemstack);
                    if (this.isBreaking()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.breakerItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBreaking() && this.canSmelt()) {
                    ++this.breakTime;
                    if (this.breakTime == this.totalbreakTime) {
                        this.breakTime = 0;
                        this.totalbreakTime = this.getbreakTime((ItemStack)this.breakerItemStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.breakTime = 0;
                }
            } else if (!this.isBreaking() && this.breakTime > 0) {
                this.breakTime = MathHelper.func_76125_a((int)(this.breakTime - 2), (int)0, (int)this.totalbreakTime);
            }
            if (flag != this.isBreaking()) {
                flag1 = true;
                Breaker.setState(this.isBreaking(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getbreakTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.breakerItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = BreakerRecipes.getInstance().getBreakingResult((ItemStack)this.breakerItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.breakerItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.breakerItemStacks.get(0);
            ItemStack itemstack1 = BreakerRecipes.getInstance().getBreakingResult(itemstack);
            ItemStack itemstack2 = (ItemStack)this.breakerItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.breakerItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.breakerItemStacks.get(1)).func_190926_b() && ((ItemStack)this.breakerItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.breakerItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeEventFactory.getItemBurnTime((ItemStack)stack);
        if (burnTime >= 0) {
            return burnTime;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151145_ak) {
            return 300;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151145_ak;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.breakerItemStacks.get(1);
        return TileEntityBreaker.isItemFuel(stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1) {
            Item item = stack.func_77973_b();
        }
        return true;
    }

    public String func_174875_k() {
        return "randomloot:breaker";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new BreakDownContainer(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.breakerBreakTime;
            }
            case 1: {
                return this.currentItemBreakTime;
            }
            case 2: {
                return this.breakTime;
            }
            case 3: {
                return this.totalbreakTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.breakerBreakTime = value;
                break;
            }
            case 1: {
                this.currentItemBreakTime = value;
                break;
            }
            case 2: {
                this.breakTime = value;
                break;
            }
            case 3: {
                this.totalbreakTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.breakerItemStacks.clear();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

