/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.init;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.blocks.Breaker;
import com.mic.randomloot.blocks.CaseOpener;
import com.mic.randomloot.blocks.RandomAnvil;
import com.mic.randomloot.blocks.RepairStation;
import com.mic.randomloot.blocks.tileentities.OpenerTileEntity;
import com.mic.randomloot.blocks.tileentities.RepairTileEntity;
import com.mic.randomloot.blocks.tileentities.TileEntityBreaker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final Block RANDOM_ANVIL = new RandomAnvil("random_anvil", RandomLoot.randomlootTab);
    public static final Block REPAIR_STATION = new RepairStation("repair_station");
    public static final Block OPENER = new CaseOpener("case_opener");
    public static final Block BREAKER = new Breaker("breaker");

    @Mod.EventBusSubscriber(modid="randomloot")
    public static class BlockRegistry {
        public static final Set<Block> BLOCK_SET = new HashSet<Block>();

        @SubscribeEvent
        public static void newRegistry(RegistryEvent.NewRegistry event) {
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Block> event) {
            GameRegistry.registerTileEntity(RepairTileEntity.class, (ResourceLocation)new ResourceLocation("randomloot:repair_station"));
            GameRegistry.registerTileEntity(OpenerTileEntity.class, (ResourceLocation)new ResourceLocation("randomloot:case_opener"));
            GameRegistry.registerTileEntity(TileEntityBreaker.class, (ResourceLocation)new ResourceLocation("randomloot:breaker"));
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                registry.register((IForgeRegistryEntry)block);
                BLOCK_SET.add(block);
            }
        }
    }
}

