/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.init.ItemFields;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.items.AxeItem;
import com.mic.randomloot.items.BowItem;
import com.mic.randomloot.items.ItemBase;
import com.mic.randomloot.items.PaxelItem;
import com.mic.randomloot.items.PickaxeItem;
import com.mic.randomloot.items.RandomArmor;
import com.mic.randomloot.items.ShovelItem;
import com.mic.randomloot.items.SwordItem;
import com.mic.randomloot.items.ThrowableWeapon;
import com.mic.randomloot.util.IRandomTool;
import com.mic.randomloot.util.WeightedChooser;
import com.mic.randomloot.util.handlers.ConfigHandler;
import com.mic.randomloot.util.handlers.NetworkHandler;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CaseItem
extends ItemBase {
    private static final UUID MODIFIER_UUID = UUID.fromString("294093da-54f0-4c1b-9dbb-13b77534a84c");
    static int level;
    int[] spawnChances = new int[4];

    public CaseItem(String name, int lvl) {
        super(name);
        level = lvl;
        this.func_77625_d(1);
        this.spawnChances[0] = ConfigHandler.playerChance;
        this.spawnChances[1] = ConfigHandler.animalChance;
        this.spawnChances[2] = ConfigHandler.mobChance;
        this.spawnChances[3] = ConfigHandler.bossChance;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        Random rand = new Random();
        if (worldIn.field_72995_K) {
            NetworkHandler.getNewItem();
        }
        for (int countparticles = 0; countparticles <= 25; ++countparticles) {
            worldIn.func_175688_a(EnumParticleTypes.CLOUD, playerIn.field_70165_t, playerIn.field_70163_u + 2.0, playerIn.field_70161_v, 0.1 * (double)this.getNegOrPos(), 0.1 * (double)this.getNegOrPos(), 0.1 * (double)this.getNegOrPos(), new int[0]);
        }
        worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187546_ae, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private int getLVL() {
        return level;
    }

    public int getNegOrPos() {
        Random rand = new Random();
        switch (rand.nextInt(3)) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 1;
    }

    public static int rollRarity(Item i) {
        return ModItems.ITEM_FIELDS.rollRarity(i);
    }

    public static ItemStack getItem(World worldIn, EntityLivingBase player, Item i) {
        Random rand = new Random();
        if (rand.nextInt(100) < ConfigHandler.chanceToDrop) {
            boolean iType = false;
            WeightedChooser<Item> wc = new WeightedChooser<Item>();
            if (ConfigHandler.swords) {
                wc.addChoice(ModItems.RL_SWORD, ConfigHandler.swordWeight);
            }
            if (ConfigHandler.pickaxes) {
                wc.addChoice(ModItems.RL_PICKAXE, ConfigHandler.pickWeight);
            }
            if (ConfigHandler.axes) {
                wc.addChoice(ModItems.RL_AXE, ConfigHandler.axeWeight);
            }
            if (ConfigHandler.shovels) {
                wc.addChoice(ModItems.RL_SHOVEL, ConfigHandler.shovelWeight);
            }
            if (ConfigHandler.bows) {
                wc.addChoice(ModItems.RL_BOW, ConfigHandler.bowWeight);
            }
            if (ConfigHandler.paxels) {
                wc.addChoice(ModItems.RL_PAXEL, ConfigHandler.paxelWeight);
            }
            if (ConfigHandler.armor) {
                wc.addChoice(ModItems.RANDOM_BOOTS, ConfigHandler.armorWeight);
                wc.addChoice(ModItems.RANDOM_CHEST, ConfigHandler.armorWeight);
                wc.addChoice(ModItems.RANDOM_LEGS, ConfigHandler.armorWeight);
                wc.addChoice(ModItems.RANDOM_HELMET, ConfigHandler.armorWeight);
                wc.addChoice(ModItems.TITANIUM_BOOTS, ConfigHandler.armorWeight);
                wc.addChoice(ModItems.TITANIUM_CHEST, ConfigHandler.armorWeight);
                wc.addChoice(ModItems.TITANIUM_LEGS, ConfigHandler.armorWeight);
                wc.addChoice(ModItems.TITANIUM_HELMET, ConfigHandler.armorWeight);
            }
            if (ConfigHandler.throwables) {
                wc.addChoice(ModItems.THROWABLE, ConfigHandler.throwWeight);
            }
            Item iChoice = (Item)wc.getRandomObject();
            IRandomTool toolChoice = (IRandomTool)iChoice;
            ItemStack item = new ItemStack(iChoice);
            if (iChoice instanceof SwordItem) {
                item = SwordItem.assignType(item);
                item = toolChoice.chooseTexture(item, 0);
            } else if (iChoice instanceof AxeItem) {
                item = AxeItem.assignType(item);
                item = toolChoice.chooseTexture(item, 0);
            } else if (iChoice instanceof PickaxeItem) {
                item = PickaxeItem.assignType(item);
                item = toolChoice.chooseTexture(item, 0);
            } else if (iChoice instanceof PaxelItem) {
                item = PaxelItem.assignType(item);
                item = toolChoice.chooseTexture(item, 0);
            } else if (iChoice instanceof ShovelItem) {
                item = ShovelItem.assignType(item);
                item = toolChoice.chooseTexture(item, 0);
            } else if (iChoice instanceof BowItem) {
                item = BowItem.assignType(item);
                item = toolChoice.chooseTexture(item, 0);
            } else if (iChoice instanceof RandomArmor) {
                item = RandomArmor.assignType(item);
            } else if (iChoice instanceof ThrowableWeapon) {
                item = ThrowableWeapon.assignType(item);
                item = toolChoice.chooseTexture(item, 0);
            }
            item.func_77973_b().func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

                @SideOnly(value=Side.CLIENT)
                public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    float model = 1.0f;
                    model = ItemFields.getTexture(stack);
                    return model;
                }
            });
            int rarity = CaseItem.rollRarity(i);
            NBTTagCompound compound = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
            NBTTagList modifiers = compound.func_74764_b("AttributeModifiers") ? compound.func_150295_c("AttributeModifiers", 10) : new NBTTagList();
            compound.func_74768_a("rarity", rarity);
            if (iChoice.equals(ModItems.RL_SWORD)) {
                NBTTagCompound damage = new NBTTagCompound();
                damage.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackDamage"));
                damage.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackDamage"));
                int dmg = ModItems.ITEM_FIELDS.calcDamage(rarity);
                damage.func_74782_a("Amount", (NBTBase)new NBTTagInt(dmg));
                damage.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                damage.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(3));
                damage.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(4));
                damage.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
                NBTTagCompound speed = new NBTTagCompound();
                speed.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackSpeed"));
                speed.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackSpeed"));
                double spd = ModItems.ITEM_FIELDS.calcSpeed(rarity) * -1.0;
                speed.func_74782_a("Amount", (NBTBase)new NBTTagDouble(spd));
                speed.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                speed.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(1));
                speed.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(2));
                speed.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
                compound.func_74768_a("damage", dmg);
                compound.func_74780_a("speed", spd);
                modifiers.func_74742_a((NBTBase)damage);
                modifiers.func_74742_a((NBTBase)speed);
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("sword"));
            } else if (iChoice.equals(ModItems.RL_PICKAXE)) {
                PickaxeItem pick = (PickaxeItem)item.func_77973_b();
                switch (rarity) {
                    case 1: {
                        pick.setDigSpeed(7 + rand.nextInt(6), item);
                        break;
                    }
                    case 2: {
                        pick.setDigSpeed(13 + rand.nextInt(5), item);
                        break;
                    }
                    case 3: {
                        pick.setDigSpeed(18 + rand.nextInt(5), item);
                    }
                }
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("pickaxe"));
            } else if (iChoice.equals(ModItems.RL_PAXEL)) {
                PaxelItem pick = (PaxelItem)item.func_77973_b();
                switch (rarity) {
                    case 1: {
                        pick.setDigSpeed(7 + rand.nextInt(6), item);
                        break;
                    }
                    case 2: {
                        pick.setDigSpeed(13 + rand.nextInt(5), item);
                        break;
                    }
                    case 3: {
                        pick.setDigSpeed(18 + rand.nextInt(5), item);
                    }
                }
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("paxel"));
            } else if (iChoice.equals(ModItems.RL_SHOVEL)) {
                ShovelItem shov = (ShovelItem)item.func_77973_b();
                switch (rarity) {
                    case 1: {
                        shov.setDigSpeed(7 + rand.nextInt(6), item);
                        break;
                    }
                    case 2: {
                        shov.setDigSpeed(13 + rand.nextInt(5), item);
                        break;
                    }
                    case 3: {
                        shov.setDigSpeed(18 + rand.nextInt(5), item);
                    }
                }
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("shovel"));
            } else if (iChoice.equals(ModItems.RL_AXE)) {
                AxeItem axe = (AxeItem)item.func_77973_b();
                switch (rarity) {
                    case 1: {
                        axe.setDigSpeed(7 + rand.nextInt(6), item);
                        break;
                    }
                    case 2: {
                        axe.setDigSpeed(13 + rand.nextInt(5), item);
                        break;
                    }
                    case 3: {
                        axe.setDigSpeed(18 + rand.nextInt(5), item);
                    }
                }
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("axe"));
            } else if (iChoice.equals(ModItems.RL_BOW)) {
                BowItem bow = (BowItem)item.func_77973_b();
                int max = Items.field_151031_f.func_77626_a(new ItemStack((Item)Items.field_151031_f));
                switch (rarity) {
                    case 1: {
                        bow.setVelo(max / 100 * 2 + rand.nextInt(max / 100 * 20), item);
                        break;
                    }
                    case 2: {
                        bow.setVelo(max / 100 * 30 + rand.nextInt(max / 100 * 20), item);
                        break;
                    }
                    case 3: {
                        bow.setVelo(max / 100 * 50 + rand.nextInt(max / 100 * 40), item);
                    }
                }
                compound.func_74776_a("velo", BowItem.getVelo(item));
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("bow"));
            } else if (iChoice.equals(ModItems.RANDOM_BOOTS) || iChoice.equals(ModItems.TITANIUM_BOOTS)) {
                double arm = 4.0;
                switch (rarity) {
                    case 1: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierOneMaxArmor - ConfigHandler.tierOneMinArmor) + (double)ConfigHandler.tierOneMinArmor;
                        break;
                    }
                    case 2: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierTwoMaxArmor - ConfigHandler.tierTwoMinArmor) + (double)ConfigHandler.tierTwoMinArmor;
                        break;
                    }
                    case 3: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierThreeMaxArmor - ConfigHandler.tierThreeMinArmor) + (double)ConfigHandler.tierThreeMinArmor;
                    }
                }
                NBTTagCompound armor = new NBTTagCompound();
                armor.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Name", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Amount", (NBTBase)new NBTTagDouble(arm *= 0.8));
                armor.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                armor.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(3));
                armor.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(4));
                armor.func_74782_a("Slot", (NBTBase)new NBTTagString("feet"));
                modifiers.func_74742_a((NBTBase)armor);
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("boots"));
            } else if (iChoice.equals(ModItems.RANDOM_CHEST) || iChoice.equals(ModItems.TITANIUM_CHEST)) {
                double arm = 4.0;
                switch (rarity) {
                    case 1: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierOneMaxArmor - ConfigHandler.tierOneMinArmor) + (double)ConfigHandler.tierOneMinArmor;
                        break;
                    }
                    case 2: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierTwoMaxArmor - ConfigHandler.tierTwoMinArmor) + (double)ConfigHandler.tierTwoMinArmor;
                        break;
                    }
                    case 3: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierThreeMaxArmor - ConfigHandler.tierThreeMinArmor) + (double)ConfigHandler.tierThreeMinArmor;
                    }
                }
                NBTTagCompound armor = new NBTTagCompound();
                armor.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Name", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Amount", (NBTBase)new NBTTagDouble(arm *= 1.0));
                armor.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                armor.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(5));
                armor.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(6));
                armor.func_74782_a("Slot", (NBTBase)new NBTTagString("chest"));
                modifiers.func_74742_a((NBTBase)armor);
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("chest"));
            } else if (iChoice.equals(ModItems.RANDOM_HELMET) || iChoice.equals(ModItems.TITANIUM_HELMET)) {
                double arm = 4.0;
                switch (rarity) {
                    case 1: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierOneMaxArmor - ConfigHandler.tierOneMinArmor) + (double)ConfigHandler.tierOneMinArmor;
                        break;
                    }
                    case 2: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierTwoMaxArmor - ConfigHandler.tierTwoMinArmor) + (double)ConfigHandler.tierTwoMinArmor;
                        break;
                    }
                    case 3: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierThreeMaxArmor - ConfigHandler.tierThreeMinArmor) + (double)ConfigHandler.tierThreeMinArmor;
                    }
                }
                NBTTagCompound armor = new NBTTagCompound();
                armor.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Name", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Amount", (NBTBase)new NBTTagDouble(arm *= 0.8));
                armor.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                armor.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(7));
                armor.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(8));
                armor.func_74782_a("Slot", (NBTBase)new NBTTagString("head"));
                modifiers.func_74742_a((NBTBase)armor);
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("helmet"));
            } else if (iChoice.equals(ModItems.RANDOM_LEGS) || iChoice.equals(ModItems.TITANIUM_LEGS)) {
                double arm = 4.0;
                switch (rarity) {
                    case 1: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierOneMaxArmor - ConfigHandler.tierOneMinArmor) + (double)ConfigHandler.tierOneMinArmor;
                        break;
                    }
                    case 2: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierTwoMaxArmor - ConfigHandler.tierTwoMinArmor) + (double)ConfigHandler.tierTwoMinArmor;
                        break;
                    }
                    case 3: {
                        arm = rand.nextDouble() * (double)(ConfigHandler.tierThreeMaxArmor - ConfigHandler.tierThreeMinArmor) + (double)ConfigHandler.tierThreeMinArmor;
                    }
                }
                NBTTagCompound armor = new NBTTagCompound();
                armor.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Name", (NBTBase)new NBTTagString("generic.armor"));
                armor.func_74782_a("Amount", (NBTBase)new NBTTagDouble(arm *= 0.9));
                armor.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                armor.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(9));
                armor.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(10));
                armor.func_74782_a("Slot", (NBTBase)new NBTTagString("legs"));
                modifiers.func_74742_a((NBTBase)armor);
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("legs"));
            } else if (iChoice.equals(ModItems.THROWABLE)) {
                double dam = 4.0;
                switch (rarity) {
                    case 1: {
                        dam = rand.nextDouble() * (double)(ConfigHandler.tierOneDamageMax - ConfigHandler.tierOneDamageMin) + (double)ConfigHandler.tierOneDamageMax;
                        break;
                    }
                    case 2: {
                        dam = rand.nextDouble() * (double)(ConfigHandler.tierTwoDamageMax - ConfigHandler.tierTwoDamageMin) + (double)ConfigHandler.tierTwoDamageMin;
                        break;
                    }
                    case 3: {
                        dam = rand.nextDouble() * (double)(ConfigHandler.tierThreeDamageMax - ConfigHandler.tierThreeDamageMin) + (double)ConfigHandler.tierThreeDamageMin;
                    }
                }
                compound.func_74776_a("damageToDeal", (float)(dam * 0.75));
                compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("throwable"));
                compound.func_74768_a("maxDamage", rarity * 128 / 2);
            }
            compound.func_74768_a("rarity", rarity);
            compound.func_74782_a("AttributeModifiers", (NBTBase)modifiers);
            item.func_77982_d(compound);
            if (iChoice.equals(ModItems.RL_SWORD)) {
                ((SwordItem)iChoice).setLore(item, player);
                ((SwordItem)iChoice).setName(item);
            } else if (iChoice.equals(ModItems.RL_PICKAXE)) {
                ((PickaxeItem)iChoice).setLore(item, player);
                ((PickaxeItem)iChoice).setName(item);
            } else if (iChoice.equals(ModItems.RL_PAXEL)) {
                ((PaxelItem)iChoice).setLore(item, player);
                ((PaxelItem)iChoice).setName(item);
            } else if (iChoice.equals(ModItems.RL_SHOVEL)) {
                ((ShovelItem)iChoice).setLore(item, player);
                ((ShovelItem)iChoice).setName(item);
            } else if (iChoice.equals(ModItems.RL_AXE)) {
                ((AxeItem)iChoice).setLore(item, player);
                ((AxeItem)iChoice).setName(item);
            } else if (iChoice.equals(ModItems.RL_BOW)) {
                ((BowItem)iChoice).setLore(item, player);
                ((BowItem)iChoice).setName(item);
            } else if (iChoice instanceof RandomArmor) {
                ((RandomArmor)iChoice).setLore(item, player);
                ((RandomArmor)iChoice).setName(item);
            } else if (iChoice.equals(ModItems.THROWABLE)) {
                ((ThrowableWeapon)iChoice).setLore(item, player);
                ((ThrowableWeapon)iChoice).setName(item);
            }
            return item;
        }
        return null;
    }

    public int getBossDropWeight() {
        return this.spawnChances[3];
    }

    public int getPlayerDropWeight() {
        return this.spawnChances[0];
    }

    public int getPassiveDropWeight() {
        return this.spawnChances[1];
    }

    public int getMonsterDropWeight() {
        return this.spawnChances[2];
    }

    public ItemStack getItem() {
        Random rand = new Random();
        switch (rand.nextInt(12)) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return new ItemStack((Item)ModItems.BASIC_CASE);
            }
            case 8: 
            case 9: 
            case 10: {
                return new ItemStack((Item)ModItems.GOLDEN_CASE);
            }
            case 11: {
                return new ItemStack((Item)ModItems.TITAN_CASE);
            }
        }
        return new ItemStack((Item)ModItems.BASIC_CASE);
    }
}

