/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.init.ItemFields;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.tags.BasicTag;
import com.mic.randomloot.tags.EffectTag;
import com.mic.randomloot.tags.TagHelper;
import com.mic.randomloot.tags.WorldInteractTag;
import com.mic.randomloot.util.IRandomTool;
import com.mic.randomloot.util.IReforgeable;
import com.mic.randomloot.util.TagUpdater;
import com.mic.randomloot.util.WeightedChooser;
import com.mic.randomloot.util.handlers.ConfigHandler;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PickaxeItem
extends ItemPickaxe
implements IReforgeable,
IRandomTool {
    static int pickaxes;
    public static int tCount;

    public PickaxeItem(Item.ToolMaterial material, int pickaxes) {
        super(material);
        PickaxeItem.pickaxes = pickaxes;
        this.func_77637_a(RandomLoot.randomlootTab);
        this.setRegistryName(new ResourceLocation("randomloot", "pickaxe"));
        this.func_77655_b("pickaxe");
        ModItems.ITEMS.add((Item)this);
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = ItemFields.getTexture(stack);
                return model;
            }
        });
    }

    @Override
    public ItemStack chooseTexture(ItemStack stack, int num) {
        Random rand = new Random();
        if (num == 0) {
            num = rand.nextInt(pickaxes) + 1;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Texture", num);
        stack.func_77982_d(nbt);
        return stack;
    }

    public boolean isRepairable() {
        return false;
    }

    public Item setNoRepair() {
        return super.setNoRepair();
    }

    public void xpUp(ItemStack stack, EntityLivingBase entityLiving, NBTTagCompound nbt) {
        int xp = nbt.func_74762_e("Xp");
        int lvlXp = nbt.func_74762_e("lvlXp");
        if (nbt.func_74764_b("Xp")) {
            nbt.func_74768_a("Xp", nbt.func_74762_e("Xp") + 1);
        } else {
            nbt.func_74768_a("Xp", 1);
        }
        if (xp >= lvlXp) {
            ModItems.ITEM_FIELDS.upgrade(stack, entityLiving);
        }
        stack.func_77982_d(nbt);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        NBTTagCompound nbt = (stack = TagUpdater.update(stack, (EntityPlayer)entityLiving)).func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        this.xpUp(stack, entityLiving, nbt);
        TextFormatting color = null;
        switch (nbt.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        List<BasicTag> tags = TagHelper.getAllTags(stack);
        for (int i = 0; i < tags.size(); ++i) {
            if (tags.get(i) instanceof EffectTag) {
                EffectTag eTag = (EffectTag)tags.get(i);
                eTag.runEffect(stack, worldIn, entityLiving);
                continue;
            }
            if (!(tags.get(i) instanceof WorldInteractTag)) continue;
            WorldInteractTag wTag = (WorldInteractTag)tags.get(i);
            wTag.runEffect(stack, worldIn, entityLiving, state, pos);
        }
        this.setLore(stack, entityLiving);
        this.setName(stack);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? super.func_150893_a(stack, state) : this.field_77864_a + this.getDigSpeed(stack);
    }

    public float getRLDigSpeed(ItemStack stack) {
        return 0.0f;
    }

    @Override
    public void setLore(ItemStack stack, EntityLivingBase player) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        NBTTagList lore = new NBTTagList();
        DecimalFormat f = new DecimalFormat("##.00");
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Mining Speed: " + f.format(this.getDigSpeed(stack))));
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        List<BasicTag> tags = TagHelper.getAllTags(stack);
        for (int i = 0; i < tags.size(); ++i) {
            String name = tags.get((int)i).name.replaceAll("_", " ");
            name = TagHelper.convertToTitleCaseIteratingChars(name);
            lore.func_74742_a((NBTBase)new NBTTagString(tags.get((int)i).color + name));
        }
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Level " + compound.func_74762_e("Lvl")));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "" + compound.func_74762_e("Xp") + "/" + compound.func_74762_e("lvlXp") + " Xp"));
        NBTTagCompound display = new NBTTagCompound();
        display.func_74782_a("Lore", (NBTBase)lore);
        compound.func_74782_a("display", (NBTBase)display);
        if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
            compound.func_74757_a("Unbreakable", true);
        } else {
            compound.func_74757_a("Unbreakable", false);
        }
    }

    @Override
    public ItemStack setName(ItemStack stack) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        stack.func_151001_c(color + compound.func_74779_i("name"));
        return stack;
    }

    public static ItemStack assignType(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        rand.setSeed(rand.nextInt(256));
        nbt.func_74768_a("HideFlags", 2);
        stack.func_77982_d(nbt);
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            BasicTag eTag;
            if (tag instanceof EffectTag) {
                eTag = (EffectTag)tag;
                if (!eTag.forTools) continue;
                allowedTags.add(eTag);
                continue;
            }
            if (!(tag instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tag;
            if (!((WorldInteractTag)eTag).forTools) continue;
            allowedTags.add(eTag);
        }
        allowedTags.add(TagHelper.AUTOSMELT);
        allowedTags.add(TagHelper.UNBREAKABLE);
        WeightedChooser<Integer> wc = new WeightedChooser<Integer>();
        wc.addChoice(1, 6);
        wc.addChoice(2, 3);
        wc.addChoice(3, 1);
        int totalTags = (Integer)wc.getRandomObject();
        for (int i = 0; i < totalTags; ++i) {
            BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
            while (TagHelper.checkForTag(stack, toAdd)) {
                toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                rand.setSeed(rand.nextLong() / 2L * (long)totalTags * (long)allowedTags.size() * (long)i);
            }
            TagHelper.addTag(stack, toAdd.name);
        }
        if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
            nbt.func_74757_a("Unbreakable", true);
        }
        return stack;
    }

    public float getDigSpeed(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        return nbt.func_74760_g("digSpeed");
    }

    public void setDigSpeed(float digSpeed, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74776_a("digSpeed", digSpeed);
    }

    public void addSpeed(float num, ItemStack stack) {
        this.setDigSpeed(this.getDigSpeed(stack) + num, stack);
    }

    @Override
    public ItemStack reforge(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74757_a("Unbreakable", false);
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        nbt.func_74768_a("HideFlags", 2);
        int rarity = nbt.func_74762_e("rarity");
        PickaxeItem.assignType(stack);
        PickaxeItem pick = (PickaxeItem)stack.func_77973_b();
        switch (rarity) {
            case 1: {
                pick.setDigSpeed(7 + rand.nextInt(6), stack);
                break;
            }
            case 2: {
                pick.setDigSpeed(13 + rand.nextInt(5), stack);
                break;
            }
            case 3: {
                pick.setDigSpeed(18 + rand.nextInt(5), stack);
            }
        }
        nbt.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("pickaxe"));
        return stack;
    }

    static {
        tCount = 11;
    }
}

