/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.tags;

import com.mic.randomloot.tags.BasicTag;
import com.mic.randomloot.tags.EffectTag;
import com.mic.randomloot.tags.WorldInteractTag;
import com.mic.randomloot.tags.worldinteract.ExplosionEvent;
import com.mic.randomloot.tags.worldinteract.FindEntitiesEvent;
import com.mic.randomloot.tags.worldinteract.FloatEvent;
import com.mic.randomloot.tags.worldinteract.ReplenishEvent;
import com.mic.randomloot.tags.worldinteract.TeleportItemsEvent;
import com.mic.randomloot.util.handlers.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;

public class TagHelper {
    public static List<BasicTag> allTags = new ArrayList<BasicTag>();
    public static List<String> tagNames = new ArrayList<String>();
    public static final EffectTag SPEED_ONE = new EffectTag("speedy", TextFormatting.AQUA, new PotionEffect(MobEffects.field_76424_c, 100, 0), false, false, true);
    public static final EffectTag SPEED_TWO = new EffectTag("speedier", TextFormatting.AQUA, new PotionEffect(MobEffects.field_76424_c, 100, 1), false, false, true);
    public static final EffectTag JUMP_ONE = new EffectTag("bouncy", TextFormatting.GREEN, new PotionEffect(MobEffects.field_76430_j, 100, 0), false, false, false);
    public static final EffectTag JUMP_TWO = new EffectTag("bouncier", TextFormatting.GREEN, new PotionEffect(MobEffects.field_76430_j, 100, 1), false, false, false);
    public static final EffectTag RESISTANCE_ONE = new EffectTag("resistant", TextFormatting.GRAY, new PotionEffect(MobEffects.field_76429_m, 100, 0), false, false, true);
    public static final EffectTag RESISTANCE_TWO = new EffectTag("more_resistant", TextFormatting.GRAY, new PotionEffect(MobEffects.field_76429_m, 100, 1), false, false, true);
    public static final EffectTag FIRE_RESISTANCE_ONE = new EffectTag("fire_resistant", TextFormatting.YELLOW, new PotionEffect(MobEffects.field_76426_n, 100, 0), false, false, false);
    public static final EffectTag FIRE_RESISTANCE_TWO = new EffectTag("more_fire_resistant", TextFormatting.YELLOW, new PotionEffect(MobEffects.field_76426_n, 100, 1), false, false, false);
    public static final EffectTag HASTE_ONE = new EffectTag("hastey", TextFormatting.YELLOW, new PotionEffect(MobEffects.field_76422_e, 100, 0), false, true, false);
    public static final EffectTag HASTE_TWO = new EffectTag("hastier", TextFormatting.YELLOW, new PotionEffect(MobEffects.field_76422_e, 100, 1), false, true, false);
    public static final EffectTag LUCK_ONE = new EffectTag("lucky", TextFormatting.GREEN, new PotionEffect(MobEffects.field_188425_z, 100, 0), false, true, false);
    public static final EffectTag LUCK_TWO = new EffectTag("super_lucky", TextFormatting.GREEN, new PotionEffect(MobEffects.field_188425_z, 100, 1), false, true, false);
    public static final EffectTag STRENGTH_ONE = new EffectTag("strong", TextFormatting.DARK_RED, new PotionEffect(MobEffects.field_76420_g, 100, 0), false, false, true);
    public static final EffectTag STRENGTH_TWO = new EffectTag("stronger", TextFormatting.DARK_RED, new PotionEffect(MobEffects.field_76420_g, 100, 1), false, false, true);
    public static final EffectTag NIGHT_VISION = new EffectTag("insightful", TextFormatting.BLUE, new PotionEffect(MobEffects.field_76439_r, 100, 0), false, false, false);
    public static final EffectTag WATER_BREATHING = new EffectTag("deep_breathing", TextFormatting.DARK_BLUE, new PotionEffect(MobEffects.field_76427_o, 100, 0), false, false, false);
    public static final EffectTag REGENERATION = new EffectTag("regenerating", TextFormatting.RED, new PotionEffect(MobEffects.field_76428_l, 100, 0), false, false, true);
    public static final EffectTag POISON_ONE = new EffectTag("poisonous", TextFormatting.DARK_GREEN, new PotionEffect(MobEffects.field_76436_u, 100, 0), true, false, true);
    public static final EffectTag POISON_TWO = new EffectTag("very_poisonous", TextFormatting.DARK_GREEN, new PotionEffect(MobEffects.field_76436_u, 100, 1), true, false, true);
    public static final EffectTag WITHER_ONE = new EffectTag("withering", TextFormatting.DARK_GRAY, new PotionEffect(MobEffects.field_82731_v, 100, 0), true, false, true);
    public static final EffectTag WITHER_TWO = new EffectTag("very_withering", TextFormatting.DARK_GRAY, new PotionEffect(MobEffects.field_82731_v, 100, 1), true, false, true);
    public static final EffectTag SLOWING_ONE = new EffectTag("webbed", TextFormatting.WHITE, new PotionEffect(MobEffects.field_76421_d, 100, 0), true, false, true);
    public static final EffectTag SLOWING_TWO = new EffectTag("double_webbed", TextFormatting.WHITE, new PotionEffect(MobEffects.field_76421_d, 160, 1), true, false, true);
    public static final EffectTag BLINDING = new EffectTag("blinding", TextFormatting.DARK_PURPLE, new PotionEffect(MobEffects.field_76440_q, 100, 0), true, false, true);
    public static final EffectTag GLOWING = new EffectTag("glittering", TextFormatting.GOLD, new PotionEffect(MobEffects.field_188423_x, 100, 0), true, false, true);
    public static final EffectTag DAMAGE_ONE = new EffectTag("damage+", TextFormatting.DARK_RED, new PotionEffect(MobEffects.field_76433_i, 120, 1), true, false, true);
    public static final EffectTag DAMAGE_TWO = new EffectTag("damage++", TextFormatting.DARK_RED, new PotionEffect(MobEffects.field_76433_i, 120, 2), true, false, true);
    public static final EffectTag WEAKNESS_ONE = new EffectTag("weakening", TextFormatting.GRAY, new PotionEffect(MobEffects.field_76437_t, 100, 0), true, false, true);
    public static final EffectTag WEAKNESS_TWO = new EffectTag("very_weakening", TextFormatting.GRAY, new PotionEffect(MobEffects.field_76437_t, 100, 2), true, false, true);
    public static final EffectTag FLOATING = new EffectTag("floating", TextFormatting.AQUA, new PotionEffect(MobEffects.field_188424_y, 100, 0), true, false, true);
    public static final WorldInteractTag EXPLOSION = new WorldInteractTag("explosive", TextFormatting.RED, new ExplosionEvent(), true, false, false);
    public static final WorldInteractTag REPLENISH = new WorldInteractTag("filling", TextFormatting.DARK_GREEN, new ReplenishEvent(), true, false, true);
    public static final WorldInteractTag TELEPORT_ITEMS = new WorldInteractTag("phasing", TextFormatting.AQUA, new TeleportItemsEvent(), true, false, false);
    public static final WorldInteractTag FIND_ENTITIES = new WorldInteractTag("soul_searching", TextFormatting.YELLOW, new FindEntitiesEvent(), false, true, false);
    public static final WorldInteractTag CLOUD_WALKER = new WorldInteractTag("cloud_walker", TextFormatting.YELLOW, new FloatEvent(), false, true, false);
    public static final BasicTag UNBREAKABLE = new BasicTag("fortified", TextFormatting.BLUE);
    public static final BasicTag AUTOSMELT = new BasicTag("auto-smelt", TextFormatting.DARK_RED);

    public static ItemStack addTag(ItemStack stack, String tagName) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int index = 0;
        while (!nbt.func_74779_i(index + "").equals("")) {
            System.out.println(index);
            if (nbt.func_74779_i(index + "").equals(tagName)) {
                return stack;
            }
            if (++index <= 10) continue;
            return stack;
        }
        nbt.func_74778_a(index + "", tagName);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack removeTag(ItemStack stack, String tagName) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int index = 0;
        while (!nbt.func_74779_i(index + "").equals("")) {
            if (nbt.func_74779_i(index + "").equals(tagName)) {
                nbt.func_74778_a(index + "", "");
                return stack;
            }
            if (++index <= 10) continue;
            return stack;
        }
        nbt.func_74778_a(index + "", tagName);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack removeAllTags(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int index = 0;
        while (!nbt.func_74779_i(index + "").equals("")) {
            nbt.func_74778_a(index + "", "");
            if (++index <= 10) continue;
            return stack;
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public static boolean checkForTag(ItemStack stack, BasicTag tag) {
        return TagHelper.getAllTags(stack).contains(tag);
    }

    public static List<BasicTag> getTagList(ItemStack stack) {
        ArrayList<BasicTag> tags = new ArrayList<BasicTag>();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        for (int i = 0; i < 10; ++i) {
            String tag = nbt.func_74779_i(i + "");
            if (tag.equals("")) continue;
            for (int j = 0; j < allTags.size(); ++j) {
                if (!tag.equals(TagHelper.allTags.get((int)j).name)) continue;
                tags.add(allTags.get(j));
            }
        }
        return tags;
    }

    public static List<BasicTag> getAllTags(ItemStack stack) {
        ArrayList<BasicTag> tags = new ArrayList<BasicTag>();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        for (int i = 0; i < 10; ++i) {
            String tag = nbt.func_74779_i(i + "");
            if (tag.equals("")) continue;
            for (int j = 0; j < allTags.size(); ++j) {
                if (!tag.equals(TagHelper.allTags.get((int)j).name) || !((Boolean)ConfigHandler.traitsEnabled.get(j)).booleanValue()) continue;
                tags.add(allTags.get(j));
            }
        }
        return tags;
    }

    public static String convertToTitleCaseIteratingChars(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder converted = new StringBuilder();
        boolean convertNext = true;
        for (char ch : text.toCharArray()) {
            if (Character.isSpaceChar(ch)) {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
            } else {
                ch = Character.toLowerCase(ch);
            }
            converted.append(ch);
        }
        return converted.toString();
    }
}

