/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.blocks;

import com.mic.randomloot.init.ModBlocks;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.util.IReforgeable;
import com.mic.randomloot.util.handlers.ConfigHandler;
import com.mic.randomloot.util.handlers.NetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RandomAnvil
extends BlockFalling {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 1.0, 0.875);
    protected static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 1.0);
    protected static final Logger LOGGER = LogManager.getLogger();

    public RandomAnvil(String name, CreativeTabs tab) {
        super(Material.field_151574_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149713_g(0);
        this.func_149647_a(tab);
        this.field_149762_H = SoundType.field_185858_k;
        this.field_149782_v = 15.0f;
        this.field_149781_w = 3.0f;
        this.setHarvestLevel("pickaxe", 1);
        ModBlocks.BLOCKS.add((Block)this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(name));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer.func_174811_aO().func_176746_e();
        try {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        catch (IllegalArgumentException var11) {
            if (!worldIn.field_72995_K) {
                LOGGER.warn(String.format("Invalid damage property for anvil at %s. Found %d, must be in [0, 1, 2]", pos, meta >> 2));
                if (placer instanceof EntityPlayer) {
                    placer.func_145747_a((ITextComponent)new TextComponentTranslation("Invalid damage property. Please pick in [0, 1, 2]", new Object[0]));
                }
            }
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, 0, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return enumfacing.func_176740_k() == EnumFacing.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
    }

    protected void func_149829_a(EntityFallingBlock fallingEntity) {
        fallingEntity.func_145806_a(true);
    }

    public void func_176502_a_(World worldIn, BlockPos pos, IBlockState p_176502_3_, IBlockState p_176502_4_) {
        worldIn.func_175718_b(1031, pos, 0);
    }

    public void func_190974_b(World worldIn, BlockPos pos) {
        worldIn.func_175718_b(1029, pos, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177230_c() != this ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand.equals((Object)EnumHand.MAIN_HAND) && worldIn.field_72995_K) {
            if (playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof IReforgeable) {
                ItemStack offHand = playerIn.func_184586_b(EnumHand.OFF_HAND);
                int count = ConfigHandler.reforgeItemCount;
                String itemName = ConfigHandler.reforgeItemName;
                Item itemToUse = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName.substring(0, itemName.indexOf(":")), itemName.substring(itemName.indexOf(58) + 1)));
                if (offHand.func_77973_b().equals(itemToUse) && offHand.func_190916_E() > count || count == 0) {
                    NetworkHandler.reforge();
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("Item reforged."));
                    return true;
                }
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Not enough " + itemName.substring(itemName.indexOf(58) + 1).replaceAll("_", " ") + " in off-hand."));
                return true;
            }
            playerIn.func_145747_a((ITextComponent)new TextComponentString("This item cannot be reforged."));
            return true;
        }
        return true;
    }
}

