/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.blocks.recipes;

import com.google.common.collect.Maps;
import com.mic.randomloot.init.ModItems;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BreakerRecipes {
    private static final BreakerRecipes INSTANCE = new BreakerRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static BreakerRecipes getInstance() {
        return INSTANCE;
    }

    private BreakerRecipes() {
        this.addBreakingRecipe(new ItemStack(ModItems.RL_PICKAXE), new ItemStack(ModItems.RANDOM_SHARD, 3), 4.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RL_AXE), new ItemStack(ModItems.RANDOM_SHARD, 3), 5.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RL_BOW), new ItemStack(ModItems.RANDOM_SHARD, 3), 5.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RL_PAXEL), new ItemStack(ModItems.RANDOM_SHARD, 3), 5.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RANDOM_BOOTS), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RANDOM_CHEST), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RANDOM_HELMET), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RANDOM_LEGS), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RL_SHOVEL), new ItemStack(ModItems.RANDOM_SHARD, 3), 5.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.RL_SWORD), new ItemStack(ModItems.RANDOM_SHARD, 3), 3.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.THROWABLE), new ItemStack(ModItems.RANDOM_SHARD, 3), 7.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.TITANIUM_BOOTS), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.TITANIUM_CHEST), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.TITANIUM_HELMET), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
        this.addBreakingRecipe(new ItemStack(ModItems.TITANIUM_LEGS), new ItemStack(ModItems.RANDOM_SHARD, 3), 6.0f);
    }

    public void addBreakingRecipe(ItemStack input, ItemStack result, float experience) {
        if (this.getBreakingResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.smeltingList.put(input, result);
        this.experienceList.put(result, Float.valueOf(experience));
    }

    public ItemStack getBreakingResult(ItemStack input1) {
        Random rand = new Random();
        NBTTagCompound compound = input1.func_77942_o() ? input1.func_77978_p() : new NBTTagCompound();
        int rarity = compound.func_74762_e("rarity");
        for (ItemStack entry : this.smeltingList.keySet()) {
            if (!this.compareItemStacks(input1, entry)) continue;
            ItemStack i = this.smeltingList.get(entry);
            i.func_190920_e(rand.nextInt(3) + rarity);
            return i;
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getBreakingExperience(ItemStack stack) {
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

