/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.init;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.items.AxeItem;
import com.mic.randomloot.items.BowItem;
import com.mic.randomloot.items.PickaxeItem;
import com.mic.randomloot.items.RandomArmor;
import com.mic.randomloot.items.ShovelItem;
import com.mic.randomloot.tags.BasicTag;
import com.mic.randomloot.tags.EffectTag;
import com.mic.randomloot.tags.TagHelper;
import com.mic.randomloot.tags.WorldInteractTag;
import com.mic.randomloot.util.IRandomTool;
import com.mic.randomloot.util.WeightedChooser;
import com.mic.randomloot.util.handlers.ConfigHandler;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.SoundCategory;

public class ItemFields {
    public static String[] adjectivesUniversal;
    public static String[] adjectivesShovels;
    public static String[] nounsSwords;
    public static String[] adjectivesSwords;
    public static String[] nounsShovels;
    public static String[] adjectivesPickaxes;
    public static String[] nounsPickaxes;
    public static String[] adjectivesAxes;
    public static String[] nounsAxes;
    public static String[] adjectivesBows;
    public static String[] nounsBows;
    private static Random rand;
    private static String[] adjectivesBoots;
    private static String[] nounsBoots;
    private static String[] adjectivesLegs;
    private static String[] nounsLegs;
    private static String[] adjectivesChest;
    private static String[] nounsChest;
    private static String[] adjectivesHelmet;
    private static String[] nounsHelmet;
    private static String[] nounsPaxels;
    private static String[] nounsThrowables;
    private static String[] adjectivesThrowables;

    public ItemFields() {
        String[] adjectivesUniversal = new String[]{"Blazing", "Dark", "Dainty", "Jewel Encrusted", "Light", "Heavy", "Serious", "Enlightened", "Swift", "Titanic", "Crude", "Icy", "Mythic", "Epic", "Legendary", "Awesome", "Incredible", "Shocking", "Iron", "Titanium", "Soft", "Pretty", "Sweet", "Steel", "Elder", "Ancient", "Advanced", "Dreadful", "Shiny", "Alien", "Twisted", "Necro", "Molten", "Crimson", "Shadow", "Fossilized", "Platinum", "Galactic", "Ripe", "Stary", "Vortex", "Nightmarish", "Spectre", "Nebula"};
        String[] adjectivesSwords = new String[]{"Fearsome", "Brutal", "Terrifying", "Harsh", "Barbaric", "Bloodthirsty", "Heartless", "Merciless", "Ruthless", "Savage", "Cold-Blooded", "Fearsome"};
        String[] adjectivesShovels = new String[]{"Rusty", "Filthy", "Shining", "Powerful", "Ground-Breaking", "Sharpened", "Crackling"};
        String[] adjectivesPickaxes = new String[]{"Rusty", "Reliable", "Gritty", "Powerful", "Terra", "Hammering", "Sturdy", "Crystaline", "Pointy"};
        String[] nounsPickaxes = new String[]{"Digger", "Terrablade", "Harbringer", "Earth Shatterer", "Crust-Breaker", "Hole-Puncher", "Point", "Swinger", "Mountain Mover", "Pickaxe", "Pick", "Gold Digger", "Jackhammer"};
        String[] adjectivesBows = new String[]{"Quivering", "Heavy-Bolted", "Venomous", "Whistling", "Atuned", "Starstruck"};
        String[] nounsBows = new String[]{"Bow", "Fletcher", "Slinger", "Bolt-Tosser", "Warp-Bow", "Piercer", "Hunting Bow", "Crossbow", "Basilisk", "Launcher"};
        String[] adjectivesAxes = new String[]{"Towering", "Wooden", "Fireman's", "Gracious", "Lumbering", "Felling", "Swinging"};
        String[] nounsAxes = new String[]{"Chopper", "Axe", "Hatchet", "Splitter", "Tomahawk", "Tremor", "Greataxe", "War Axe", "Broadaxe", "Ravager", "Reaver", "Halberd", "Hacker", "Battle Axe", "Lumber Axe"};
        String[] nounsPaxels = new String[]{"Spiker", "Chop-Digger", "Pick-Logger", "Brute"};
        String[] nounsShovels = new String[]{"Spade", "Shovel", "Shatter", "Trowel", "Scoop", "Gravedigger", "Spoon"};
        String[] nounsSwords = new String[]{"Blade", "Sword", "Slasher", "Titan", "Killer", "Cleaver", "Knife", "Cutlass", "Nightmare", "Glaive", "Machete", "Saber", "Claymore", "Doomblade", "Defender", "Striker", "Crusader", "Skewer", "Chaos", "Infinity", "Broadsword", "Shortsword", "Architect", "Lance", "Bat", "Th0rn"};
        String[] nounsBoots = new String[]{"Boots", "Booties", "Feet", "Runners", "Tires", "Shoes"};
        String[] adjectivesBoots = new String[]{"Swift", "Fast"};
        String[] nounsLegs = new String[]{"Leggings", "Pants", "Shorts", "Knickers", "Trousers", "Drawers", "Briefs", "Chaps", "Jeans"};
        String[] adjectivesLegs = new String[]{"Thick", "Sweaty"};
        String[] nounsChest = new String[]{"Chestplate", "Breastplate", "Shirt", "Chest", "Armor Piece", "Shell"};
        String[] adjectivesChest = new String[]{"Heavy", "Blast-Resistant"};
        String[] nounsHelmet = new String[]{"Helmet", "Helm", "Hat", "Hard Hat", "Head Protector", "Skull"};
        String[] adjectivesHelmet = new String[]{"Upright", "Weighted"};
        String[] adjectivesThrowables = new String[]{"Throwable", "Tossable", "Throwing", "Gliding", "Floating", "Whizzing", "Zipping", "Flying", "Zooming", "Chuckable"};
        String[] nounsThrowables = new String[]{"Hammer", "Star", "Hatchet", "Object", "Boomerang", "Knife", "Weapon", "Stick"};
        ItemFields.adjectivesUniversal = adjectivesUniversal;
        ItemFields.adjectivesPickaxes = adjectivesPickaxes;
        ItemFields.nounsPickaxes = nounsPickaxes;
        ItemFields.adjectivesShovels = adjectivesShovels;
        ItemFields.nounsShovels = nounsShovels;
        ItemFields.adjectivesSwords = adjectivesSwords;
        ItemFields.nounsSwords = nounsSwords;
        ItemFields.adjectivesAxes = adjectivesAxes;
        ItemFields.nounsAxes = nounsAxes;
        ItemFields.adjectivesBows = adjectivesBows;
        ItemFields.nounsBows = nounsBows;
        ItemFields.adjectivesBoots = adjectivesBoots;
        ItemFields.nounsBoots = nounsBoots;
        ItemFields.adjectivesChest = adjectivesChest;
        ItemFields.nounsChest = nounsChest;
        ItemFields.adjectivesLegs = adjectivesLegs;
        ItemFields.nounsLegs = nounsLegs;
        ItemFields.adjectivesHelmet = adjectivesHelmet;
        ItemFields.nounsHelmet = nounsHelmet;
        ItemFields.nounsPaxels = nounsPaxels;
        ItemFields.nounsThrowables = nounsThrowables;
        ItemFields.adjectivesThrowables = adjectivesThrowables;
    }

    public int rollRarity(Item i) {
        int x;
        boolean tier = false;
        int[] basicChance = new int[]{90, 7, 3};
        int[] goldenChance = new int[]{60, 30, 10};
        int[] titanChance = new int[]{20, 55, 25};
        int caseType = 0;
        if (i.equals((Object)ModItems.BASIC_CASE)) {
            caseType = 1;
        } else if (i.equals((Object)ModItems.GOLDEN_CASE)) {
            caseType = 2;
        } else if (i.equals((Object)ModItems.TITAN_CASE)) {
            caseType = 3;
        }
        int[] chance = null;
        switch (caseType) {
            case 1: {
                if (ConfigHandler.dropType == 1) {
                    return 1;
                }
                chance = basicChance;
                break;
            }
            case 2: {
                if (ConfigHandler.dropType == 1) {
                    return 2;
                }
                chance = goldenChance;
                break;
            }
            case 3: {
                if (ConfigHandler.dropType == 1) {
                    return 3;
                }
                chance = titanChance;
            }
        }
        int[] rarity = new int[100];
        for (x = 0; x < chance[0]; ++x) {
            rarity[x] = 1;
        }
        for (x = 0; x < chance[1]; ++x) {
            rarity[chance[0] + x] = 2;
        }
        for (x = 0; x < chance[2]; ++x) {
            rarity[chance[0] + chance[1] + x] = 3;
        }
        if (ConfigHandler.dropType == 1) {
            System.out.println("You goofed");
        }
        return rarity[rand.nextInt(rarity.length)];
    }

    public String nameItem(String type) {
        String adj = null;
        String nn = null;
        if (type.equals("pickaxe")) {
            String[] adjs = this.mergeArrs(adjectivesPickaxes, adjectivesUniversal);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsPickaxes[rand.nextInt(nounsPickaxes.length)];
        } else if (type.equals("sword")) {
            String[] adjs = this.mergeArrs(adjectivesSwords, adjectivesUniversal);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsSwords[rand.nextInt(nounsSwords.length)];
        } else if (type.equals("shovel")) {
            String[] adjs = this.mergeArrs(adjectivesShovels, adjectivesUniversal);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsShovels[rand.nextInt(nounsShovels.length)];
        } else if (type.equals("axe")) {
            String[] adjs = this.mergeArrs(adjectivesAxes, adjectivesUniversal);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsAxes[rand.nextInt(nounsAxes.length)];
        } else if (type.equals("paxel")) {
            String[] adjs = this.mergeArrs(adjectivesAxes, adjectivesUniversal);
            adjs = this.mergeArrs(adjs, adjectivesPickaxes);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsPaxels[rand.nextInt(nounsPaxels.length)];
        } else if (type.equals("bow")) {
            String[] adjs = this.mergeArrs(adjectivesBows, adjectivesUniversal);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsBows[rand.nextInt(nounsBows.length)];
        } else if (type.equals("boots")) {
            String[] adjs = this.mergeArrs(adjectivesUniversal, adjectivesBoots);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsBoots[rand.nextInt(nounsBoots.length)];
        } else if (type.equals("legs")) {
            String[] adjs = this.mergeArrs(adjectivesUniversal, adjectivesLegs);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsLegs[rand.nextInt(nounsLegs.length)];
        } else if (type.equals("chest")) {
            String[] adjs = this.mergeArrs(adjectivesUniversal, adjectivesChest);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsChest[rand.nextInt(nounsChest.length)];
        } else if (type.equals("helmet")) {
            String[] adjs = this.mergeArrs(adjectivesUniversal, adjectivesHelmet);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsHelmet[rand.nextInt(nounsHelmet.length)];
        } else if (type.equals("throwable")) {
            String[] adjs = this.mergeArrs(adjectivesUniversal, adjectivesThrowables);
            adj = adjs[rand.nextInt(adjs.length)];
            nn = nounsThrowables[rand.nextInt(nounsThrowables.length)];
        }
        return adj + " " + nn;
    }

    public String[] mergeArrs(String[] a, String[] b) {
        int length = a.length + b.length;
        String[] result = new String[length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static int getTexture(ItemStack stack) {
        int value = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Texture")) {
            value = stack.func_77978_p().func_74762_e("Texture");
        }
        return value;
    }

    public int calcDamage(int tier) {
        double min = 0.0;
        double max = 0.0;
        switch (tier) {
            case 1: {
                max = ConfigHandler.tierOneDamageMax;
                min = ConfigHandler.tierOneDamageMin;
                break;
            }
            case 2: {
                max = ConfigHandler.tierTwoDamageMax;
                min = ConfigHandler.tierTwoDamageMin;
                break;
            }
            case 3: {
                max = ConfigHandler.tierThreeDamageMax;
                min = ConfigHandler.tierThreeDamageMin;
            }
        }
        return (int)(min + (max - min) * rand.nextDouble());
    }

    public double calcSpeed(int tier) {
        double min = 0.0;
        double max = 0.0;
        switch (tier) {
            case 1: {
                max = 2.4;
                min = 2.0;
                break;
            }
            case 2: {
                max = 2.1;
                min = 1.8;
                break;
            }
            case 3: {
                max = 2.0;
                min = 1.2;
            }
        }
        return min + (max - min) * rand.nextDouble();
    }

    public float displaySpeed(double spd, EntityLivingBase player) {
        return (float)(player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b() + spd);
    }

    public void upgrade(ItemStack stack, EntityLivingBase player) {
        boolean isArmor = false;
        if (player instanceof EntityPlayer) {
            player.func_130014_f_().func_184133_a((EntityPlayer)player, player.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
            NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            NBTTagList modifiers = new NBTTagList();
            int lvl = compound.func_74762_e("Lvl");
            compound.func_74768_a("Lvl", ++lvl);
            if (stack.func_77973_b().equals(ModItems.RL_SWORD)) {
                int dmg = compound.func_74762_e("damage");
                double spd = compound.func_74769_h("speed");
                switch (rand.nextInt(3) + 1) {
                    case 1: {
                        ++dmg;
                        break;
                    }
                    case 2: {
                        spd += 0.05;
                        break;
                    }
                    case 3: {
                        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
                        for (BasicTag tag : TagHelper.allTags) {
                            BasicTag eTag;
                            if (tag instanceof EffectTag) {
                                eTag = (EffectTag)tag;
                                if (!eTag.forWeapons) continue;
                                allowedTags.add(eTag);
                                continue;
                            }
                            if (!(tag instanceof WorldInteractTag)) continue;
                            eTag = (WorldInteractTag)tag;
                            if (!((WorldInteractTag)eTag).forWeapons) continue;
                            allowedTags.add(eTag);
                        }
                        allowedTags.add(TagHelper.UNBREAKABLE);
                        allowedTags.add(TagHelper.REPLENISH);
                        BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        while (TagHelper.checkForTag(stack, toAdd)) {
                            toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        }
                        TagHelper.addTag(stack, toAdd.name);
                        if (!TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) || !ConfigHandler.unbreakable) break;
                        compound.func_74757_a("Unbreakable", true);
                    }
                }
                NBTTagCompound damage = new NBTTagCompound();
                damage.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackDamage"));
                damage.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackDamage"));
                damage.func_74782_a("Amount", (NBTBase)new NBTTagInt(dmg));
                damage.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                damage.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(3));
                damage.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(4));
                damage.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
                NBTTagCompound speed = new NBTTagCompound();
                speed.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackSpeed"));
                speed.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackSpeed"));
                speed.func_74782_a("Amount", (NBTBase)new NBTTagDouble(spd));
                speed.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
                speed.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(1));
                speed.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(2));
                speed.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
                compound.func_74768_a("damage", dmg);
                compound.func_74780_a("speed", spd);
                modifiers.func_74742_a((NBTBase)damage);
                modifiers.func_74742_a((NBTBase)speed);
            } else if (stack.func_77973_b().equals(ModItems.RL_PICKAXE)) {
                PickaxeItem i = (PickaxeItem)stack.func_77973_b();
                Random rand = new Random();
                switch (rand.nextInt(2) + 1) {
                    case 1: {
                        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
                        for (BasicTag tag : TagHelper.allTags) {
                            BasicTag eTag;
                            if (tag instanceof EffectTag) {
                                eTag = (EffectTag)tag;
                                if (!eTag.forTools) continue;
                                allowedTags.add(eTag);
                                continue;
                            }
                            if (!(tag instanceof WorldInteractTag)) continue;
                            eTag = (WorldInteractTag)tag;
                            if (!((WorldInteractTag)eTag).forTools) continue;
                            allowedTags.add(eTag);
                        }
                        allowedTags.add(TagHelper.AUTOSMELT);
                        allowedTags.add(TagHelper.UNBREAKABLE);
                        BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        while (TagHelper.checkForTag(stack, toAdd)) {
                            toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        }
                        TagHelper.addTag(stack, toAdd.name);
                        if (!TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) || !ConfigHandler.unbreakable) break;
                        compound.func_74757_a("Unbreakable", true);
                        break;
                    }
                    case 2: {
                        float num = (float)((double)rand.nextFloat() + 0.3);
                        i.addSpeed(num, stack);
                    }
                }
                i.setLore(stack, player);
            } else if (stack.func_77973_b().equals(ModItems.RL_SHOVEL)) {
                ShovelItem i = (ShovelItem)stack.func_77973_b();
                Random rand = new Random();
                switch (rand.nextInt(2) + 1) {
                    case 1: {
                        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
                        for (BasicTag tag : TagHelper.allTags) {
                            BasicTag eTag;
                            if (tag instanceof EffectTag) {
                                eTag = (EffectTag)tag;
                                if (!eTag.forTools) continue;
                                allowedTags.add(eTag);
                                continue;
                            }
                            if (!(tag instanceof WorldInteractTag)) continue;
                            eTag = (WorldInteractTag)tag;
                            if (!((WorldInteractTag)eTag).forTools) continue;
                            allowedTags.add(eTag);
                        }
                        allowedTags.add(TagHelper.AUTOSMELT);
                        allowedTags.add(TagHelper.UNBREAKABLE);
                        WeightedChooser<Integer> wc = new WeightedChooser<Integer>();
                        wc.addChoice(1, 6);
                        wc.addChoice(2, 3);
                        wc.addChoice(3, 1);
                        BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        while (TagHelper.checkForTag(stack, toAdd)) {
                            toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        }
                        TagHelper.addTag(stack, toAdd.name);
                        if (!TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) || !ConfigHandler.unbreakable) break;
                        compound.func_74757_a("Unbreakable", true);
                        break;
                    }
                    case 2: {
                        float num = (float)((double)rand.nextFloat() + 0.3);
                        i.addSpeed(num, stack);
                    }
                }
                i.setLore(stack, player);
            } else if (stack.func_77973_b().equals(ModItems.RL_AXE)) {
                AxeItem i = (AxeItem)stack.func_77973_b();
                Random rand = new Random();
                switch (rand.nextInt(2) + 1) {
                    case 1: {
                        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
                        for (BasicTag tag : TagHelper.allTags) {
                            BasicTag eTag;
                            if (tag instanceof EffectTag) {
                                eTag = (EffectTag)tag;
                                if (!eTag.forTools) continue;
                                allowedTags.add(eTag);
                                continue;
                            }
                            if (!(tag instanceof WorldInteractTag)) continue;
                            eTag = (WorldInteractTag)tag;
                            if (!((WorldInteractTag)eTag).forTools) continue;
                            allowedTags.add(eTag);
                        }
                        allowedTags.add(TagHelper.AUTOSMELT);
                        allowedTags.add(TagHelper.UNBREAKABLE);
                        BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        while (TagHelper.checkForTag(stack, toAdd)) {
                            toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                        }
                        TagHelper.addTag(stack, toAdd.name);
                        if (!TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) || !ConfigHandler.unbreakable) break;
                        compound.func_74757_a("Unbreakable", true);
                        break;
                    }
                    case 2: {
                        float num = (float)((double)rand.nextFloat() + 0.3);
                        i.addSpeed(num, stack);
                    }
                }
                i.setLore(stack, player);
            } else if (stack.func_77973_b().equals(ModItems.RL_BOW)) {
                BowItem i = (BowItem)stack.func_77973_b();
                Random rand = new Random();
                switch (rand.nextInt(2) + 1) {
                    case 1: {
                        if (compound.func_74762_e("T1") <= 0 && rand.nextInt(10) == 9) {
                            compound.func_74768_a("T1", rand.nextInt(11) + 1);
                        }
                        if (compound.func_74762_e("T2") <= 0 && rand.nextInt(10) == 9) {
                            compound.func_74768_a("T2", rand.nextInt(11) + 1);
                        }
                        if (compound.func_74762_e("T3") > 0 || rand.nextInt(10) != 9) break;
                        compound.func_74768_a("T3", rand.nextInt(11) + 1);
                        break;
                    }
                    case 2: {
                        i.setVelo(BowItem.getVelo(stack) + (float)rand.nextInt(9500), stack);
                        compound.func_74776_a("velo", BowItem.getVelo(stack));
                    }
                }
                i.setLore(stack, player);
            } else if (stack.func_77973_b() instanceof RandomArmor) {
                isArmor = true;
                ArrayList<EffectTag> allowedTags = new ArrayList<EffectTag>();
                for (BasicTag tag : TagHelper.allTags) {
                    if (!(tag instanceof EffectTag)) continue;
                    EffectTag eTag = (EffectTag)tag;
                    if (eTag.offensive) continue;
                    allowedTags.add(eTag);
                }
                TagHelper.addTag(stack, ((BasicTag)allowedTags.get((int)ItemFields.rand.nextInt((int)allowedTags.size()))).name);
                if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
                    compound.func_74757_a("Unbreakable", true);
                }
            } else if (stack.func_77973_b().equals(ModItems.THROWABLE)) {
                ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
                for (BasicTag tag : TagHelper.allTags) {
                    BasicTag eTag;
                    if (tag instanceof EffectTag) {
                        eTag = (EffectTag)tag;
                        if (!eTag.forWeapons) continue;
                        allowedTags.add(eTag);
                        continue;
                    }
                    if (!(tag instanceof WorldInteractTag)) continue;
                    eTag = (WorldInteractTag)tag;
                    if (!((WorldInteractTag)eTag).forWeapons) continue;
                    allowedTags.add(eTag);
                }
                allowedTags.add(TagHelper.UNBREAKABLE);
                allowedTags.add(TagHelper.REPLENISH);
                allowedTags.add(TagHelper.EXPLOSION);
                BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                while (TagHelper.checkForTag(stack, toAdd)) {
                    toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                }
                TagHelper.addTag(stack, toAdd.name);
                if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
                    compound.func_74757_a("Unbreakable", true);
                }
            }
            int lvlXp = compound.func_74762_e("lvlXp");
            compound.func_74768_a("Xp", 0);
            lvlXp += lvlXp / 2;
            compound.func_74768_a("lvlXp", lvlXp);
            compound.func_74782_a("AttributeModifiers", (NBTBase)(isArmor ? compound.func_74781_a("AttributeModifiers") : modifiers));
            stack.func_77982_d(compound);
            IRandomTool randItem = (IRandomTool)stack.func_77973_b();
            randItem.setName(stack);
        }
    }

    static {
        rand = new Random();
    }
}

