/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.init.ItemFields;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.util.IRandomTool;
import com.mic.randomloot.util.IReforgeable;
import com.mic.randomloot.util.handlers.ConfigHandler;
import java.text.DecimalFormat;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BowItem
extends ItemBow
implements IReforgeable,
IRandomTool {
    static int bows;
    private static int useTime;
    static int tCount;

    public BowItem(int numBows) {
        bows = numBows;
        this.func_77637_a(RandomLoot.randomlootTab);
        this.setRegistryName(new ResourceLocation("randomloot", "rl_bow"));
        this.func_77655_b("rl_bow");
        ModItems.ITEMS.add((Item)this);
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = ItemFields.getTexture(stack);
                return model;
            }
        });
        this.func_185043_a(new ResourceLocation("rl_pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float pull = 0.0f;
                if (entity == null) {
                    return pull;
                }
                ItemStack itemstack = entity.func_184607_cu();
                pull = itemstack != null && itemstack.func_77973_b() == ModItems.RL_BOW ? (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f : 0.0f;
                return pull;
            }
        });
        this.func_185043_a(new ResourceLocation("rl_pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public ItemStack chooseTexture(ItemStack stack, int num) {
        Random rand = new Random();
        if (num == 0) {
            num = rand.nextInt(bows) + 1;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Texture", num);
        stack.func_77982_d(nbt);
        return stack;
    }

    public boolean isRepairable() {
        return false;
    }

    public Item setNoRepair() {
        return super.setNoRepair();
    }

    public static float getVelo(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        return nbt.func_74760_g("velo");
    }

    public void setVelo(float digSpeed, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74776_a("velo", digSpeed);
    }

    public void addVelo(float num, ItemStack stack) {
        this.setVelo(BowItem.getVelo(stack) + num, stack);
    }

    public static ItemStack assignType(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int t1 = 0;
        int t2 = 0;
        int t3 = 0;
        int traits = 0;
        int ts = rand.nextInt(8);
        switch (ts) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                traits = 1;
                break;
            }
            case 5: 
            case 6: {
                traits = 2;
                break;
            }
            case 7: {
                traits = 3;
            }
        }
        if (traits == 1) {
            t1 = rand.nextInt(tCount) + 1;
        } else if (traits == 2) {
            t1 = rand.nextInt(tCount) + 1;
            t2 = rand.nextInt(tCount) + 1;
        } else if (traits == 3) {
            t1 = rand.nextInt(tCount) + 1;
            t2 = rand.nextInt(tCount) + 1;
            t3 = rand.nextInt(tCount) + 1;
        }
        if ((t1 == 9 || t2 == 9 || t3 == 9) && ConfigHandler.unbreakable) {
            nbt.func_74757_a("Unbreakable", true);
        }
        nbt.func_74768_a("T1", t1);
        nbt.func_74768_a("T2", t2);
        nbt.func_74768_a("T3", t3);
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        rand.setSeed(rand.nextInt(256));
        nbt.func_74768_a("Texture", rand.nextInt(bows) + 1);
        nbt.func_74768_a("HideFlags", 2);
        stack.func_77982_d(nbt);
        return stack;
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int xp = nbt.func_74762_e("Xp");
        int lvlXp = nbt.func_74762_e("lvlXp");
        int t1 = nbt.func_74762_e("T1");
        int t2 = nbt.func_74762_e("T2");
        int t3 = nbt.func_74762_e("T3");
        stack.func_77982_d(nbt);
        this.setLore(stack, entityLiving);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmo(entityplayer);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                float f;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                if ((double)(f = BowItem.getArrowVelocity(i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                    if (!worldIn.field_72995_K) {
                        int k;
                        int j;
                        ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                        EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
                        EntityTippedArrow tippedArrow = entityarrow instanceof EntityTippedArrow ? (EntityTippedArrow)entityarrow : new EntityTippedArrow(worldIn, (EntityLivingBase)entityplayer);
                        tippedArrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                        if (t1 == 1 || t2 == 1 || t3 == 1) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_76432_h, 100, 1));
                        }
                        if (t1 == 2 || t2 == 2 || t3 == 2) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_76433_i, 100, 0));
                        }
                        if (t1 == 3 || t2 == 3 || t3 == 3) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_188423_x, 100, 1));
                        }
                        if (t1 == 4 || t2 == 4 || t3 == 4) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_82731_v, 100, 1));
                        }
                        if (t1 == 5 || t2 == 5 || t3 == 5) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_76437_t, 100, 1));
                        }
                        if (t1 == 6 || t2 == 6 || t3 == 6) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_188424_y, 100, 1));
                        }
                        if (t1 == 7 || t2 == 7 || t3 == 7) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_76438_s, 100, 1));
                        }
                        if (t1 == 8 || t2 == 8 || t3 == 8) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_76421_d, 100, 1));
                        }
                        if (t1 == 10 || t2 == 10 || t3 == 10) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_76440_q, 100, 1));
                        }
                        if (t1 == 11 || t2 == 11 || t3 == 11) {
                            tippedArrow.func_184558_a(new PotionEffect(MobEffects.field_76436_u, 100, 1));
                        }
                        entityarrow = tippedArrow;
                        entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            entityarrow.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityarrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                        if (flag1 || entityplayer.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_151032_g || itemstack.func_77973_b() == Items.field_151032_g)) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)entityarrow);
                    }
                    worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            entityplayer.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                    if (nbt.func_74764_b("Xp")) {
                        nbt.func_74768_a("Xp", nbt.func_74762_e("Xp") + 1);
                    } else {
                        nbt.func_74768_a("Xp", 1);
                    }
                    if (xp >= lvlXp) {
                        ModItems.ITEM_FIELDS.upgrade(stack, entityLiving);
                    }
                    entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        return 72000 - compound.func_74762_e("velo");
    }

    @Override
    public ItemStack setName(ItemStack stack) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        stack.func_151001_c(color + compound.func_74779_i("name"));
        return stack;
    }

    @Override
    public void setLore(ItemStack stack, EntityLivingBase player) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        NBTTagList lore = new NBTTagList();
        int increase = (int)((double)BowItem.getVelo(stack) / 72000.0 * 100.0);
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Bonus Speed: " + increase + "%"));
        DecimalFormat f = new DecimalFormat("##.00");
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        int t1 = compound.func_74762_e("T1");
        int t2 = compound.func_74762_e("T2");
        int t3 = compound.func_74762_e("T3");
        if (t1 == 1 || t2 == 1 || t3 == 1) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_RED + "Smite"));
        }
        if (t1 == 2 || t2 == 2 || t3 == 2) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_RED + "Instant Damage +"));
        }
        if (t1 == 3 || t2 == 3 || t3 == 3) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.YELLOW + "Glowing"));
        }
        if (t1 == 4 || t2 == 4 || t3 == 4) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_GRAY + "Wither"));
        }
        if (t1 == 5 || t2 == 5 || t3 == 5) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_GRAY + "Weakening"));
        }
        if (t1 == 6 || t2 == 6 || t3 == 6) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GOLD + "Levitating"));
        }
        if (t1 == 7 || t2 == 7 || t3 == 7) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_RED + "Starving"));
        }
        if (t1 == 8 || t2 == 8 || t3 == 8) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_BLUE + "Slowing"));
        }
        if ((t1 == 9 || t2 == 9 || t3 == 9) && ConfigHandler.unbreakable) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Fortified"));
        }
        if (t1 == 10 || t2 == 10 || t3 == 10) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_PURPLE + "Blinding"));
        }
        if (t1 == 11 || t2 == 11 || t3 == 11) {
            lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.DARK_GREEN + "Posionous"));
        }
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Level " + compound.func_74762_e("Lvl")));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "" + compound.func_74762_e("Xp") + "/" + compound.func_74762_e("lvlXp") + " Xp"));
        NBTTagCompound display = new NBTTagCompound();
        display.func_74782_a("Lore", (NBTBase)lore);
        compound.func_74782_a("display", (NBTBase)display);
    }

    @Override
    public ItemStack reforge(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int t1 = 0;
        int t2 = 0;
        int t3 = 0;
        boolean traits = false;
        nbt.func_74757_a("Unbreakable", false);
        nbt.func_74768_a("T1", t1);
        nbt.func_74768_a("T2", t2);
        nbt.func_74768_a("T3", t3);
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        nbt.func_74768_a("HideFlags", 2);
        int rarity = nbt.func_74762_e("rarity");
        BowItem.assignType(stack);
        BowItem bow = (BowItem)stack.func_77973_b();
        int max = Items.field_151031_f.func_77626_a(new ItemStack((Item)Items.field_151031_f));
        switch (rarity) {
            case 1: {
                bow.setVelo(max / 100 * 2 + rand.nextInt(max / 100 * 20), stack);
                break;
            }
            case 2: {
                bow.setVelo(max / 100 * 30 + rand.nextInt(max / 100 * 20), stack);
                break;
            }
            case 3: {
                bow.setVelo(max / 100 * 50 + rand.nextInt(max / 100 * 40), stack);
            }
        }
        nbt.func_74776_a("velo", BowItem.getVelo(stack));
        nbt.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("bow"));
        return stack;
    }

    static {
        useTime = 72000;
        tCount = 11;
    }
}

