/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.tags.BasicTag;
import com.mic.randomloot.tags.EffectTag;
import com.mic.randomloot.tags.TagHelper;
import com.mic.randomloot.tags.WorldInteractTag;
import com.mic.randomloot.util.IRandomTool;
import com.mic.randomloot.util.IReforgeable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class RandomArmor
extends ItemArmor
implements IReforgeable,
IRandomTool {
    public RandomArmor(String name, ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77637_a(RandomLoot.randomlootTab);
        this.setRegistryName(new ResourceLocation("randomloot", name));
        this.func_77655_b(name);
        ModItems.ITEMS.add((Item)this);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        List<BasicTag> tags = TagHelper.getAllTags(itemStack);
        for (int i = 0; i < tags.size(); ++i) {
            BasicTag eTag;
            if (tags.get(i) instanceof EffectTag) {
                eTag = (EffectTag)tags.get(i);
                ((EffectTag)eTag).runEffect(itemStack, world, (EntityLivingBase)player);
                continue;
            }
            if (!(tags.get(i) instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tags.get(i);
            ((WorldInteractTag)eTag).runEffect(itemStack, world, (EntityLivingBase)player, world.func_180495_p(player.func_180425_c()), player.func_180425_c());
        }
    }

    public void xpUp(ItemStack stack, EntityLivingBase entityLiving) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int xp = nbt.func_74762_e("Xp");
        int lvlXp = nbt.func_74762_e("lvlXp");
        if (nbt.func_74764_b("Xp")) {
            nbt.func_74768_a("Xp", xp + 1);
        } else {
            nbt.func_74768_a("Xp", 1);
        }
        if (xp >= lvlXp) {
            ModItems.ITEM_FIELDS.upgrade(stack, entityLiving);
        }
        stack.func_77982_d(nbt);
        this.setLore(stack, entityLiving);
        this.setName(stack);
    }

    public static ItemStack assignType(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        nbt.func_74768_a("HideFlags", 2);
        stack.func_77982_d(nbt);
        ArrayList<EffectTag> allowedTags = new ArrayList<EffectTag>();
        for (BasicTag tag : TagHelper.allTags) {
            BasicTag eTag;
            if (tag instanceof EffectTag) {
                eTag = (EffectTag)tag;
                if (eTag.offensive) continue;
                allowedTags.add((EffectTag)eTag);
                continue;
            }
            if (!(tag instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tag;
            if (!((WorldInteractTag)eTag).forArmor) continue;
            allowedTags.add((EffectTag)eTag);
        }
        int totalTags = RandomLoot.rand.nextInt(3);
        for (int i = 0; i < totalTags; ++i) {
            TagHelper.addTag(stack, ((BasicTag)allowedTags.get((int)RandomLoot.rand.nextInt((int)allowedTags.size()))).name);
        }
        return stack;
    }

    @Override
    public void setLore(ItemStack item, EntityLivingBase player) {
        NBTTagCompound compound = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        NBTTagCompound display = compound.func_74764_b("display") ? compound.func_74775_l("display") : new NBTTagCompound();
        NBTTagList lore = new NBTTagList();
        DecimalFormat f = new DecimalFormat("#0.00");
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        List<BasicTag> tags = TagHelper.getAllTags(item);
        for (int i = 0; i < tags.size(); ++i) {
            String name = tags.get((int)i).name.replaceAll("_", " ");
            name = TagHelper.convertToTitleCaseIteratingChars(name);
            lore.func_74742_a((NBTBase)new NBTTagString(tags.get((int)i).color + name));
        }
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Level " + compound.func_74762_e("Lvl")));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "" + compound.func_74762_e("Xp") + "/" + compound.func_74762_e("lvlXp") + " Xp"));
        display.func_74782_a("Lore", (NBTBase)lore);
        compound.func_74782_a("display", (NBTBase)display);
    }

    @Override
    public ItemStack setName(ItemStack stack) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        stack.func_151001_c(color + compound.func_74779_i("name"));
        return stack;
    }

    @Override
    public ItemStack reforge(ItemStack stack) {
        return null;
    }

    @Override
    public ItemStack chooseTexture(ItemStack stack, int num) {
        return null;
    }
}

