/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.init.ItemFields;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.tags.BasicTag;
import com.mic.randomloot.tags.EffectTag;
import com.mic.randomloot.tags.TagHelper;
import com.mic.randomloot.tags.WorldInteractTag;
import com.mic.randomloot.util.IRandomTool;
import com.mic.randomloot.util.IReforgeable;
import com.mic.randomloot.util.TagUpdater;
import com.mic.randomloot.util.WeightedChooser;
import com.mic.randomloot.util.handlers.ConfigHandler;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SwordItem
extends ItemSword
implements IReforgeable,
IRandomTool {
    private static int swords;
    public static int tCount;

    public SwordItem(Item.ToolMaterial material, int swords) {
        super(material);
        SwordItem.swords = swords;
        this.func_77637_a(RandomLoot.randomlootTab);
        this.setRegistryName(new ResourceLocation("randomloot", "sword"));
        this.func_77655_b("sword");
        ModItems.ITEMS.add((Item)this);
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = ItemFields.getTexture(stack);
                return model;
            }
        });
    }

    public Item setNoRepair() {
        return super.setNoRepair();
    }

    public boolean isRepairable() {
        return false;
    }

    public int getTexture(ItemStack stack) {
        int value = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Texture")) {
            value = stack.func_77978_p().func_74762_e("Texture");
        }
        return value;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        NBTTagCompound nbt = (stack = TagUpdater.update(stack, (EntityPlayer)attacker)).func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int xp = nbt.func_74762_e("Xp");
        int lvlXp = nbt.func_74762_e("lvlXp");
        if (nbt.func_74764_b("Xp")) {
            nbt.func_74768_a("Xp", nbt.func_74762_e("Xp") + 1);
        } else {
            nbt.func_74768_a("Xp", 1);
        }
        if (xp >= lvlXp) {
            ModItems.ITEM_FIELDS.upgrade(stack, attacker);
        }
        stack.func_77982_d(nbt);
        List<BasicTag> tags = TagHelper.getAllTags(stack);
        for (int i = 0; i < tags.size(); ++i) {
            if (!(tags.get(i) instanceof EffectTag)) continue;
            EffectTag eTag = (EffectTag)tags.get(i);
            if (eTag.offensive) {
                eTag.runEffect(stack, attacker.field_70170_p, target);
                continue;
            }
            eTag.runEffect(stack, attacker.field_70170_p, attacker);
        }
        this.setLore(stack, attacker);
        this.setName(stack);
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public void setLore(ItemStack stack, EntityLivingBase player) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        NBTTagList lore = new NBTTagList();
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Attack Damage: " + compound.func_74762_e("damage")));
        DecimalFormat f = new DecimalFormat("##.00");
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Attack Speed: " + f.format(ModItems.ITEM_FIELDS.displaySpeed(compound.func_74769_h("speed"), player))));
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        List<BasicTag> tags = TagHelper.getAllTags(stack);
        for (int i = 0; i < tags.size(); ++i) {
            String name = tags.get((int)i).name.replaceAll("_", " ");
            name = TagHelper.convertToTitleCaseIteratingChars(name);
            lore.func_74742_a((NBTBase)new NBTTagString(tags.get((int)i).color + name));
        }
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Level " + compound.func_74762_e("Lvl")));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "" + compound.func_74762_e("Xp") + "/" + compound.func_74762_e("lvlXp") + " Xp"));
        NBTTagCompound display = new NBTTagCompound();
        display.func_74782_a("Lore", (NBTBase)lore);
        compound.func_74782_a("display", (NBTBase)display);
        if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
            compound.func_74757_a("Unbreakable", true);
        } else {
            compound.func_74757_a("Unbreakable", false);
        }
    }

    @Override
    public ItemStack setName(ItemStack stack) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        stack.func_151001_c(color + compound.func_74779_i("name"));
        return stack;
    }

    public static ItemStack assignType(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        rand.setSeed(rand.nextInt(256));
        nbt.func_74768_a("HideFlags", 2);
        stack.func_77982_d(nbt);
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            BasicTag eTag;
            if (tag instanceof EffectTag) {
                eTag = (EffectTag)tag;
                if (!eTag.forWeapons) continue;
                allowedTags.add(eTag);
                continue;
            }
            if (!(tag instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tag;
            if (!((WorldInteractTag)eTag).forWeapons) continue;
            allowedTags.add(eTag);
        }
        allowedTags.add(TagHelper.UNBREAKABLE);
        allowedTags.add(TagHelper.REPLENISH);
        WeightedChooser<Integer> wc = new WeightedChooser<Integer>();
        wc.addChoice(1, 6);
        wc.addChoice(2, 3);
        wc.addChoice(3, 1);
        int totalTags = (Integer)wc.getRandomObject();
        for (int i = 0; i < totalTags; ++i) {
            BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
            while (TagHelper.checkForTag(stack, toAdd)) {
                toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                rand.setSeed(rand.nextLong() / 2L * (long)totalTags * (long)allowedTags.size() * (long)i);
            }
            TagHelper.addTag(stack, toAdd.name);
        }
        if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
            nbt.func_74757_a("Unbreakable", true);
        }
        return stack;
    }

    @Override
    public ItemStack chooseTexture(ItemStack stack, int num) {
        Random rand = new Random();
        if (num == 0) {
            num = rand.nextInt(swords) + 1;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Texture", num);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    public ItemStack reforge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        boolean t1 = false;
        boolean t2 = false;
        boolean t3 = false;
        boolean traits = false;
        nbt.func_74757_a("Unbreakable", false);
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        nbt.func_74768_a("HideFlags", 2);
        int rarity = nbt.func_74762_e("rarity");
        NBTTagCompound damage = new NBTTagCompound();
        damage.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackDamage"));
        damage.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackDamage"));
        int dmg = ModItems.ITEM_FIELDS.calcDamage(rarity);
        damage.func_74782_a("Amount", (NBTBase)new NBTTagInt(dmg));
        damage.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
        damage.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(3));
        damage.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(4));
        damage.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
        NBTTagCompound speed = new NBTTagCompound();
        speed.func_74782_a("AttributeName", (NBTBase)new NBTTagString("generic.attackSpeed"));
        speed.func_74782_a("Name", (NBTBase)new NBTTagString("generic.attackSpeed"));
        double spd = ModItems.ITEM_FIELDS.calcSpeed(rarity) * -1.0;
        speed.func_74782_a("Amount", (NBTBase)new NBTTagDouble(spd));
        speed.func_74782_a("Operation", (NBTBase)new NBTTagInt(0));
        speed.func_74782_a("UUIDLeast", (NBTBase)new NBTTagInt(1));
        speed.func_74782_a("UUIDMost", (NBTBase)new NBTTagInt(2));
        speed.func_74782_a("Slot", (NBTBase)new NBTTagString("mainhand"));
        nbt.func_74768_a("damage", dmg);
        nbt.func_74780_a("speed", spd);
        NBTTagList modifiers = new NBTTagList();
        modifiers.func_74742_a((NBTBase)damage);
        modifiers.func_74742_a((NBTBase)speed);
        nbt.func_74782_a("AttributeModifiers", (NBTBase)modifiers);
        nbt.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("sword"));
        stack.func_77982_d(nbt);
        SwordItem.assignType(stack);
        this.setName(stack);
        return stack;
    }

    static {
        tCount = 11;
    }
}

