/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.items;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.entity.projectile.ThrowableWeaponEntity;
import com.mic.randomloot.init.ItemFields;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.items.ItemBase;
import com.mic.randomloot.tags.BasicTag;
import com.mic.randomloot.tags.EffectTag;
import com.mic.randomloot.tags.TagHelper;
import com.mic.randomloot.tags.WorldInteractTag;
import com.mic.randomloot.util.IRandomTool;
import com.mic.randomloot.util.IReforgeable;
import com.mic.randomloot.util.WeightedChooser;
import com.mic.randomloot.util.handlers.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThrowableWeapon
extends ItemBase
implements IReforgeable,
IRandomTool {
    static int numThrowables = 1;
    int field_77699_b = 64;

    public ThrowableWeapon(String name, int throwables) {
        super(name);
        numThrowables = throwables;
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = ItemFields.getTexture(stack);
                return model;
            }
        });
    }

    public void setMaxDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("maxDamage", damage);
        stack.func_77982_d(nbt);
    }

    public int getNewMaxDamage(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        return nbt.func_74762_e("maxDamage");
    }

    public int func_77612_l() {
        return this.field_77699_b;
    }

    public boolean func_77645_m() {
        return true;
    }

    @Override
    public ItemStack chooseTexture(ItemStack stack, int num) {
        Random rand = new Random();
        if (num == 0) {
            num = rand.nextInt(numThrowables) + 1;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Texture", num);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    public void setLore(ItemStack stack, EntityLivingBase player) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        NBTTagList lore = new NBTTagList();
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Attack Damage: " + compound.func_74762_e("damageToDeal")));
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        List<BasicTag> tags = TagHelper.getAllTags(stack);
        for (int i = 0; i < tags.size(); ++i) {
            String name = tags.get((int)i).name.replaceAll("_", " ");
            name = TagHelper.convertToTitleCaseIteratingChars(name);
            lore.func_74742_a((NBTBase)new NBTTagString(tags.get((int)i).color + name));
        }
        lore.func_74742_a((NBTBase)new NBTTagString(""));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "Level " + compound.func_74762_e("Lvl")));
        lore.func_74742_a((NBTBase)new NBTTagString(TextFormatting.GRAY + "" + compound.func_74762_e("Xp") + "/" + compound.func_74762_e("lvlXp") + " Xp"));
        NBTTagCompound display = new NBTTagCompound();
        display.func_74782_a("Lore", (NBTBase)lore);
        compound.func_74782_a("display", (NBTBase)display);
        if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
            compound.func_74757_a("Unbreakable", true);
        } else {
            compound.func_74757_a("Unbreakable", false);
        }
    }

    @Override
    public ItemStack setName(ItemStack stack) {
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TextFormatting color = null;
        switch (compound.func_74762_e("rarity")) {
            case 1: {
                color = TextFormatting.WHITE;
                break;
            }
            case 2: {
                color = TextFormatting.GOLD;
                break;
            }
            case 3: {
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        stack.func_151001_c(color + compound.func_74779_i("name"));
        return stack;
    }

    public static ItemStack assignType(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("Lvl", 1);
        nbt.func_74768_a("lvlXp", 256);
        nbt.func_74768_a("Xp", 0);
        rand.setSeed(rand.nextInt(256));
        nbt.func_74768_a("HideFlags", 2);
        stack.func_77982_d(nbt);
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            BasicTag eTag;
            if (tag instanceof EffectTag) {
                eTag = (EffectTag)tag;
                if (!eTag.forWeapons) continue;
                allowedTags.add(eTag);
                continue;
            }
            if (!(tag instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tag;
            if (!((WorldInteractTag)eTag).forWeapons) continue;
            allowedTags.add(eTag);
        }
        allowedTags.add(TagHelper.UNBREAKABLE);
        allowedTags.add(TagHelper.REPLENISH);
        allowedTags.add(TagHelper.EXPLOSION);
        WeightedChooser<Integer> wc = new WeightedChooser<Integer>();
        wc.addChoice(1, 6);
        wc.addChoice(2, 3);
        wc.addChoice(3, 1);
        int totalTags = (Integer)wc.getRandomObject();
        for (int i = 0; i < totalTags; ++i) {
            BasicTag toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
            while (TagHelper.checkForTag(stack, toAdd)) {
                toAdd = (BasicTag)allowedTags.get(RandomLoot.rand.nextInt(allowedTags.size()));
                rand.setSeed(rand.nextLong() / 2L * (long)totalTags * (long)allowedTags.size() * (long)i);
            }
            TagHelper.addTag(stack, toAdd.name);
        }
        if (TagHelper.checkForTag(stack, TagHelper.UNBREAKABLE) && ConfigHandler.unbreakable) {
            nbt.func_74757_a("Unbreakable", true);
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        this.field_77699_b = this.getNewMaxDamage(itemstack);
        boolean flag = true;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)itemstack) : new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public static float getVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            int i = this.func_77626_a(stack) - timeLeft;
            float f = ThrowableWeapon.getVelocity(i);
            if ((double)f >= 0.1) {
                ItemStack itemstack = entityplayer.func_184614_ca();
                NBTTagCompound nbt = itemstack.func_77942_o() ? itemstack.func_77978_p() : new NBTTagCompound();
                int xp = nbt.func_74762_e("Xp");
                int lvlXp = nbt.func_74762_e("lvlXp");
                if (nbt.func_74764_b("Xp")) {
                    nbt.func_74768_a("Xp", nbt.func_74762_e("Xp") + 1);
                } else {
                    nbt.func_74768_a("Xp", 1);
                }
                if (xp >= lvlXp) {
                    ModItems.ITEM_FIELDS.upgrade(stack, entityLiving);
                }
                stack.func_77982_d(nbt);
                float damageToDeal = nbt.func_74760_g("damageToDeal");
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
                }
                worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187595_bc, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!worldIn.field_72995_K) {
                    ThrowableWeaponEntity ent = new ThrowableWeaponEntity(worldIn, (EntityLivingBase)entityplayer);
                    ent.setDamageToDeal(damageToDeal);
                    ent.setThisAsItem(itemstack);
                    ent.func_184538_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 1.5f, 1.0f);
                    worldIn.func_72838_d((Entity)ent);
                }
                entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
        this.setLore(stack, entityLiving);
        this.setName(stack);
    }

    @Override
    public ItemStack reforge(ItemStack stack) {
        Random rand = new Random();
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        double dam = 4.0;
        int rarity = compound.func_74762_e("rarity");
        switch (rarity) {
            case 1: {
                dam = rand.nextDouble() * (double)(ConfigHandler.tierOneDamageMax - ConfigHandler.tierOneDamageMin) + (double)ConfigHandler.tierOneDamageMax;
                break;
            }
            case 2: {
                dam = rand.nextDouble() * (double)(ConfigHandler.tierTwoDamageMax - ConfigHandler.tierTwoDamageMin) + (double)ConfigHandler.tierTwoDamageMin;
                break;
            }
            case 3: {
                dam = rand.nextDouble() * (double)(ConfigHandler.tierThreeDamageMax - ConfigHandler.tierThreeDamageMin) + (double)ConfigHandler.tierThreeDamageMin;
            }
        }
        compound.func_74768_a("maxDamage", rarity * 128 / 2);
        compound.func_74776_a("damageToDeal", (float)(dam * 0.75));
        compound.func_74778_a("name", ModItems.ITEM_FIELDS.nameItem("throwable"));
        stack.func_77982_d(compound);
        return stack;
    }
}

