/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.util.handlers;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.tags.BasicTag;
import com.mic.randomloot.tags.TagHelper;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static Configuration config;
    public static int mobChance;
    public static int playerChance;
    public static int bossChance;
    public static int animalChance;
    public static int dropType;
    public static boolean swords;
    public static boolean axes;
    public static boolean pickaxes;
    public static boolean shovels;
    public static boolean bows;
    public static boolean armor;
    public static boolean paxels;
    public static boolean throwables;
    public static int tierOneDamageMin;
    public static int tierOneDamageMax;
    public static int tierTwoDamageMin;
    public static int tierTwoDamageMax;
    public static int tierThreeDamageMin;
    public static int tierThreeDamageMax;
    public static boolean unbreakable;
    public static boolean dropFromMobs;
    public static boolean spawnInChests;
    public static int chestSpawnRate;
    public static int reforgeItemCount;
    public static int tierOneMaxArmor;
    public static int tierTwoMaxArmor;
    public static int tierThreeMaxArmor;
    public static int tierOneMinArmor;
    public static int tierTwoMinArmor;
    public static int tierThreeMinArmor;
    public static int chanceToDrop;
    public static String reforgeItemName;
    public static int shovelWeight;
    public static int swordWeight;
    public static int pickWeight;
    public static int axeWeight;
    public static int bowWeight;
    public static int armorWeight;
    public static int throwWeight;
    public static int repairStationCooldown;
    public static boolean doWelcomeMessage;
    public static int paxelWeight;
    public static int throwingID;
    public static ArrayList traitsEnabled;

    public static void init(File file) {
        config = new Configuration(file);
        String category = "Drop Chances";
        mobChance = config.getInt("Monster Chance", category, 50, 0, 1000, "0 for never and 1000 for every time, default is 50");
        animalChance = config.getInt("Animal Chance", category, 50, 0, 1000, "0 for never and 1000 for every time, default is 50");
        bossChance = config.getInt("Boss Chance", category, 50, 0, 1000, "0 for never and 1000 for every time, default is 50");
        playerChance = config.getInt("Player Chance", category, 50, 0, 1000, "0 for never and 1000 for every time, default is 50");
        chanceToDrop = config.getInt("Chance For Loot To Drop From Case", category, 100, 0, 100, "0 for never and 100 for every time, default is 100");
        category = "Item Values";
        dropFromMobs = config.getBoolean("Drop from Mobs", category, true, "Enables or disables cases dropping from mobs");
        spawnInChests = config.getBoolean("Spawn in chests", category, true, "Enables or disables cases spawining in chests");
        chestSpawnRate = config.getInt("Chest Spawn Rate", category, 50, 0, 100, "If chest spawning is enabled, change the chance to spawn");
        dropType = config.getInt("Drop Type", category, 0, 0, 1, "0 - any case drops any rarity (different chances), 1 - lock rarities to cases");
        swords = config.getBoolean("Swords Enabled", category, true, "Enables or disables the item");
        axes = config.getBoolean("Axes Enabled", category, true, "Enables or disables the item");
        bows = config.getBoolean("Bows Enabled", category, true, "Enables or disables the item");
        pickaxes = config.getBoolean("Pickaxes Enabled", category, true, "Enables or disables the item");
        paxels = config.getBoolean("Paxels Enabled", category, true, "Enables or disables the item");
        shovels = config.getBoolean("Shovels Enabled", category, true, "Enables or disables the item");
        armor = config.getBoolean("Armor Enabled", category, true, "Enables or disables armor");
        throwables = config.getBoolean("Throwables Enabled", category, true, "Enables or disables throwables");
        category = "Damages";
        tierOneDamageMin = config.getInt("Tier One Minimum Damage", category, 7, 0, 99, "Sets the minimum damage of the weapons.");
        tierOneDamageMax = config.getInt("Tier One Maximum Damage", category, 11, 0, 100, "Sets the maximum damage of the weapons.");
        tierTwoDamageMin = config.getInt("Tier Two Minimum Damage", category, 10, 0, 99, "Sets the minimum damage of the weapons.");
        tierTwoDamageMax = config.getInt("Tier Two Maximum Damage", category, 16, 0, 100, "Sets the maximum damage of the weapons.");
        tierThreeDamageMin = config.getInt("Tier Three Minimum Damage", category, 15, 0, 99, "Sets the minimum damage of the weapons.");
        tierThreeDamageMax = config.getInt("Tier Three Maximum Damage", category, 22, 0, 100, "Sets the maximum damage of the weapons.");
        category = "Armors";
        tierOneMaxArmor = config.getInt("Tier One Maximum Armor", category, 4, 1, 99, "Sets the maximum reductions of the armor.");
        tierTwoMaxArmor = config.getInt("Tier Two Maximum Armor", category, 7, 1, 99, "Sets the maximum reductions of the armor.");
        tierThreeMaxArmor = config.getInt("Tier Three Maximum Armor", category, 12, 1, 99, "Sets the maximum reductions of the armor.");
        tierOneMinArmor = config.getInt("Tier One minimum Armor", category, 2, 1, 99, "Sets the minimum reductions of the armor.");
        tierTwoMinArmor = config.getInt("Tier Two minimum Armor", category, 4, 1, 99, "Sets the minimum reductions of the armor.");
        tierThreeMinArmor = config.getInt("Tier Three minimum Armor", category, 7, 1, 99, "Sets the minimum reductions of the armor.");
        category = "Basic Variables";
        unbreakable = config.getBoolean("Unbreakable Tools Allowed", category, true, "False turns off the 'unbreakable' trait.");
        reforgeItemCount = config.getInt("Reforge Item Count", category, 12, 0, 64, "How many of the item you need in the offhand to reforge (0 to disable)");
        reforgeItemName = config.getString("Reforge Item", category, "minecraft:blaze_powder", "item to use in offhand to reforge");
        repairStationCooldown = config.getInt("Repair Station cooldown", category, 20, 1, 1000, "How many ticks in between a durability repair.");
        category = "Weighting";
        shovelWeight = config.getInt("Shovel Weighting", category, 10, 1, 100, "How often you recieve shovels from the cases.");
        swordWeight = config.getInt("Sword Weighting", category, 40, 1, 100, "How often you recieve swords from the cases.");
        pickWeight = config.getInt("Pickaxe Weighting", category, 25, 1, 100, "How often you recieve pickaxes from the cases.");
        paxelWeight = config.getInt("Paxel Weighting", category, 6, 1, 100, "How often you recieve paxels from the cases.");
        axeWeight = config.getInt("Axe Weighting", category, 18, 1, 100, "How often you recieve axes from the cases.");
        bowWeight = config.getInt("Bow Weighting", category, 10, 1, 100, "How often you recieve bows from the cases.");
        armorWeight = config.getInt("Armor Weighting", category, 6, 1, 100, "How often you recieve armor from the cases.");
        throwWeight = config.getInt("Throwable Weighting", category, 8, 1, 100, "How often you recieve throwables from the cases.");
        category = "Cosmetic";
        doWelcomeMessage = config.getBoolean("Do Welcome Message", category, true, "Whether or not you want to see the welcome message at startup.");
        category = "Advanced";
        throwingID = config.getInt("Throwable Entity ID", category, 69, 1, 1000, "DO NOT CHANGE UNLESS YOU KNOW WHAT YOURE DOING!");
        category = "Traits Allowed";
        for (BasicTag tag : TagHelper.allTags) {
            traitsEnabled.add(config.getBoolean(TagHelper.convertToTitleCaseIteratingChars(tag.name) + " enabled?", category, true, "Whether or not this trait is enabled."));
        }
        config.save();
    }

    public static void registerConfig(FMLPreInitializationEvent event) {
        RandomLoot.config = new File(event.getModConfigurationDirectory() + "/" + "randomloot");
        RandomLoot.config.mkdirs();
        ConfigHandler.init(new File(RandomLoot.config.getPath(), "randomloot.cfg"));
    }

    static {
        mobChance = 50;
        playerChance = 50;
        bossChance = 50;
        animalChance = 50;
        dropType = 0;
        swords = true;
        axes = true;
        pickaxes = true;
        shovels = true;
        bows = true;
        armor = true;
        paxels = true;
        throwables = true;
        tierOneDamageMin = 7;
        tierOneDamageMax = 11;
        tierTwoDamageMin = 10;
        tierTwoDamageMax = 16;
        tierThreeDamageMin = 15;
        tierThreeDamageMax = 22;
        unbreakable = true;
        dropFromMobs = true;
        spawnInChests = true;
        chestSpawnRate = 100;
        reforgeItemCount = 12;
        tierOneMaxArmor = 2;
        tierTwoMaxArmor = 4;
        tierThreeMaxArmor = 6;
        tierOneMinArmor = 1;
        tierTwoMinArmor = 2;
        tierThreeMinArmor = 4;
        chanceToDrop = 100;
        reforgeItemName = "blaze_powder";
        traitsEnabled = new ArrayList();
    }
}

