/*
 * Decompiled with CFR 0.152.
 */
package com.mic.randomloot.util.handlers;

import com.mic.randomloot.RandomLoot;
import com.mic.randomloot.init.ModBlocks;
import com.mic.randomloot.init.ModEntities;
import com.mic.randomloot.init.ModItems;
import com.mic.randomloot.items.CaseItem;
import com.mic.randomloot.items.RandomArmor;
import com.mic.randomloot.tags.TagHelper;
import com.mic.randomloot.util.IHasModel;
import com.mic.randomloot.util.handlers.ConfigHandler;
import com.mic.randomloot.util.handlers.GuiHandler;
import com.mic.randomloot.util.handlers.NetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="randomloot")
public class RegistryHandler {
    static World world;
    private static Random random;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
    }

    public static ArrayList<CaseItem> getList() {
        ArrayList<CaseItem> list = new ArrayList<CaseItem>();
        list.add(ModItems.BASIC_CASE);
        list.add(ModItems.GOLDEN_CASE);
        list.add(ModItems.TITAN_CASE);
        Collections.shuffle(list, random);
        return list;
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        if (event.getEntity().func_130014_f_().func_82736_K().func_82766_b("doMobLoot") && ConfigHandler.dropFromMobs) {
            if (!(event.getSource() instanceof EntityDamageSource && ((EntityDamageSource)event.getSource()).func_76346_g() instanceof EntityPlayer && ((EntityDamageSource)event.getSource()).func_76346_g() instanceof EntityPlayer)) {
                return;
            }
            for (CaseItem i : RegistryHandler.getList()) {
                int weight;
                int chance = random.nextInt(1000);
                if (chance > (weight = !event.getEntityLiving().func_184222_aU() ? i.getBossDropWeight() : (event.getEntityLiving() instanceof EntityMob || event.getEntityLiving() instanceof IMob ? i.getMonsterDropWeight() : (event.getEntityLiving() instanceof EntityPlayer ? i.getPlayerDropWeight() : (event.getEntityLiving() instanceof EntityAnimal || event.getEntityLiving() instanceof IAnimals ? i.getPassiveDropWeight() : i.getMonsterDropWeight())))) || weight <= 0) continue;
                event.getEntityLiving().func_70099_a(i.getItem(), (float)(random.nextInt(2) + 1));
            }
        }
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (player != null && !player.field_70170_p.field_72995_K) {
            ArrayList<Item> tools = new ArrayList<Item>();
            tools.add(ModItems.RL_AXE);
            tools.add(ModItems.RL_PICKAXE);
            tools.add(ModItems.RL_SHOVEL);
            tools.add(ModItems.RL_PAXEL);
            ItemStack item = player.func_184614_ca();
            if (tools.contains(item.func_77973_b())) {
                ArrayList<ItemStack> smelted = new ArrayList<ItemStack>();
                for (ItemStack drop : event.getDrops()) {
                    ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                    if (smeltResult != null && smeltResult != ItemStack.field_190927_a) {
                        smelted.add(smeltResult.func_77946_l());
                        continue;
                    }
                    smelted.add(drop.func_77946_l());
                }
                if (TagHelper.checkForTag(item, TagHelper.AUTOSMELT)) {
                    event.getDrops().clear();
                    event.getDrops().addAll(smelted);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEnchantmentRegister(RegistryEvent.Register<Enchantment> event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool main = event.getTable().getPool("main");
        if (main == null) {
            return;
        }
        if (event.getName().toString().contains("chest")) {
            double spawn = ConfigHandler.chestSpawnRate / 100;
            this.addEntry(main, ModItems.BASIC_CASE, (int)(16.0 * spawn));
            this.addEntry(main, ModItems.GOLDEN_CASE, (int)(8.0 * spawn));
            this.addEntry(main, ModItems.TITAN_CASE, (int)(4.0 * spawn));
        }
    }

    private void addEntry(LootPool lootPool, Item item, int weight) {
        lootPool.addEntry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[0], new LootCondition[0], "randomloot:" + item.func_77658_a().substring(5)));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            RandomLoot.proxy.registerItemRenderer(item, 0, "inventory");
        }
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries(FMLPreInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RandomLoot.instance, (IGuiHandler)new GuiHandler());
        ConfigHandler.registerConfig(event);
        ModEntities.registerEntities();
    }

    public static void initRegistries() {
        NetworkHandler net = new NetworkHandler();
    }

    @SubscribeEvent
    public void playerHurt(LivingHurtEvent event) {
        for (ItemStack armorPiece : event.getEntity().func_184193_aE()) {
            if (!(armorPiece.func_77973_b() instanceof RandomArmor)) continue;
            RandomArmor piece = (RandomArmor)armorPiece.func_77973_b();
            piece.xpUp(armorPiece, event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void playerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        for (ItemStack armor : player.func_184193_aE()) {
            if (!TagHelper.checkForTag(armor, TagHelper.CLOUD_WALKER) || player.field_70122_E || !(player.field_70181_x < 0.0)) continue;
            player.func_70024_g(0.0, 0.0 - player.field_70181_x * 0.4, 0.0);
        }
    }

    static {
        random = new Random();
    }
}

