/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.config.RTConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class BoneMealHandler {
    @SubscribeEvent
    public static void onBoneMeal(BonemealEvent event) {
        int age;
        if (RandomTweaks.EXPANDED_BONEMEAL_LOADED) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = event.getBlock();
        Block block = state.func_177230_c();
        BlockPos pos = event.getPos();
        if (block == Blocks.field_150434_aF) {
            if (RTConfig.BoneMeal.cacti != 0) {
                BoneMealHandler.grow(world, block, pos, BlockCactus.field_176587_a, RTConfig.BoneMeal.cacti, event);
            }
        } else if (block == Blocks.field_150436_aH) {
            if (RTConfig.BoneMeal.sugarCanes != 0) {
                BoneMealHandler.grow(world, block, pos, BlockReed.field_176355_a, RTConfig.BoneMeal.sugarCanes, event);
            }
        } else if (block == Blocks.field_150388_bm && RTConfig.BoneMeal.netherWart && (age = ((Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) < 3) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(age + 1)), 2);
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static void grow(World world, Block block, BlockPos pos, PropertyInteger ageProperty, int stages, BonemealEvent event) {
        BlockPos tempPos;
        int i = 0;
        while (world.func_180495_p(tempPos = pos.func_177977_b()).func_177230_c() == block) {
            pos = tempPos;
            if (++i <= 1) continue;
            return;
        }
        i = 0;
        while (world.func_180495_p(tempPos = pos.func_177984_a()).func_177230_c() == block) {
            pos = tempPos;
            if (++i <= 1) continue;
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        int originalStage = (Integer)state.func_177229_b((IProperty)ageProperty);
        int newStage = originalStage + stages - 1;
        if (newStage > 15) {
            newStage = 15;
        }
        if (originalStage == newStage) {
            return;
        }
        state = state.func_177226_a((IProperty)ageProperty, (Comparable)Integer.valueOf(newStage));
        world.func_180501_a(pos, state, 4);
        block.func_180650_b(world, pos, state, world.field_73012_v);
        event.setResult(Event.Result.ALLOW);
    }
}

