/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.config.RTConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.FoodStats;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class RespawnHandler {
    @SubscribeEvent
    public static void onRespawn(PlayerEvent.Clone event) {
        boolean keepInventory;
        if (!event.isWasDeath()) {
            return;
        }
        EntityPlayer original = event.getOriginal();
        if (RespawnHandler.resetHungerOnRespawn(original, keepInventory = original.func_130014_f_().func_82736_K().func_82766_b("keepInventory"))) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        FoodStats stats = event.getOriginal().func_71024_bL();
        int oldFoodLevel = stats.func_75116_a();
        float oldSaturationLevel = stats.func_75115_e();
        int newFoodLevel = oldFoodLevel;
        DeathPunishmentMode mode = RTConfig.Misc.deathPunishmentMode;
        if (!player.field_71075_bZ.field_75098_d && (keepInventory && mode == DeathPunishmentMode.ENABLED_IF_KEEP_INVENTORY || mode == DeathPunishmentMode.ENABLED)) {
            newFoodLevel -= 3;
            player.field_71106_cc = 0.0f;
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
        }
        int minimum = RTConfig.Hunger.minimumRespawnHungerLevel;
        FoodStats newStats = player.func_71024_bL();
        newStats.field_75127_a = Math.max(newFoodLevel, minimum);
        newStats.field_75125_b = oldSaturationLevel;
    }

    public static boolean resetHungerOnRespawn(EntityPlayer player, boolean keepInventory) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        DeathPunishmentMode mode = RTConfig.Misc.deathPunishmentMode;
        if (keepInventory && mode == DeathPunishmentMode.ENABLED_IF_KEEP_INVENTORY || mode == DeathPunishmentMode.ENABLED) {
            return false;
        }
        switch (RTConfig.Hunger.respawnResetBehavior) {
            case RESET: {
                return true;
            }
            case DONT_RESET: {
                return false;
            }
        }
        return keepInventory;
    }

    public static enum DeathPunishmentMode {
        ENABLED("enabled"),
        ENABLED_IF_KEEP_INVENTORY("enabledIfKeepInventory"),
        DISABLED("disabled");

        private final String translationKey;

        private DeathPunishmentMode(String translationKey) {
            this.translationKey = "randomtweaks.config.misc.deathPunishmentMode." + translationKey;
        }

        public String toString() {
            return this.translationKey;
        }
    }

    public static enum HungerResetBehavior {
        RESET("reset"),
        DONT_RESET("dontReset"),
        RESET_UNLESS_KEEP_INVENTORY("resetUnlessKeepInventory");

        private final String translationKey;

        private HungerResetBehavior(String translationKey) {
            this.translationKey = "randomtweaks.config.hunger.respawnResetBehavior." + translationKey;
        }

        public String toString() {
            return this.translationKey;
        }
    }
}

