/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.util;

public enum Alignment {
    TOP_LEFT("topLeft", 2, 2),
    TOP_CENTER("topCenter", 0, 2),
    TOP_RIGHT("topRight", -2, 2),
    MIDDLE_LEFT("middleLeft", 2, 0),
    MIDDLE_CENTER("middleCenter", 0, 0),
    MIDDLE_RIGHT("middleRight", -2, 0),
    BOTTOM_LEFT("bottomLeft", 2, -2),
    BOTTOM_CENTER("bottomCenter", 0, -45),
    BOTTOM_RIGHT("bottomRight", -2, -2);

    private static final int MASK_X = 12;
    private static final int MASK_Y = 3;
    private static final int TOP = 1;
    private static final int MIDDLE = 3;
    private static final int BOTTOM = 2;
    private static final int LEFT = 4;
    private static final int CENTER = 12;
    private static final int RIGHT = 8;
    private final int defaultX;
    private final int defaultY;
    private final String translationKey;
    private int alignment;

    private Alignment(String translationKey, int x, int y) {
        this.translationKey = "randomtweaks.config.client.timeOfDay.alignment." + translationKey;
        this.defaultX = x;
        this.defaultY = y;
    }

    public String toString() {
        return this.translationKey;
    }

    public int getX(int x, int screenWidth, int textWidth) {
        x += this.defaultX;
        switch (this.alignment & 0xC) {
            case 4: {
                return x;
            }
            case 12: {
                return x + (screenWidth - textWidth) / 2;
            }
            case 8: {
                return x + screenWidth - textWidth;
            }
        }
        return 0;
    }

    public int getY(int y, int screenHeight, int textHeight) {
        y += this.defaultY;
        switch (this.alignment & 3) {
            case 1: {
                return y;
            }
            case 3: {
                return y + (screenHeight - textHeight) / 2;
            }
            case 2: {
                return y + screenHeight - textHeight;
            }
        }
        return 0;
    }

    public int getDefaultX() {
        return this.defaultX;
    }

    public int getDefaultY() {
        return this.defaultY;
    }

    static {
        Alignment.TOP_LEFT.alignment = 5;
        Alignment.TOP_CENTER.alignment = 13;
        Alignment.TOP_RIGHT.alignment = 9;
        Alignment.MIDDLE_LEFT.alignment = 7;
        Alignment.MIDDLE_CENTER.alignment = 15;
        Alignment.MIDDLE_RIGHT.alignment = 11;
        Alignment.BOTTOM_LEFT.alignment = 6;
        Alignment.BOTTOM_CENTER.alignment = 14;
        Alignment.BOTTOM_RIGHT.alignment = 10;
    }
}

