/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.config.RTConfig;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class TrampleHandler {
    @SubscribeEvent
    public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (RTConfig.Misc.farmlandTrampleBehavior == Behavior.VANILLA) {
            return;
        }
        if (RTConfig.Misc.farmlandTrampleBehavior == Behavior.DONT_TRAMPLE) {
            event.setCanceled(true);
            return;
        }
        if (RTConfig.Misc.farmlandTrampleBehavior == Behavior.DONT_TRAMPLE_IF_WET || RTConfig.Misc.farmlandTrampleBehavior == Behavior.DONT_TRAMPLE_IF_FEATHER_FALLING_OR_WET) {
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state.func_177230_c() instanceof BlockFarmland && (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) == 7) {
                event.setCanceled(true);
                return;
            }
            if (RTConfig.Misc.farmlandTrampleBehavior == Behavior.DONT_TRAMPLE_IF_WET) {
                return;
            }
        }
        Iterable armor = event.getEntity().func_184193_aE();
        for (ItemStack stack : armor) {
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemArmor) || ((ItemArmor)item).field_77881_a != EntityEquipmentSlot.FEET || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180309_e, (ItemStack)stack) <= 0) continue;
            event.setCanceled(true);
            break;
        }
    }

    public static enum Behavior {
        VANILLA("vanilla"),
        DONT_TRAMPLE_IF_FEATHER_FALLING("dontTrampleIfFeatherFalling"),
        DONT_TRAMPLE_IF_FEATHER_FALLING_OR_WET("dontTrampleIfFeatherFallingOrWet"),
        DONT_TRAMPLE_IF_WET("dontTrampleIfWet"),
        DONT_TRAMPLE("dontTrample");

        private final String translationKey;

        private Behavior(String translationKey) {
            this.translationKey = "randomtweaks.config.misc.farmlandTrampleBehavior." + translationKey;
        }

        public String toString() {
            return this.translationKey;
        }
    }
}

