/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config;

import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config.Config;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config.ConfigData;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config.ConfigException;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config.TRLCategory;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.config.TRLProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;
import org.apache.commons.lang3.StringUtils;

public final class ConfigManager {
    private static final ConfigManager INSTANCE = new ConfigManager();
    private static final Map<Class<?>, ConfigData> CONFIGS = new HashMap();
    private static final Map<String, List<ConfigData>> MODID_TO_CONFIGS = new HashMap<String, List<ConfigData>>();
    private static final Field MODID = TRLUtils.MC_VERSION_NUMBER == 8 ? TRLUtils.findField(ConfigChangedEvent.class, "modID") : null;
    private static final Field COMMENT = TRLUtils.MC_VERSION_NUMBER == 8 ? TRLUtils.findField(Property.class, "comment") : null;

    private ConfigManager() {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        String modid = null;
        if (TRLUtils.MC_VERSION_NUMBER == 8) {
            try {
                modid = (String)MODID.get(event);
            }
            catch (IllegalAccessException ex) {
                TRLUtils.crashReport("Failed to retrieve mod ID", ex);
            }
        } else {
            modid = event.getModID();
        }
        MODID_TO_CONFIGS.computeIfAbsent(modid, id -> new ArrayList()).forEach(data -> ConfigManager.reloadFromConfig(data.clazz));
    }

    public static void registerEventHandler() {
        if (Loader.instance().activeModContainer() != null) {
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static void register(Class<?> clazz) {
        Config config = clazz.getAnnotation(Config.class);
        if (config == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a configuration class");
        }
        String modid = config.value();
        String pathData = config.path();
        String pathString = "config/" + (pathData.isEmpty() ? modid : config.path()) + ".cfg";
        Path path = Paths.get(pathString, new String[0]).toAbsolutePath();
        ArrayList<TRLCategory> categories = new ArrayList<TRLCategory>();
        ConfigManager.loadCategories(modid + ".config.", "", clazz, categories);
        ConfigData data = new ConfigData(clazz, pathString, path, categories);
        CONFIGS.put(clazz, data);
        MODID_TO_CONFIGS.computeIfAbsent(modid, id -> new ArrayList()).add(data);
        ConfigManager.reloadFromDisk(clazz);
        ConfigManager.registerEventHandler();
    }

    public static void reloadFromDisk(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        data.config.load();
        ConfigManager.reloadFromConfig(clazz);
    }

    public static void reloadFromConfig(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        for (TRLCategory category : data.categories) {
            for (TRLProperty property : category.properties) {
                if (!property.exists(data.config)) continue;
                try {
                    if (property.adapter.shouldLoad()) {
                        Object delayedLoad = data.delayedLoad.get(property.languageKey);
                        if (delayedLoad != null) {
                            property.reloadDefault();
                            if (delayedLoad instanceof String) {
                                property.get(data.config).setValue((String)delayedLoad);
                            } else {
                                property.get(data.config).setValues((String[])delayedLoad);
                            }
                            data.delayedLoad.remove(property.languageKey);
                        }
                        property.deserialize(data.config);
                        continue;
                    }
                    Object value = property.isArray ? property.get(data.config).getStringList() : property.get(data.config).getString();
                    data.delayedLoad.put(property.languageKey, value);
                }
                catch (Exception ex) {
                    TRLUtils.crashReport("Failed to deserialize configuration property " + property.languageKey, ex);
                }
            }
        }
        ConfigManager.writeToDisk(clazz);
    }

    public static void writeToDisk(Class<?> clazz) {
        ConfigData data = CONFIGS.get(clazz);
        data.config.getCategoryNames().forEach(name -> data.config.removeCategory(data.config.getCategory(name)));
        data.categories.forEach(category -> category.createPropertyOrder(data.config));
        for (TRLCategory category2 : data.categories) {
            category2.onReload(false);
            if (TRLUtils.IS_CLIENT) {
                category2.onReload(true);
            }
            for (TRLProperty property : category2.properties) {
                try {
                    Property configProperty = property.serialize(data.config);
                    ConfigManager.setComment(configProperty, property.commentOnDisk);
                    Object delayedLoad = data.delayedLoad.get(property.languageKey);
                    if (delayedLoad == null) continue;
                    if (delayedLoad instanceof String) {
                        configProperty.setValue((String)delayedLoad);
                        continue;
                    }
                    configProperty.setValues((String[])delayedLoad);
                }
                catch (Exception ex) {
                    TRLUtils.crashReport("Failed to serialize configuration property " + property.languageKey, ex);
                }
            }
        }
        data.config.save();
        for (TRLCategory category2 : data.categories) {
            for (TRLProperty property : category2.properties) {
                property.get(data.config);
            }
        }
    }

    public static Configuration get(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).config;
    }

    public static List<IConfigElement> getConfigElements(Class<?> clazz) {
        Configuration config = ConfigManager.get(clazz);
        return config.getCategoryNames().stream().filter(name -> !name.contains(".")).map(name -> new ConfigElement(config.getCategory(name))).collect(Collectors.toList());
    }

    public static String getPathString(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).pathString;
    }

    public static Path getPath(Class<?> clazz) {
        return ConfigManager.CONFIGS.get(clazz).path;
    }

    public static String getComment(Property property) {
        if (TRLUtils.MC_VERSION_NUMBER != 8) {
            return property.getComment();
        }
        try {
            return (String)COMMENT.get(property);
        }
        catch (Exception ex) {
            TRLUtils.crashReport("Error while getting configuration property comment", ex);
            return null;
        }
    }

    public static void setComment(Property property, String comment) {
        if (TRLUtils.MC_VERSION_NUMBER != 8) {
            property.setComment(comment);
            return;
        }
        try {
            COMMENT.set(property, comment);
        }
        catch (Exception ex) {
            TRLUtils.crashReport("Error while setting configuration property comment", ex);
        }
    }

    private static void loadCategories(String languageKeyPrefix, String parentCategory, Class<?> clazz, List<TRLCategory> categories) {
        for (Field field : clazz.getDeclaredFields()) {
            Config.Category categoryData = field.getAnnotation(Config.Category.class);
            if (categoryData == null) continue;
            String comment = StringUtils.join((Object[])categoryData.value(), (String)"\n");
            if (comment.trim().isEmpty()) {
                throw new IllegalArgumentException("Category comment may not be empty");
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (!(Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers))) {
                throw new IllegalArgumentException(name + " is not public static final");
            }
            if (!ConfigManager.testVersionRange(field)) continue;
            Class<?> categoryClass = field.getType();
            String categoryName = parentCategory + name;
            TRLCategory category = new TRLCategory(languageKeyPrefix, categoryClass, comment, categoryName);
            ConfigManager.loadCategory(category);
            categories.add(category);
            ConfigManager.loadCategories(languageKeyPrefix, categoryName + ".", categoryClass, categories);
        }
    }

    private static void loadCategory(TRLCategory category) {
        for (Field field : category.clazz.getDeclaredFields()) {
            Config.Property propertyData = field.getAnnotation(Config.Property.class);
            if (propertyData == null) continue;
            String comment = StringUtils.join((Object[])propertyData.value(), (String)"\n");
            if (comment.trim().isEmpty()) {
                throw new IllegalArgumentException("Property comment may not be empty");
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                throw new IllegalArgumentException(name + " is not public static non-final");
            }
            if (!ConfigManager.testVersionRange(field)) continue;
            Config.Previous previousData = field.getAnnotation(Config.Previous.class);
            String previous = previousData == null ? null : previousData.value();
            try {
                category.properties.add(new TRLProperty(category, name, field, comment, previous));
            }
            catch (RuntimeException ex) {
                throw new ConfigException(name, ex);
            }
        }
    }

    private static boolean testVersionRange(Field field) {
        Config.MinForgeBuild minForgeBuild;
        Config.MCVersion mcVersion = field.getAnnotation(Config.MCVersion.class);
        if (mcVersion != null) {
            String versionRange = mcVersion.value().trim();
            if (versionRange.isEmpty()) {
                throw new IllegalArgumentException("Version range must not be empty");
            }
            VersionRange range = VersionParser.parseRange((String)versionRange);
            if (!range.containsVersion(TRLUtils.MC_ARTIFACT_VERSION)) {
                return false;
            }
        }
        if ((minForgeBuild = field.getAnnotation(Config.MinForgeBuild.class)) == null) {
            return true;
        }
        int forgeBuild = minForgeBuild.value();
        if (forgeBuild < 1237) {
            throw new IllegalArgumentException("Invalid Forge build: " + forgeBuild);
        }
        return ForgeVersion.getBuildVersion() >= forgeBuild;
    }
}

