/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.block;

import com.mrtrollnugnug.ropebridge.handler.ConfigurationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BridgeSlab
extends Block {
    public static final AxisAlignedBB AABB_BLOCK_1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB AABB_BLOCK_2 = new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB AABB_BLOCK_3 = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 0.75, 1.0);
    public static final AxisAlignedBB AABB_BLOCK_4 = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    public static final PropertyBool ROTATED = PropertyBool.func_177716_a((String)"rotated");
    public static final PropertyInteger FRONT = PropertyInteger.func_177719_a((String)"front", (int)0, (int)3);
    public static final PropertyInteger BACK = PropertyInteger.func_177719_a((String)"back", (int)0, (int)3);
    private final AxisAlignedBB bounds;
    private final int boundIndex;

    public BridgeSlab(AxisAlignedBB bounds, int boundIndex) {
        super(Material.field_151575_d);
        this.boundIndex = boundIndex;
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.OAK)).func_177226_a((IProperty)ROTATED, (Comparable)Boolean.valueOf(false)));
        this.bounds = bounds;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounds;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int slabMeta = ((EnumType)((Object)state.func_177229_b(TYPE))).ordinal();
        ret.add(new ItemStack((Block)Blocks.field_150376_bx, (int)Math.floor(ConfigurationHandler.getSlabsPerBlock() / 2), slabMeta));
        ret.add(new ItemStack(Items.field_151007_F, (int)Math.ceil(ConfigurationHandler.getStringPerBlock() / 2)));
        return ret;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, ROTATED, FRONT, BACK});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        boolean rotated = (meta & 1) == 1;
        int typeValue = meta >> 1;
        EnumType type = EnumType.values()[typeValue % EnumType.values().length];
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a((IProperty)ROTATED, (Comparable)Boolean.valueOf(rotated));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            return state.func_177231_a((IProperty)ROTATED);
        }
        return state;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int frontAmount = 0;
        int backAmount = 0;
        boolean rotated = (Boolean)state.func_177229_b((IProperty)ROTATED);
        EnumFacing front = rotated ? EnumFacing.NORTH : EnumFacing.WEST;
        EnumFacing back = rotated ? EnumFacing.SOUTH : EnumFacing.EAST;
        IBlockState frontState = worldIn.func_180495_p(pos.func_177972_a(front));
        if (frontState.func_177230_c() instanceof BridgeSlab) {
            frontAmount = ((BridgeSlab)frontState.func_177230_c()).boundIndex - this.boundIndex;
        } else {
            frontState = worldIn.func_180495_p(pos.func_177972_a(front).func_177972_a(EnumFacing.UP));
            if (frontState.func_177230_c() instanceof BridgeSlab) {
                frontAmount = ((BridgeSlab)frontState.func_177230_c()).boundIndex + 4 - this.boundIndex;
            }
        }
        IBlockState backState = worldIn.func_180495_p(pos.func_177972_a(back));
        if (backState.func_177230_c() instanceof BridgeSlab) {
            backAmount = ((BridgeSlab)backState.func_177230_c()).boundIndex - this.boundIndex;
        } else {
            backState = worldIn.func_180495_p(pos.func_177972_a(back).func_177972_a(EnumFacing.UP));
            if (backState.func_177230_c() instanceof BridgeSlab) {
                backAmount = ((BridgeSlab)backState.func_177230_c()).boundIndex + 4 - this.boundIndex;
            }
        }
        if (frontAmount < 0 || frontAmount > 3) {
            frontAmount = 0;
        }
        if (backAmount < 0 || backAmount > 3) {
            backAmount = 0;
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)FRONT, (Comparable)Integer.valueOf(frontAmount)).func_177226_a((IProperty)BACK, (Comparable)Integer.valueOf(backAmount));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).ordinal() << 1 | ((Boolean)state.func_177229_b((IProperty)ROTATED) != false ? 1 : 0);
    }

    public static enum EnumType implements IStringSerializable
    {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        BIG_OAK;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

