/*
 * Decompiled with CFR 0.152.
 */
package rustic.common;

import com.google.common.collect.Sets;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import rustic.common.Config;
import rustic.common.blocks.ModBlocks;
import rustic.common.entities.ai.EntityAITemptRustic;
import rustic.common.items.ItemFluidBottle;
import rustic.common.items.ModItems;
import rustic.common.util.GenericUtils;

public class EventHandlerCommon {
    private Random rand = new Random();

    @SubscribeEvent
    public void onOliveOilCraftingEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event.player != null && !event.crafting.func_190926_b() && event.crafting.func_77973_b() instanceof ItemFood && event.crafting.func_77942_o() && event.crafting.func_77978_p().func_74764_b("oiled") && !event.player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo))) {
            event.player.func_71019_a(new ItemStack(Items.field_151069_bo), false);
        }
    }

    @SubscribeEvent
    public void onVineDropEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150395_bd) {
            boolean tryDrop = false;
            if (Config.ENABLE_SEED_DROPS) {
                ItemStack stack;
                String itemName;
                if (!Config.GRAPE_DROP_NEEDS_TOOL) {
                    tryDrop = true;
                } else if (event.getHarvester() != null && !event.getHarvester().func_184614_ca().func_190926_b() && Config.GRAPE_TOOL_WHITELIST.contains(itemName = (stack = event.getHarvester().func_184614_ca()).func_77973_b().getRegistryName().toString())) {
                    tryDrop = true;
                }
            }
            if (tryDrop && this.rand.nextInt(10) == 0) {
                try {
                    event.getDrops().add(new ItemStack((Block)ModBlocks.GRAPE_STEM));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUseTick(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase entityLiving;
        ItemStack originalStack = event.getItem();
        if (!originalStack.func_190926_b() && originalStack.func_77973_b() instanceof ItemSoup && originalStack.func_77942_o() && originalStack.func_77978_p().func_74764_b("oiled") && (entityLiving = event.getEntityLiving()) instanceof EntityPlayer && event.getDuration() == 1) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_75122_a(2, 0.3f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entityLiving;
        ItemStack originalStack = event.getItem();
        if (!originalStack.func_190926_b() && originalStack.func_77973_b() instanceof ItemFood && originalStack.func_77942_o() && originalStack.func_77978_p().func_74764_b("oiled") && (entityLiving = event.getEntityLiving()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_75122_a(2, 0.3f);
        }
    }

    @SubscribeEvent
    public void onPlayerUseGlassBottle(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_77973_b().equals(Items.field_151069_bo)) {
            EntityPlayer player = event.getEntityPlayer();
            BlockPos pos = event.getPos();
            ItemStack stack = event.getItemStack();
            World world = event.getWorld();
            RayTraceResult raytraceresult = GenericUtils.rayTrace(world, player, true);
            if (raytraceresult == null || raytraceresult.func_178782_a() == null) {
                return;
            }
            BlockPos pos2 = raytraceresult.func_178782_a();
            if (player.func_175151_a(pos2, event.getFace(), stack) && player.func_175151_a(pos2.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, stack)) {
                IBlockState state = world.func_180495_p(pos2);
                if (state.func_177230_c() instanceof IFluidBlock) {
                    IFluidBlock fluidblock = (IFluidBlock)state.func_177230_c();
                    if (ItemFluidBottle.VALID_FLUIDS.contains(fluidblock.getFluid()) && fluidblock.getFilledPercentage(world, pos2) == 1.0f) {
                        world.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 11);
                        player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                        player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        ItemStack bottlestack = new ItemStack((Item)ModItems.FLUID_BOTTLE, 1);
                        NBTTagCompound fluidTag = new FluidStack(fluidblock.getFluid(), 1000).writeToNBT(new NBTTagCompound());
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74782_a("Fluid", (NBTBase)fluidTag);
                        bottlestack.func_77982_d(tag);
                        if (!player.field_71071_by.func_70441_a(bottlestack)) {
                            player.func_71019_a(bottlestack, false);
                        }
                    }
                } else if (state.func_177230_c() instanceof ITileEntityProvider && world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace())) {
                    if (state.func_177230_c() == ModBlocks.BREWING_BARREL && event.getFace() != EnumFacing.DOWN) {
                        return;
                    }
                    IFluidHandler tank = (IFluidHandler)world.func_175625_s(pos).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace());
                    if (tank != null && tank.drain(1000, false) != null && tank.drain(1000, false).getFluid() != null) {
                        if (ItemFluidBottle.VALID_FLUIDS.contains(tank.drain(1000, false).getFluid()) && tank.drain((int)1000, (boolean)false).amount >= 1000) {
                            FluidStack fill = tank.drain(1000, true);
                            player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                            stack.func_190918_g(1);
                            ItemStack bottlestack = new ItemStack((Item)ModItems.FLUID_BOTTLE, 1);
                            NBTTagCompound fluidTag = fill.writeToNBT(new NBTTagCompound());
                            NBTTagCompound tag = new NBTTagCompound();
                            tag.func_74782_a("Fluid", (NBTBase)fluidTag);
                            bottlestack.func_77982_d(tag);
                            if (!player.field_71071_by.func_70441_a(bottlestack)) {
                                player.func_71019_a(bottlestack, false);
                            }
                            event.setCanceled(true);
                        } else if (tank.drain(1000, false).getFluid() == FluidRegistry.WATER) {
                            tank.drain(1000, true);
                            player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                            stack.func_190918_g(1);
                            ItemStack bottlestack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                            if (!player.field_71071_by.func_70441_a(bottlestack)) {
                                player.func_71019_a(bottlestack, false);
                            }
                            event.setCanceled(true);
                            event.setUseBlock(Event.Result.DENY);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onSeedInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityChicken) {
            ItemStack equippedItem = event.getEntityPlayer().func_184586_b(event.getHand());
            EntityAnimal targetAnimal = (EntityAnimal)event.getTarget();
            if (!(equippedItem == null || equippedItem.func_77973_b() != ModItems.TOMATO_SEEDS && equippedItem.func_77973_b() != ModItems.CHILI_PEPPER_SEEDS || targetAnimal.func_70874_b() < 0 || targetAnimal.func_70880_s())) {
                EntityPlayer player = event.getEntityPlayer();
                if (!player.field_71075_bZ.field_75098_d) {
                    equippedItem.func_190918_g(1);
                }
                targetAnimal.func_146082_f(player);
            }
        }
    }

    @SubscribeEvent
    public void onChickenUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().getClass().equals(EntityChicken.class)) {
            EntityChicken chicken = (EntityChicken)event.getEntity();
            for (EntityAITasks.EntityAITaskEntry task : chicken.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof EntityAITemptRustic)) continue;
                return;
            }
            chicken.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITemptRustic((EntityCreature)chicken, 1.0, Sets.newHashSet((Object[])new Item[]{ModItems.CHILI_PEPPER_SEEDS, ModItems.TOMATO_SEEDS, Item.func_150898_a((Block)ModBlocks.APPLE_SEEDS), Item.func_150898_a((Block)ModBlocks.GRAPE_STEM)}), false));
        }
    }
}

