/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import rustic.common.blocks.BlockCondenser;
import rustic.common.blocks.BlockCondenserAdvanced;
import rustic.common.blocks.ModBlocks;
import rustic.common.crafting.ICondenserRecipe;
import rustic.common.crafting.Recipes;
import rustic.common.tileentity.TileEntityCondenserBase;
import rustic.core.Rustic;

public class TileEntityCondenserAdvancedBottom
extends TileEntityCondenserBase {
    public static final int SLOT_NUM = 7;
    private IItemHandler handlerBottom;
    private IItemHandler handlerBack;
    private IItemHandler handlerTop;
    private IItemHandler handlerSide;

    @Override
    protected int getInternalSize() {
        return 7;
    }

    @Override
    public String getName() {
        return "container.rustic.condenser_advanced";
    }

    public TileEntityCondenserAdvancedBottom() {
        this.handlerBottom = new RangedWrapper((IItemHandlerModifiable)this.externalStackHandler, 0, 1);
        this.handlerBack = new RangedWrapper((IItemHandlerModifiable)this.externalStackHandler, 1, 3);
        this.handlerTop = new RangedWrapper((IItemHandlerModifiable)this.externalStackHandler, 3, 4);
        this.handlerSide = new RangedWrapper((IItemHandlerModifiable)this.externalStackHandler, 4, 7);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.CONDENSER_ADVANCED || !((BlockCondenserAdvanced)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.CONDENSER_ADVANCED || !((BlockCondenserAdvanced)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c))) {
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.externalStackHandler;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            if (facing == ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCondenser.FACING)).func_176734_d()) {
                return (T)this.handlerBack;
            }
            if (facing.func_176740_k() != EnumFacing.Axis.Y) {
                return (T)this.handlerSide;
            }
            return (T)this.externalStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected boolean canBrew() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != ModBlocks.CONDENSER_ADVANCED || !((Boolean)state.func_177229_b((IProperty)BlockCondenserAdvanced.BOTTOM)).booleanValue()) {
            return false;
        }
        if (this.internalStackHandler.getStackInSlot(4).func_190926_b() && this.internalStackHandler.getStackInSlot(5).func_190926_b() && this.internalStackHandler.getStackInSlot(6).func_190926_b()) {
            return false;
        }
        return ((BlockCondenserAdvanced)state.func_177230_c()).hasRetorts(this.field_145850_b, this.field_174879_c, state);
    }

    @Override
    protected void refreshCurrentRecipe() {
        if (this.hasContentChanged) {
            this.hasContentChanged = false;
            Fluid fluid = this.getFluid();
            ItemStack modifier = this.internalStackHandler.getStackInSlot(3);
            ItemStack bottle = this.internalStackHandler.getStackInSlot(2);
            ItemStack[] inputs = new ItemStack[]{this.internalStackHandler.getStackInSlot(4), this.internalStackHandler.getStackInSlot(5), this.internalStackHandler.getStackInSlot(6)};
            if (this.currentRecipe != null && this.currentRecipe.matches(fluid, modifier, bottle, inputs)) {
                return;
            }
            this.brewTime = 0;
            this.currentRecipe = null;
            for (ICondenserRecipe recipe : Recipes.condenserRecipes) {
                if (!recipe.isBasic() && !recipe.isAdvanced() || !recipe.matches(fluid, modifier, bottle, inputs)) continue;
                this.currentRecipe = recipe;
                this.totalBrewTime = recipe.getTime();
                return;
            }
        }
    }

    @Override
    protected void renderParticles() {
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == ModBlocks.CONDENSER_ADVANCED) {
            EnumFacing blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCondenserAdvanced.FACING);
            double yVel = 0.125;
            switch (blockFacing) {
                case NORTH: {
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 1.5, 0.0, yVel, 0.0);
                    break;
                }
                case SOUTH: {
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() - 0.5, 0.0, yVel, 0.0);
                    break;
                }
                case WEST: {
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() - 0.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 1.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                    break;
                }
                case EAST: {
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() - 0.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 1.5, 0.0, yVel, 0.0);
                    Rustic.proxy.spawnAlchemySmokeFX(this.field_145850_b, this.brewTime, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o() + 1.0625, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, yVel, 0.0);
                    break;
                }
            }
        }
    }

    @Override
    protected void brew() {
        ItemStack[] inputs;
        ItemStack bottle;
        ItemStack modifier;
        Fluid fluid;
        ICondenserRecipe recipe;
        if (this.canBrew() && (recipe = this.currentRecipe).matches(fluid = this.getFluid(), modifier = this.internalStackHandler.getStackInSlot(3), bottle = this.internalStackHandler.getStackInSlot(2), inputs = new ItemStack[]{this.internalStackHandler.getStackInSlot(4), this.internalStackHandler.getStackInSlot(5), this.internalStackHandler.getStackInSlot(6)}) && this.getAmount() >= recipe.getFluid().amount) {
            this.internalStackHandler.insertItem(0, recipe.getResult(), false);
            this.internalStackHandler.extractItem(3, recipe.getModifierConsumption(modifier), false);
            int[] consume = recipe.getInputConsumption(inputs);
            this.internalStackHandler.extractItem(4, consume[0], false);
            this.internalStackHandler.extractItem(5, consume[1], false);
            this.internalStackHandler.extractItem(6, consume[2], false);
            this.internalStackHandler.extractItem(2, recipe.getBottleConsumption(bottle), false);
            this.tank.drain(recipe.getFluid().amount, true);
        }
    }
}

