/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.client.gui.GuiBookmarkButton;
import net.tropicraft.client.gui.GuiClearButton;
import net.tropicraft.client.gui.GuiIndexButton;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.common.sound.TropicraftSounds;
import net.tropicraft.core.encyclopedia.Page;
import net.tropicraft.core.encyclopedia.RecipeEntry;
import net.tropicraft.core.encyclopedia.TropicalBook;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiTropicalBook
extends GuiScreen {
    public static final int COLOR_NEW = 0x3333FF;
    public static final int COLOR_READ = 0x440000;
    public static final int COLOR_HIGHLIGHT = 0x990000;
    private TropicalBook book;
    private int indexPage = -1;
    private Page selectedPage;
    private int contentPage = 0;
    private boolean showingBookmarks;
    private String coverBackground;
    private String pageBackgroundL;
    private String pageBackgroundR;
    private String closedTextureIndex;
    private String openTextureIndex;
    private RenderItem itemRenderer;
    @Nonnull
    private List<RecipeEntry> cachedRecipes = new ArrayList<RecipeEntry>();
    float recipeCycle;
    private GuiButton coverButton;
    private GuiButton prevPage;
    private GuiButton nextPage;
    private GuiButton prevContentPage;
    private GuiButton nextContentPage;
    private List<List<GuiIndexButton>> pageButtons = new ArrayList<List<GuiIndexButton>>();
    private GuiButton bookmarkButton;
    private List<GuiBookmarkButton> bookmarks = new ArrayList<GuiBookmarkButton>();
    private static final int buttonNextIndexPage = -1;
    private static final int buttonPrevIndexPage = -2;
    private static final int buttonBookCover = -3;
    private static final int buttonCraftingPage = -4;
    private static final int buttonInfoPage = -5;
    private static final int buttonNextContentPage = -6;
    private static final int buttonPrevContentPage = -7;
    private List<String> ttLines;

    public GuiTropicalBook(TropicalBook tropbook) {
        this.book = tropbook;
        this.coverBackground = tropbook.outsideTexture;
        this.pageBackgroundL = "encyclopedia_background_left";
        this.pageBackgroundR = "encyclopedia_background_right";
        this.closedTextureIndex = tropbook.outsideTexture;
        this.openTextureIndex = tropbook.insideTexture;
        this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.addButtons();
        this.updateButtons();
    }

    protected void func_146284_a(@Nonnull GuiButton guibutton) {
        this.showingBookmarks = false;
        if (guibutton == this.bookmarkButton) {
            this.showingBookmarks = true;
            this.contentPage = 0;
            this.selectedPage = null;
            return;
        }
        if (guibutton instanceof GuiBookmarkButton) {
            this.indexPage = ((GuiBookmarkButton)guibutton).getTarget();
            List<GuiIndexButton> btns = this.pageButtons.get(this.indexPage);
            for (GuiButton guiButton : this.field_146292_n) {
                if (!(guiButton instanceof GuiIndexButton)) continue;
                ((GuiIndexButton)guiButton).color = 0x440000;
            }
            for (GuiIndexButton guiIndexButton : btns) {
                if (guiIndexButton.getPage() != ((GuiBookmarkButton)guibutton).getPage()) continue;
                guiIndexButton.color = 0x3333FF;
            }
            return;
        }
        switch (guibutton.field_146127_k) {
            case -3: {
                this.indexPage = 0;
                this.contentPage = 0;
                break;
            }
            case -1: {
                ++this.indexPage;
                this.contentPage = 0;
                break;
            }
            case -2: {
                --this.indexPage;
                this.contentPage = 0;
                break;
            }
            case -6: {
                ++this.contentPage;
                break;
            }
            case -7: {
                --this.contentPage;
                break;
            }
            default: {
                this.selectedPage = ((GuiIndexButton)guibutton).getPage();
                if (this.selectedPage.hasContent()) {
                    if (this.book.isPageVisible(this.selectedPage.getId()) && !this.book.hasPageBeenRead(this.selectedPage.getId())) {
                        this.book.markPageAsRead(this.selectedPage.getId());
                        ((GuiClearButton)guibutton).color = 0x440000;
                    }
                    this.contentPage = 0;
                    this.cachedRecipes = this.selectedPage.getRelevantRecipes();
                    this.recipeCycle = 0.0f;
                    break;
                }
                this.selectedPage = null;
            }
        }
    }

    private void updateButtons() {
        this.coverButton.field_146125_m = this.indexPage == -1;
        this.nextContentPage.field_146125_m = !this.showingBookmarks && this.selectedPage != null && this.cachedRecipes.size() > this.contentPage * 6 + 3;
        this.prevContentPage.field_146125_m = !this.showingBookmarks && this.selectedPage != null && this.contentPage > 0;
        this.nextPage.field_146125_m = !this.showingBookmarks && this.indexPage >= 0 && this.selectedPage == null && this.indexPage < this.pageButtons.size() - 1;
        this.prevPage.field_146125_m = !this.showingBookmarks && this.indexPage > 0 && this.selectedPage == null;
        for (int i = 0; i < this.pageButtons.size(); ++i) {
            for (GuiIndexButton btn : this.pageButtons.get(i)) {
                btn.field_146125_m = !this.showingBookmarks && this.selectedPage == null && i == this.indexPage;
            }
        }
        this.bookmarkButton.field_146125_m = !this.showingBookmarks && this.indexPage >= 0 && this.selectedPage == null;
        for (GuiBookmarkButton btn : this.bookmarks) {
            btn.field_146125_m = this.showingBookmarks;
        }
        this.recipeCycle = 0.0f;
    }

    private void addButtons() {
        this.field_146292_n.clear();
        this.coverButton = new GuiClearButton(-3, 0, 0, this.field_146294_l, this.field_146295_m, "", 0, this.coverBackground, 0x440000);
        this.field_146292_n.add(this.coverButton);
        this.prevContentPage = new GuiClearButton(-7, this.field_146294_l / 2 - 164, this.field_146295_m / 2 - 20, 11, 22, "", 1, this.openTextureIndex, 0x440000);
        this.field_146292_n.add(this.prevContentPage);
        this.nextContentPage = new GuiClearButton(-6, this.field_146294_l / 2 + 152, this.field_146295_m / 2 - 20, 11, 22, "", 2, this.openTextureIndex, 0x440000);
        this.field_146292_n.add(this.nextContentPage);
        this.bookmarkButton = new GuiClearButton(-1000, this.field_146294_l / 2 + 130, this.field_146295_m / 2 - 119, 11, 17, "", 4, this.openTextureIndex, -1){

            @Override
            public void func_191745_a(Minecraft minecraft, int i, int j, float partialTicks) {
                super.func_191745_a(minecraft, i, j, partialTicks);
            }
        };
        this.field_146292_n.add(this.bookmarkButton);
        boolean left = true;
        int y = 0;
        int page = 0;
        int bookmarkY = 0;
        for (int entry = 0; entry < this.book.getPageCount(); ++entry) {
            if (!this.book.isPageVisible(entry)) continue;
            if (y > (this.book.getPage(entry).isBookmark() ? 155 : 175)) {
                if (!left) {
                    ++page;
                }
                left = !left;
                y = left ? 0 : -20;
            }
            this.addIndexButton(entry, page, this.field_146294_l / 2 + (left ? -150 : 14), this.field_146295_m / 2 - 84 + y);
            if (this.book.getPage(entry).isBookmark()) {
                this.addBookmarkButton(entry, page, bookmarkY);
                bookmarkY += 10;
            }
            y += 20;
        }
        this.prevPage = new GuiClearButton(-2, this.field_146294_l / 2 - 164, this.field_146295_m / 2 - 20, 11, 22, "", 1, this.openTextureIndex, 0x440000);
        this.field_146292_n.add(this.prevPage);
        this.nextPage = new GuiClearButton(-1, this.field_146294_l / 2 + 152, this.field_146295_m / 2 - 20, 11, 22, "", 2, this.openTextureIndex, 0x440000);
        this.field_146292_n.add(this.nextPage);
    }

    private void addIndexButton(int entry, int page, int x, int y) {
        int maxW;
        int titleW;
        String pageTitle = this.book.getPageTitleNotVisible();
        int color = 0x440000;
        if (this.book.isPageVisible(entry)) {
            pageTitle = this.book.getPage(entry).getLocalizedTitle();
            if (!this.book.hasPageBeenRead(entry)) {
                color = 0x3333FF;
            }
        }
        if ((titleW = this.field_146289_q.func_78256_a(pageTitle)) > (maxW = 116)) {
            pageTitle = pageTitle + "...";
        }
        while (titleW > maxW) {
            pageTitle = pageTitle.substring(0, pageTitle.length() - 4) + "...";
            titleW = this.field_146289_q.func_78256_a(pageTitle);
        }
        GuiIndexButton btn = new GuiIndexButton(this, this.book.getPage(entry), entry, x, y, 116, 15, pageTitle, -1, this.openTextureIndex, color);
        this.field_146292_n.add(btn);
        if (this.pageButtons.size() == page) {
            this.pageButtons.add(new ArrayList());
        }
        this.pageButtons.get(page).add(btn);
    }

    private void addBookmarkButton(int entry, int page, int y) {
        GuiBookmarkButton btn = new GuiBookmarkButton(this.book.getPage(entry), page, ~entry, this.field_146294_l / 2 - 150, this.field_146295_m / 2 - 85 + y, 116, 10);
        this.field_146292_n.add(btn);
        this.bookmarks.add(btn);
    }

    protected void func_73864_a(int x, int y, int mousebutton) {
        if (mousebutton == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, x, y)) continue;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)TropicraftSounds.PAGE_FLIP, (float)1.0f));
                this.func_146284_a(guibutton);
            }
        } else if (mousebutton == 1) {
            if (this.showingBookmarks) {
                this.showingBookmarks = false;
            } else if (this.selectedPage != null) {
                this.selectedPage = null;
            } else if (this.indexPage >= 0) {
                this.indexPage = -1;
            }
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)TropicraftSounds.PAGE_FLIP, (float)1.0f));
            this.showingBookmarks = false;
        }
        this.updateButtons();
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_146297_k.field_71439_g));
                return;
            }
            this.func_73869_a(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void func_73863_a(int i, int j, float elapsedPartialTicks) {
        this.recipeCycle += elapsedPartialTicks;
        this.ttLines = null;
        this.func_146276_q_();
        int w = this.field_146294_l / 2;
        int h = this.field_146295_m / 2;
        if (this.indexPage == -1) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            TropicraftRenderUtils.bindTextureGui(this.coverBackground);
            this.func_73729_b(w - 64, h - 86, 0, 0, 128, 173);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            TropicraftRenderUtils.bindTextureGui(this.pageBackgroundL);
            this.func_73729_b(w - 167, h - 117, 89, 0, 167, 235);
            TropicraftRenderUtils.bindTextureGui(this.pageBackgroundR);
            this.func_73729_b(w, h - 117, 0, 0, 166, 235);
            if (this.selectedPage != null) {
                if (this.book.isPageVisible(this.selectedPage.getId())) {
                    String pageTitle;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179140_f();
                    String string = pageTitle = this.book.isPageVisible(this.selectedPage.getId()) ? this.selectedPage.getLocalizedTitle() : this.book.getPageTitleNotVisible();
                    if (this.contentPage == 0) {
                        boolean toolong;
                        boolean bl = toolong = this.field_146289_q.func_78256_a(pageTitle) > 105 && !this.field_146289_q.func_82883_a();
                        if (toolong) {
                            this.field_146289_q.func_78264_a(true);
                        }
                        this.field_146289_q.func_78276_b(pageTitle, this.field_146294_l / 2 - 150, this.field_146295_m / 2 - 110, 0x440000);
                        if (toolong) {
                            this.field_146289_q.func_78264_a(false);
                        }
                        this.selectedPage.drawHeader(this.field_146294_l / 2 - 150, this.field_146295_m / 2 - 80, i, j, this.recipeCycle);
                    }
                    int baseY = this.field_146295_m / 2 - 80;
                    int y = this.selectedPage.getHeaderHeight();
                    ArrayList<String> pageStrings = new ArrayList<String>();
                    List allStrings = this.field_146289_q.func_78271_c(this.selectedPage.getLocalizedDescription(), 135);
                    int page = 0;
                    for (String s : allStrings) {
                        if (s.trim().isEmpty()) continue;
                        if (y > (page == 0 ? 170 : 205)) {
                            ++page;
                            y = 0;
                        }
                        if (pageStrings.size() <= page) {
                            pageStrings.add("");
                        }
                        pageStrings.set(page, (String)pageStrings.get(page) + "\n" + s);
                        y += this.field_146289_q.field_78288_b;
                    }
                    if (pageStrings.size() > this.contentPage * 2) {
                        this.field_146289_q.func_78279_b((String)pageStrings.get(this.contentPage * 2), this.field_146294_l / 2 - 150, baseY + (this.contentPage == 0 ? this.selectedPage.getHeaderHeight() + this.field_146289_q.field_78288_b : -33), 135, 0x440000);
                    }
                    if (pageStrings.size() > this.contentPage * 2 + 1) {
                        this.field_146289_q.func_78279_b((String)pageStrings.get(this.contentPage * 2 + 1), this.field_146294_l / 2 + 20, baseY - 33, 135, 0x440000);
                    }
                    boolean bl = this.nextContentPage.field_146125_m = (this.contentPage + 1) * 2 < pageStrings.size();
                    if (this.cachedRecipes.size() > 0) {
                        this.field_146289_q.func_78276_b("Crafting", this.field_146294_l / 2 + 110, this.field_146295_m / 2 - 110, 0x440000);
                        if (this.contentPage > 0) {
                            this.field_146289_q.func_78276_b("Crafting", this.field_146294_l / 2 - 150, this.field_146295_m / 2 - 110, 0x440000);
                        }
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                        TropicraftRenderUtils.bindTextureGui(this.openTextureIndex);
                        this.func_73729_b(this.field_146294_l / 2 + 45, this.field_146295_m / 2 - 115, 122, 201, 113, 32);
                        if (this.contentPage > 0) {
                            this.func_73729_b(this.field_146294_l / 2 - 159, this.field_146295_m / 2 - 115, 145, 201, 113, 32);
                        }
                    }
                    try {
                        this.printRecipes(i, j, elapsedPartialTicks);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (this.contentPage == 0) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179140_f();
                        TropicraftRenderUtils.bindTextureGui(this.openTextureIndex);
                        this.func_73729_b(this.field_146294_l / 2 - 159, this.field_146295_m / 2 - 115, 145, 201, 113, 32);
                        this.func_73729_b(this.field_146294_l / 2 - 47, this.field_146295_m / 2 - 115, 90, 201, 32, 32);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179152_a((float)1.25f, (float)1.25f, (float)1.25f);
                        this.selectedPage.drawIcon((int)((float)(this.field_146294_l / 2) * 0.8f - 33.0f), (int)((float)(this.field_146295_m / 2) * 0.8f - 87.0f), this.recipeCycle);
                        GlStateManager.func_179121_F();
                    }
                }
            } else {
                TropicraftRenderUtils.bindTextureGui(this.openTextureIndex);
                this.func_73729_b(w - 156, h - 102, 122, 214, 134, 8);
                String title = "tropicraft" + (this.showingBookmarks ? ".book.bookmarks.title" : ".book.toc.title");
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)title, (Object[])new Object[0]), w - 150, h - 110, 0x440000);
                this.field_146289_q.func_78276_b("" + (1 + this.indexPage * 2), w - 157, h + 97, 0x440000);
                String secondPageNum = "" + (2 + this.indexPage * 2);
                int sw = this.field_146289_q.func_78256_a(secondPageNum);
                this.field_146289_q.func_78276_b(secondPageNum, w + 157 - sw, h + 97, 0x440000);
            }
        }
        super.func_73863_a(i, j, elapsedPartialTicks);
        if (this.ttLines == null && this.bookmarkButton.field_146125_m && this.bookmarkButton.func_146115_a()) {
            this.ttLines = Arrays.asList(I18n.func_135052_a((String)"tropicraft.book.bookmarks.tooltip", (Object[])new Object[0]));
        }
        if (this.ttLines != null) {
            this.func_146283_a(this.ttLines, i, j);
        }
    }

    private void printRecipes(int mx, int my, float elapsedPartialTicks) throws Exception {
        if (this.cachedRecipes.isEmpty()) {
            return;
        }
        int newx = this.contentPage == 0 ? this.field_146294_l / 2 + 25 : this.field_146294_l / 2 - 136;
        int newy = this.field_146295_m / 2 - 80;
        int max = 3;
        if (this.contentPage > 0) {
            max *= 2;
        }
        int start = this.contentPage == 0 ? 0 : (this.contentPage - 1) * 6 + 3;
        max += start;
        int idx = 0;
        for (int entry = start; entry < max && entry < this.cachedRecipes.size(); ++entry) {
            int renderY;
            int renderX;
            int itemIndex;
            int col;
            int row;
            RecipeEntry recipe = this.cachedRecipes.get(entry);
            if (recipe == null) continue;
            GlStateManager.func_179140_f();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            TropicraftRenderUtils.bindTextureGui(this.openTextureIndex);
            this.func_73729_b(newx - 3, newy - 3, 0, 187, 122, 60);
            int offsetX = 18;
            int offsetY = 18;
            for (row = 0; row < recipe.getHeight(); ++row) {
                for (col = 0; col < recipe.getWidth(); ++col) {
                    itemIndex = row * recipe.getWidth() + col;
                    if (recipe.getIngredients().get(itemIndex) == Ingredient.field_193370_a) continue;
                    renderX = newx + offsetX * col + 1;
                    renderY = newy + offsetY * row + 1;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179091_B();
                    RenderHelper.func_74520_c();
                    this.itemRenderer.func_175042_a(recipe.getCycledStack(itemIndex, this.recipeCycle), renderX, renderY);
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179101_C();
                    GlStateManager.func_179121_F();
                }
            }
            for (row = 0; row < recipe.getHeight(); ++row) {
                for (col = 0; col < recipe.getWidth(); ++col) {
                    itemIndex = row * recipe.getWidth() + col;
                    renderX = newx + offsetX * col + 1;
                    renderY = newy + offsetY * row + 1;
                    this.checkMouseHover(recipe.getCycledStack(itemIndex, this.recipeCycle), renderX, renderY, mx, my, 18);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            RenderHelper.func_74520_c();
            this.itemRenderer.func_175042_a(recipe.getOutput(), newx + 95, newy + 19);
            this.itemRenderer.func_180453_a(this.field_146289_q, recipe.getOutput(), newx / 3 + 60, newy / 3 + 11, "");
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            this.checkMouseHover(recipe.getOutput(), newx + 90, newy + 20, mx, my, 25);
            GlStateManager.func_179121_F();
            newy += 62;
            if (++idx != 3) continue;
            newx = this.field_146294_l / 2 + 25;
            newy = this.field_146295_m / 2 - 80;
        }
    }

    private void checkMouseHover(Ingredient ingredient, int x, int y, int mx, int my, int size) {
        if (ingredient.func_193365_a().length > 0) {
            this.checkMouseHover(ingredient.func_193365_a()[0], x, y, mx, my, size);
        }
    }

    private void checkMouseHover(ItemStack itemstack, int x, int y, int mx, int my, int size) {
        boolean checkHover = mx >= x && my >= y && mx < x + size && my < y + size;
        float z = this.field_73735_i;
        this.field_73735_i = 500.0f;
        if (!itemstack.func_190926_b() && checkHover) {
            ITooltipFlag.TooltipFlags flag = this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            this.ttLines = itemstack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)flag);
        }
        this.field_73735_i = z;
    }
}

