/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.common.entity.hostile.EntityAshenHunter;
import net.tropicraft.core.common.entity.hostile.EntityIguana;
import net.tropicraft.core.common.entity.hostile.EntityTreeFrog;
import net.tropicraft.core.common.entity.hostile.EntityTropiCreeper;
import net.tropicraft.core.common.entity.hostile.EntityTropiSkeleton;
import net.tropicraft.core.common.entity.passive.EntityFailgull;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.EntityVMonkey;
import net.tropicraft.core.common.entity.underdasea.EntitySeaTurtle;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityDolphin;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityMarlin;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntitySeahorse;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityShark;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicraftWaterBase;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@SideOnly(value=Side.CLIENT)
public class GuiTropicsLoading
extends GuiDownloadTerrain {
    private static final String[] CATEGORIES = new String[]{"misc", "knowledge", "hint"};
    private static final String[] BACKGROUNDS = new String[]{"loading_bg1", "loading_bg2", "loading_bg3"};
    private static final Class<?>[] MOBS_WATER = new Class[]{EntityMarlin.class, EntityDolphin.class, EntityShark.class, EntitySeaTurtle.class, EntitySeahorse.class, EntityFailgull.class};
    private static final Class<?>[] MOBS_LAND = new Class[]{EntityIguana.class, EntityFailgull.class, EntityVMonkey.class, EntityTreeFrog.class};
    private static final Class<?>[] MOBS_VILLAGE = new Class[]{EntityKoaHunter.class, EntityAshenHunter.class, EntityTropiCreeper.class, EntityTropiSkeleton.class};
    private static final ItemStack[] ITEMS = new ItemStack[]{new ItemStack(ItemRegistry.lemon), new ItemStack(ItemRegistry.lime), new ItemStack(ItemRegistry.orange), new ItemStack(BlockRegistry.coconut), new ItemStack(BlockRegistry.coconut), new ItemStack(ItemRegistry.coconutBomb), new ItemStack(ItemRegistry.bambooStick), new ItemStack(ItemRegistry.bambooMug), new ItemStack(ItemRegistry.grapefruit), new ItemStack(ItemRegistry.yellowFlippers)};
    private final Minecraft mc = FMLClientHandler.instance().getClient();
    private final HashMap<String, Class<? extends Entity>[]> backgroundToEntityMap = new HashMap();
    private Random rand = new Random();
    private long animTick = 0L;
    private Pair<Entity, Entity> screenEntities = null;
    private Triple<ItemStack, ItemStack, ItemStack> screenItems = null;
    private String screenTitle = "";
    private String screenBackground = BACKGROUNDS[0];
    private boolean screenReassign = false;
    private boolean isLeaving = false;
    private boolean isEgg = false;

    public GuiTropicsLoading() {
        this.backgroundToEntityMap.put(BACKGROUNDS[0], MOBS_WATER);
        this.backgroundToEntityMap.put(BACKGROUNDS[1], MOBS_LAND);
        this.backgroundToEntityMap.put(BACKGROUNDS[2], MOBS_VILLAGE);
        this.assignScreenContent();
        this.animTick = this.rand.nextInt(12345);
    }

    public void setLeaving(boolean b) {
        this.isLeaving = b;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.screenReassign) {
            this.assignScreenContent();
            this.screenReassign = false;
        }
        if (this.screenEntities.getLeft() instanceof EntityKoaHunter) {
            ++((Entity)this.screenEntities.getLeft()).field_70173_aa;
        }
        if (this.screenEntities.getRight() instanceof EntityKoaHunter) {
            ++((Entity)this.screenEntities.getRight()).field_70173_aa;
        }
        ++this.animTick;
    }

    public void assignScreenContent() {
        String cat = CATEGORIES[this.rand.nextInt(CATEGORIES.length)];
        int count = 0;
        String key = "tropicraft.loading." + cat + ".1";
        while (!I18n.func_135052_a((String)key, (Object[])new Object[0]).equals(key)) {
            key = "tropicraft.loading." + cat + "." + count++;
        }
        this.screenTitle = "tropicraft.loading." + cat + "." + String.valueOf(this.rand.nextInt(count + 1) + 1);
        if (cat.equals("knowledge") || cat.equals("hint")) {
            String prepend = I18n.func_135052_a((String)("tropicraft.loading." + cat + ".pre"), (Object[])new Object[0]);
            this.screenTitle = I18n.func_135052_a((String)this.screenTitle, (Object[])new Object[]{prepend});
        } else {
            this.screenTitle = I18n.func_135052_a((String)this.screenTitle, (Object[])new Object[0]);
        }
        this.screenBackground = BACKGROUNDS[this.rand.nextInt(BACKGROUNDS.length)];
        ArrayList<Object> ta = new ArrayList<Object>(Arrays.asList((Object[])this.backgroundToEntityMap.get(this.screenBackground)));
        Class firstEntClass = (Class)ta.get(this.rand.nextInt(ta.size()));
        ResourceLocation firstEnt = EntityList.func_191306_a((Class)firstEntClass);
        Entity ent1 = this.eggWrap(EntityList.func_188429_b((ResourceLocation)firstEnt, (World)this.mc.field_71441_e), 0);
        ta.remove(firstEntClass);
        Entity ent2 = this.eggWrap(EntityList.func_188429_b((ResourceLocation)EntityList.func_191306_a((Class)((Class)ta.get(this.rand.nextInt(ta.size())))), (World)this.mc.field_71441_e), 1);
        if (ent1 instanceof EntityTropicraftWaterBase) {
            ((EntityTropicraftWaterBase)ent1).assignRandomTexture();
            ((EntityTropicraftWaterBase)ent1).isInGui = true;
        }
        if (ent2 instanceof EntityTropicraftWaterBase) {
            ((EntityTropicraftWaterBase)ent2).assignRandomTexture();
            ((EntityTropicraftWaterBase)ent2).isInGui = true;
        }
        this.screenEntities = Pair.of((Object)ent1, (Object)ent2);
        ArrayList<ItemStack> possibleStacks = new ArrayList<ItemStack>(Arrays.asList(ITEMS));
        ItemStack left = possibleStacks.get(this.rand.nextInt(possibleStacks.size()));
        possibleStacks.remove(left);
        ItemStack mid = possibleStacks.get(this.rand.nextInt(possibleStacks.size()));
        possibleStacks.remove(mid);
        ItemStack right = possibleStacks.get(this.rand.nextInt(possibleStacks.size()));
        this.screenItems = Triple.of((Object)left, (Object)mid, (Object)right);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.screenEntities == null && this.mc.field_71441_e != null) {
            this.assignScreenContent();
        }
        FontRenderer f = this.mc.field_71466_p;
        ScaledResolution sr = new ScaledResolution(this.mc);
        this.drawBackground(sr.func_78326_a(), sr.func_78328_b());
        if (this.screenEntities != null) {
            this.drawScreenEntity((Entity)this.screenEntities.getLeft(), sr.func_78326_a() / 2 - 120, sr.func_78328_b() / 2 + 60, 50.0f, -90 + (int)(((float)this.animTick + partialTicks) * 2.0f), 20.0f);
            this.drawScreenEntity((Entity)this.screenEntities.getRight(), sr.func_78326_a() / 2 + 120, sr.func_78328_b() / 2 + 60, 50.0f, 90 - (int)(((float)this.animTick + partialTicks) * 2.0f), 20.0f);
            this.drawScreenItemStack((ItemStack)this.screenItems.getLeft(), sr.func_78326_a() / 2 - 8 - 24, sr.func_78328_b() / 2 + 8, 1.5f);
            this.drawScreenItemStack((ItemStack)this.screenItems.getMiddle(), sr.func_78326_a() / 2 - 12, sr.func_78328_b() / 2 + 8, 1.5f);
            this.drawScreenItemStack((ItemStack)this.screenItems.getRight(), sr.func_78326_a() / 2 - 8 + 16, sr.func_78328_b() / 2 + 8, 1.5f);
        }
        String msg = I18n.func_135052_a((String)("tropicraft.loading.title." + (this.isLeaving ? "greeting" : "farewell")), (Object[])new Object[0]);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(sr.func_78326_a() / 2 - f.func_78256_a(msg) / 2), (float)(sr.func_78328_b() / 4 - 30), (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-(f.func_78256_a(msg) / 4)), (float)0.0f, (float)0.0f);
        f.func_175063_a(msg, 0.0f, 0.0f, 6618263);
        GlStateManager.func_179121_F();
        String subtitle = this.screenTitle;
        f.func_175063_a(subtitle, (float)(sr.func_78326_a() / 2 - f.func_78256_a(subtitle) / 2), (float)sr.func_78328_b() / 1.2f + 5.0f, 16236374);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void drawScreenItemStack(ItemStack i, float x, float y, float scale) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74519_b();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.mc.func_175599_af().func_175042_a(i, 0, 0);
        GlStateManager.func_179121_F();
    }

    private void drawScreenEntity(Entity ent, float x, float y, float scale, float yaw, float pitch) {
        if (ent == null) {
            return;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)500.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f4 = 0.0f;
        float f3 = 0.0f;
        float f2 = 0.0f;
        float f1 = 0.0f;
        float f = 0.0f;
        if (ent instanceof EntityTropicraftWaterBase) {
            EntityTropicraftWaterBase fish = (EntityTropicraftWaterBase)ent;
            fish.swimYaw = -yaw;
            fish.swimPitch = pitch * 0.25f;
        }
        if (ent instanceof EntityLivingBase) {
            EntityLivingBase liv = (EntityLivingBase)ent;
            f = liv.field_70761_aq;
            f1 = liv.field_70177_z;
            f2 = liv.field_70125_A;
            f3 = liv.field_70758_at;
            f4 = liv.field_70759_as;
            liv.field_70761_aq = yaw;
            liv.field_70177_z = yaw;
            liv.field_70125_A = pitch;
            liv.field_70759_as = ent.field_70177_z;
            liv.field_70758_at = ent.field_70177_z;
        }
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = this.mc.func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a(ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        if (ent instanceof EntityLivingBase) {
            EntityLivingBase liv = (EntityLivingBase)ent;
            liv.field_70761_aq = f;
            liv.field_70177_z = f1;
            liv.field_70125_A = f2;
            liv.field_70758_at = f3;
            liv.field_70759_as = f4;
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void drawBackground(float width, float height) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        TropicraftRenderUtils.bindTextureGui(this.screenBackground);
        GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        float f = 32.0f;
        if (this.screenBackground.equals("loading_bg1")) {
            f = 128.0f;
        }
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexbuffer.func_181662_b(0.0, (double)height, 0.0).func_187315_a(0.0, (double)(height / f)).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a((double)(width / f), (double)(height / f)).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b((double)width, 0.0, 0.0).func_187315_a((double)(width / f), 0.0).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public Entity eggWrap(Entity e, int s) {
        if (this.rand.nextInt(40) == 0 && s == 0 || this.isEgg) {
            EntityKoaHunter koa = new EntityKoaHunter(e.field_70170_p);
            koa.setDancing(true);
            koa.func_70095_a(true);
            koa.field_70173_aa = this.rand.nextInt(50);
            this.isEgg = !this.isEgg;
            return koa;
        }
        return e;
    }
}

